// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitAntiRansomwareSuspectGetReader is a Reader for the StorageUnitAntiRansomwareSuspectGet structure.
type StorageUnitAntiRansomwareSuspectGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitAntiRansomwareSuspectGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageUnitAntiRansomwareSuspectGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitAntiRansomwareSuspectGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitAntiRansomwareSuspectGetOK creates a StorageUnitAntiRansomwareSuspectGetOK with default headers values
func NewStorageUnitAntiRansomwareSuspectGetOK() *StorageUnitAntiRansomwareSuspectGetOK {
	return &StorageUnitAntiRansomwareSuspectGetOK{}
}

/*
StorageUnitAntiRansomwareSuspectGetOK describes a response with status code 200, with default header values.

OK
*/
type StorageUnitAntiRansomwareSuspectGetOK struct {
	Payload *models.StorageUnitAntiRansomwareSuspect
}

// IsSuccess returns true when this storage unit anti ransomware suspect get o k response has a 2xx status code
func (o *StorageUnitAntiRansomwareSuspectGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit anti ransomware suspect get o k response has a 3xx status code
func (o *StorageUnitAntiRansomwareSuspectGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit anti ransomware suspect get o k response has a 4xx status code
func (o *StorageUnitAntiRansomwareSuspectGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit anti ransomware suspect get o k response has a 5xx status code
func (o *StorageUnitAntiRansomwareSuspectGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit anti ransomware suspect get o k response a status code equal to that given
func (o *StorageUnitAntiRansomwareSuspectGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage unit anti ransomware suspect get o k response
func (o *StorageUnitAntiRansomwareSuspectGetOK) Code() int {
	return 200
}

func (o *StorageUnitAntiRansomwareSuspectGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}][%d] storageUnitAntiRansomwareSuspectGetOK %s", 200, payload)
}

func (o *StorageUnitAntiRansomwareSuspectGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}][%d] storageUnitAntiRansomwareSuspectGetOK %s", 200, payload)
}

func (o *StorageUnitAntiRansomwareSuspectGetOK) GetPayload() *models.StorageUnitAntiRansomwareSuspect {
	return o.Payload
}

func (o *StorageUnitAntiRansomwareSuspectGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitAntiRansomwareSuspect)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitAntiRansomwareSuspectGetDefault creates a StorageUnitAntiRansomwareSuspectGetDefault with default headers values
func NewStorageUnitAntiRansomwareSuspectGetDefault(code int) *StorageUnitAntiRansomwareSuspectGetDefault {
	return &StorageUnitAntiRansomwareSuspectGetDefault{
		_statusCode: code,
	}
}

/*
StorageUnitAntiRansomwareSuspectGetDefault describes a response with status code -1, with default header values.

Error
*/
type StorageUnitAntiRansomwareSuspectGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit anti ransomware suspect get default response has a 2xx status code
func (o *StorageUnitAntiRansomwareSuspectGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit anti ransomware suspect get default response has a 3xx status code
func (o *StorageUnitAntiRansomwareSuspectGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit anti ransomware suspect get default response has a 4xx status code
func (o *StorageUnitAntiRansomwareSuspectGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit anti ransomware suspect get default response has a 5xx status code
func (o *StorageUnitAntiRansomwareSuspectGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit anti ransomware suspect get default response a status code equal to that given
func (o *StorageUnitAntiRansomwareSuspectGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit anti ransomware suspect get default response
func (o *StorageUnitAntiRansomwareSuspectGetDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitAntiRansomwareSuspectGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}][%d] storage_unit_anti_ransomware_suspect_get default %s", o._statusCode, payload)
}

func (o *StorageUnitAntiRansomwareSuspectGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}][%d] storage_unit_anti_ransomware_suspect_get default %s", o._statusCode, payload)
}

func (o *StorageUnitAntiRansomwareSuspectGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitAntiRansomwareSuspectGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
