// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSupportedAlgorithmsGetParams creates a new SupportedAlgorithmsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSupportedAlgorithmsGetParams() *SupportedAlgorithmsGetParams {
	return &SupportedAlgorithmsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSupportedAlgorithmsGetParamsWithTimeout creates a new SupportedAlgorithmsGetParams object
// with the ability to set a timeout on a request.
func NewSupportedAlgorithmsGetParamsWithTimeout(timeout time.Duration) *SupportedAlgorithmsGetParams {
	return &SupportedAlgorithmsGetParams{
		timeout: timeout,
	}
}

// NewSupportedAlgorithmsGetParamsWithContext creates a new SupportedAlgorithmsGetParams object
// with the ability to set a context for a request.
func NewSupportedAlgorithmsGetParamsWithContext(ctx context.Context) *SupportedAlgorithmsGetParams {
	return &SupportedAlgorithmsGetParams{
		Context: ctx,
	}
}

// NewSupportedAlgorithmsGetParamsWithHTTPClient creates a new SupportedAlgorithmsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSupportedAlgorithmsGetParamsWithHTTPClient(client *http.Client) *SupportedAlgorithmsGetParams {
	return &SupportedAlgorithmsGetParams{
		HTTPClient: client,
	}
}

/*
SupportedAlgorithmsGetParams contains all the parameters to send to the API endpoint

	for the supported algorithms get operation.

	Typically these are written to a http.Request.
*/
type SupportedAlgorithmsGetParams struct {

	/* AlgorithmName.

	   Algorithm name.
	*/
	AlgorithmName string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* OwnerUUID.

	   Used to identify a cluster or an SVM.
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the supported algorithms get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SupportedAlgorithmsGetParams) WithDefaults() *SupportedAlgorithmsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the supported algorithms get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SupportedAlgorithmsGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) WithTimeout(timeout time.Duration) *SupportedAlgorithmsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) WithContext(ctx context.Context) *SupportedAlgorithmsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) WithHTTPClient(client *http.Client) *SupportedAlgorithmsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAlgorithmName adds the algorithmName to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) WithAlgorithmName(algorithmName string) *SupportedAlgorithmsGetParams {
	o.SetAlgorithmName(algorithmName)
	return o
}

// SetAlgorithmName adds the algorithmName to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) SetAlgorithmName(algorithmName string) {
	o.AlgorithmName = algorithmName
}

// WithFields adds the fields to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) WithFields(fields []string) *SupportedAlgorithmsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithOwnerUUID adds the ownerUUID to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) WithOwnerUUID(ownerUUID string) *SupportedAlgorithmsGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the supported algorithms get params
func (o *SupportedAlgorithmsGetParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SupportedAlgorithmsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param algorithm.name
	if err := r.SetPathParam("algorithm.name", o.AlgorithmName); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSupportedAlgorithmsGet binds the parameter fields
func (o *SupportedAlgorithmsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
