// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSvmSSHServerModifyCollectionParams creates a new SvmSSHServerModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSvmSSHServerModifyCollectionParams() *SvmSSHServerModifyCollectionParams {
	return &SvmSSHServerModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSvmSSHServerModifyCollectionParamsWithTimeout creates a new SvmSSHServerModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewSvmSSHServerModifyCollectionParamsWithTimeout(timeout time.Duration) *SvmSSHServerModifyCollectionParams {
	return &SvmSSHServerModifyCollectionParams{
		timeout: timeout,
	}
}

// NewSvmSSHServerModifyCollectionParamsWithContext creates a new SvmSSHServerModifyCollectionParams object
// with the ability to set a context for a request.
func NewSvmSSHServerModifyCollectionParamsWithContext(ctx context.Context) *SvmSSHServerModifyCollectionParams {
	return &SvmSSHServerModifyCollectionParams{
		Context: ctx,
	}
}

// NewSvmSSHServerModifyCollectionParamsWithHTTPClient creates a new SvmSSHServerModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSvmSSHServerModifyCollectionParamsWithHTTPClient(client *http.Client) *SvmSSHServerModifyCollectionParams {
	return &SvmSSHServerModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
SvmSSHServerModifyCollectionParams contains all the parameters to send to the API endpoint

	for the svm ssh server modify collection operation.

	Typically these are written to a http.Request.
*/
type SvmSSHServerModifyCollectionParams struct {

	/* Ciphers.

	   Filter by ciphers
	*/
	Ciphers *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* HostKeyAlgorithms.

	   Filter by host_key_algorithms
	*/
	HostKeyAlgorithms *string

	/* Info.

	   Info specification
	*/
	Info SvmSSHServerModifyCollectionBody

	/* IsRsaInPublickeyAlgorithmsEnabled.

	   Filter by is_rsa_in_publickey_algorithms_enabled
	*/
	IsRsaInPublickeyAlgorithmsEnabled *bool

	/* KeyExchangeAlgorithms.

	   Filter by key_exchange_algorithms
	*/
	KeyExchangeAlgorithms *string

	/* LoginGraceTime.

	   Filter by login_grace_time
	*/
	LoginGraceTime *int64

	/* MacAlgorithms.

	   Filter by mac_algorithms
	*/
	MacAlgorithms *string

	/* MaxAuthenticationRetryCount.

	   Filter by max_authentication_retry_count
	*/
	MaxAuthenticationRetryCount *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the svm ssh server modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmSSHServerModifyCollectionParams) WithDefaults() *SvmSSHServerModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the svm ssh server modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmSSHServerModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SvmSSHServerModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithTimeout(timeout time.Duration) *SvmSSHServerModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithContext(ctx context.Context) *SvmSSHServerModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithHTTPClient(client *http.Client) *SvmSSHServerModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCiphers adds the ciphers to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithCiphers(ciphers *string) *SvmSSHServerModifyCollectionParams {
	o.SetCiphers(ciphers)
	return o
}

// SetCiphers adds the ciphers to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetCiphers(ciphers *string) {
	o.Ciphers = ciphers
}

// WithContinueOnFailure adds the continueOnFailure to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SvmSSHServerModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithHostKeyAlgorithms adds the hostKeyAlgorithms to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithHostKeyAlgorithms(hostKeyAlgorithms *string) *SvmSSHServerModifyCollectionParams {
	o.SetHostKeyAlgorithms(hostKeyAlgorithms)
	return o
}

// SetHostKeyAlgorithms adds the hostKeyAlgorithms to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetHostKeyAlgorithms(hostKeyAlgorithms *string) {
	o.HostKeyAlgorithms = hostKeyAlgorithms
}

// WithInfo adds the info to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithInfo(info SvmSSHServerModifyCollectionBody) *SvmSSHServerModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetInfo(info SvmSSHServerModifyCollectionBody) {
	o.Info = info
}

// WithIsRsaInPublickeyAlgorithmsEnabled adds the isRsaInPublickeyAlgorithmsEnabled to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithIsRsaInPublickeyAlgorithmsEnabled(isRsaInPublickeyAlgorithmsEnabled *bool) *SvmSSHServerModifyCollectionParams {
	o.SetIsRsaInPublickeyAlgorithmsEnabled(isRsaInPublickeyAlgorithmsEnabled)
	return o
}

// SetIsRsaInPublickeyAlgorithmsEnabled adds the isRsaInPublickeyAlgorithmsEnabled to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetIsRsaInPublickeyAlgorithmsEnabled(isRsaInPublickeyAlgorithmsEnabled *bool) {
	o.IsRsaInPublickeyAlgorithmsEnabled = isRsaInPublickeyAlgorithmsEnabled
}

// WithKeyExchangeAlgorithms adds the keyExchangeAlgorithms to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithKeyExchangeAlgorithms(keyExchangeAlgorithms *string) *SvmSSHServerModifyCollectionParams {
	o.SetKeyExchangeAlgorithms(keyExchangeAlgorithms)
	return o
}

// SetKeyExchangeAlgorithms adds the keyExchangeAlgorithms to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetKeyExchangeAlgorithms(keyExchangeAlgorithms *string) {
	o.KeyExchangeAlgorithms = keyExchangeAlgorithms
}

// WithLoginGraceTime adds the loginGraceTime to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithLoginGraceTime(loginGraceTime *int64) *SvmSSHServerModifyCollectionParams {
	o.SetLoginGraceTime(loginGraceTime)
	return o
}

// SetLoginGraceTime adds the loginGraceTime to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetLoginGraceTime(loginGraceTime *int64) {
	o.LoginGraceTime = loginGraceTime
}

// WithMacAlgorithms adds the macAlgorithms to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithMacAlgorithms(macAlgorithms *string) *SvmSSHServerModifyCollectionParams {
	o.SetMacAlgorithms(macAlgorithms)
	return o
}

// SetMacAlgorithms adds the macAlgorithms to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetMacAlgorithms(macAlgorithms *string) {
	o.MacAlgorithms = macAlgorithms
}

// WithMaxAuthenticationRetryCount adds the maxAuthenticationRetryCount to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithMaxAuthenticationRetryCount(maxAuthenticationRetryCount *int64) *SvmSSHServerModifyCollectionParams {
	o.SetMaxAuthenticationRetryCount(maxAuthenticationRetryCount)
	return o
}

// SetMaxAuthenticationRetryCount adds the maxAuthenticationRetryCount to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetMaxAuthenticationRetryCount(maxAuthenticationRetryCount *int64) {
	o.MaxAuthenticationRetryCount = maxAuthenticationRetryCount
}

// WithReturnRecords adds the returnRecords to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithReturnRecords(returnRecords *bool) *SvmSSHServerModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *SvmSSHServerModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithSerialRecords(serialRecords *bool) *SvmSSHServerModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithSvmName(svmName *string) *SvmSSHServerModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) WithSvmUUID(svmUUID *string) *SvmSSHServerModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the svm ssh server modify collection params
func (o *SvmSSHServerModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SvmSSHServerModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ciphers != nil {

		// query param ciphers
		var qrCiphers string

		if o.Ciphers != nil {
			qrCiphers = *o.Ciphers
		}
		qCiphers := qrCiphers
		if qCiphers != "" {

			if err := r.SetQueryParam("ciphers", qCiphers); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.HostKeyAlgorithms != nil {

		// query param host_key_algorithms
		var qrHostKeyAlgorithms string

		if o.HostKeyAlgorithms != nil {
			qrHostKeyAlgorithms = *o.HostKeyAlgorithms
		}
		qHostKeyAlgorithms := qrHostKeyAlgorithms
		if qHostKeyAlgorithms != "" {

			if err := r.SetQueryParam("host_key_algorithms", qHostKeyAlgorithms); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IsRsaInPublickeyAlgorithmsEnabled != nil {

		// query param is_rsa_in_publickey_algorithms_enabled
		var qrIsRsaInPublickeyAlgorithmsEnabled bool

		if o.IsRsaInPublickeyAlgorithmsEnabled != nil {
			qrIsRsaInPublickeyAlgorithmsEnabled = *o.IsRsaInPublickeyAlgorithmsEnabled
		}
		qIsRsaInPublickeyAlgorithmsEnabled := swag.FormatBool(qrIsRsaInPublickeyAlgorithmsEnabled)
		if qIsRsaInPublickeyAlgorithmsEnabled != "" {

			if err := r.SetQueryParam("is_rsa_in_publickey_algorithms_enabled", qIsRsaInPublickeyAlgorithmsEnabled); err != nil {
				return err
			}
		}
	}

	if o.KeyExchangeAlgorithms != nil {

		// query param key_exchange_algorithms
		var qrKeyExchangeAlgorithms string

		if o.KeyExchangeAlgorithms != nil {
			qrKeyExchangeAlgorithms = *o.KeyExchangeAlgorithms
		}
		qKeyExchangeAlgorithms := qrKeyExchangeAlgorithms
		if qKeyExchangeAlgorithms != "" {

			if err := r.SetQueryParam("key_exchange_algorithms", qKeyExchangeAlgorithms); err != nil {
				return err
			}
		}
	}

	if o.LoginGraceTime != nil {

		// query param login_grace_time
		var qrLoginGraceTime int64

		if o.LoginGraceTime != nil {
			qrLoginGraceTime = *o.LoginGraceTime
		}
		qLoginGraceTime := swag.FormatInt64(qrLoginGraceTime)
		if qLoginGraceTime != "" {

			if err := r.SetQueryParam("login_grace_time", qLoginGraceTime); err != nil {
				return err
			}
		}
	}

	if o.MacAlgorithms != nil {

		// query param mac_algorithms
		var qrMacAlgorithms string

		if o.MacAlgorithms != nil {
			qrMacAlgorithms = *o.MacAlgorithms
		}
		qMacAlgorithms := qrMacAlgorithms
		if qMacAlgorithms != "" {

			if err := r.SetQueryParam("mac_algorithms", qMacAlgorithms); err != nil {
				return err
			}
		}
	}

	if o.MaxAuthenticationRetryCount != nil {

		// query param max_authentication_retry_count
		var qrMaxAuthenticationRetryCount int64

		if o.MaxAuthenticationRetryCount != nil {
			qrMaxAuthenticationRetryCount = *o.MaxAuthenticationRetryCount
		}
		qMaxAuthenticationRetryCount := swag.FormatInt64(qrMaxAuthenticationRetryCount)
		if qMaxAuthenticationRetryCount != "" {

			if err := r.SetQueryParam("max_authentication_retry_count", qMaxAuthenticationRetryCount); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
