// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewTotpCreateParams creates a new TotpCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTotpCreateParams() *TotpCreateParams {
	return &TotpCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTotpCreateParamsWithTimeout creates a new TotpCreateParams object
// with the ability to set a timeout on a request.
func NewTotpCreateParamsWithTimeout(timeout time.Duration) *TotpCreateParams {
	return &TotpCreateParams{
		timeout: timeout,
	}
}

// NewTotpCreateParamsWithContext creates a new TotpCreateParams object
// with the ability to set a context for a request.
func NewTotpCreateParamsWithContext(ctx context.Context) *TotpCreateParams {
	return &TotpCreateParams{
		Context: ctx,
	}
}

// NewTotpCreateParamsWithHTTPClient creates a new TotpCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewTotpCreateParamsWithHTTPClient(client *http.Client) *TotpCreateParams {
	return &TotpCreateParams{
		HTTPClient: client,
	}
}

/*
TotpCreateParams contains all the parameters to send to the API endpoint

	for the totp create operation.

	Typically these are written to a http.Request.
*/
type TotpCreateParams struct {

	/* Info.

	   TOTP profile details for the user account.
	*/
	Info *models.Totp

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the totp create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TotpCreateParams) WithDefaults() *TotpCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the totp create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TotpCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := TotpCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the totp create params
func (o *TotpCreateParams) WithTimeout(timeout time.Duration) *TotpCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the totp create params
func (o *TotpCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the totp create params
func (o *TotpCreateParams) WithContext(ctx context.Context) *TotpCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the totp create params
func (o *TotpCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the totp create params
func (o *TotpCreateParams) WithHTTPClient(client *http.Client) *TotpCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the totp create params
func (o *TotpCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the totp create params
func (o *TotpCreateParams) WithInfo(info *models.Totp) *TotpCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the totp create params
func (o *TotpCreateParams) SetInfo(info *models.Totp) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the totp create params
func (o *TotpCreateParams) WithReturnRecords(returnRecords *bool) *TotpCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the totp create params
func (o *TotpCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *TotpCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
