// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewTotpGetParams creates a new TotpGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTotpGetParams() *TotpGetParams {
	return &TotpGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTotpGetParamsWithTimeout creates a new TotpGetParams object
// with the ability to set a timeout on a request.
func NewTotpGetParamsWithTimeout(timeout time.Duration) *TotpGetParams {
	return &TotpGetParams{
		timeout: timeout,
	}
}

// NewTotpGetParamsWithContext creates a new TotpGetParams object
// with the ability to set a context for a request.
func NewTotpGetParamsWithContext(ctx context.Context) *TotpGetParams {
	return &TotpGetParams{
		Context: ctx,
	}
}

// NewTotpGetParamsWithHTTPClient creates a new TotpGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewTotpGetParamsWithHTTPClient(client *http.Client) *TotpGetParams {
	return &TotpGetParams{
		HTTPClient: client,
	}
}

/*
TotpGetParams contains all the parameters to send to the API endpoint

	for the totp get operation.

	Typically these are written to a http.Request.
*/
type TotpGetParams struct {

	/* AccountName.

	   Account user name.
	*/
	AccountName string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* OwnerUUID.

	   Account owner UUID.
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the totp get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TotpGetParams) WithDefaults() *TotpGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the totp get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TotpGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the totp get params
func (o *TotpGetParams) WithTimeout(timeout time.Duration) *TotpGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the totp get params
func (o *TotpGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the totp get params
func (o *TotpGetParams) WithContext(ctx context.Context) *TotpGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the totp get params
func (o *TotpGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the totp get params
func (o *TotpGetParams) WithHTTPClient(client *http.Client) *TotpGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the totp get params
func (o *TotpGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the totp get params
func (o *TotpGetParams) WithAccountName(accountName string) *TotpGetParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the totp get params
func (o *TotpGetParams) SetAccountName(accountName string) {
	o.AccountName = accountName
}

// WithFields adds the fields to the totp get params
func (o *TotpGetParams) WithFields(fields []string) *TotpGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the totp get params
func (o *TotpGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithOwnerUUID adds the ownerUUID to the totp get params
func (o *TotpGetParams) WithOwnerUUID(ownerUUID string) *TotpGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the totp get params
func (o *TotpGetParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *TotpGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param account.name
	if err := r.SetPathParam("account.name", o.AccountName); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamTotpGet binds the parameter fields
func (o *TotpGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
