// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewTotpModifyCollectionParams creates a new TotpModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTotpModifyCollectionParams() *TotpModifyCollectionParams {
	return &TotpModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTotpModifyCollectionParamsWithTimeout creates a new TotpModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewTotpModifyCollectionParamsWithTimeout(timeout time.Duration) *TotpModifyCollectionParams {
	return &TotpModifyCollectionParams{
		timeout: timeout,
	}
}

// NewTotpModifyCollectionParamsWithContext creates a new TotpModifyCollectionParams object
// with the ability to set a context for a request.
func NewTotpModifyCollectionParamsWithContext(ctx context.Context) *TotpModifyCollectionParams {
	return &TotpModifyCollectionParams{
		Context: ctx,
	}
}

// NewTotpModifyCollectionParamsWithHTTPClient creates a new TotpModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewTotpModifyCollectionParamsWithHTTPClient(client *http.Client) *TotpModifyCollectionParams {
	return &TotpModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
TotpModifyCollectionParams contains all the parameters to send to the API endpoint

	for the totp modify collection operation.

	Typically these are written to a http.Request.
*/
type TotpModifyCollectionParams struct {

	/* AccountName.

	   Filter by account.name
	*/
	AccountName *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info TotpModifyCollectionBody

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* ShaFingerprint.

	   Filter by sha_fingerprint
	*/
	ShaFingerprint *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the totp modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TotpModifyCollectionParams) WithDefaults() *TotpModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the totp modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TotpModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := TotpModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the totp modify collection params
func (o *TotpModifyCollectionParams) WithTimeout(timeout time.Duration) *TotpModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the totp modify collection params
func (o *TotpModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the totp modify collection params
func (o *TotpModifyCollectionParams) WithContext(ctx context.Context) *TotpModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the totp modify collection params
func (o *TotpModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the totp modify collection params
func (o *TotpModifyCollectionParams) WithHTTPClient(client *http.Client) *TotpModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the totp modify collection params
func (o *TotpModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the totp modify collection params
func (o *TotpModifyCollectionParams) WithAccountName(accountName *string) *TotpModifyCollectionParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the totp modify collection params
func (o *TotpModifyCollectionParams) SetAccountName(accountName *string) {
	o.AccountName = accountName
}

// WithComment adds the comment to the totp modify collection params
func (o *TotpModifyCollectionParams) WithComment(comment *string) *TotpModifyCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the totp modify collection params
func (o *TotpModifyCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the totp modify collection params
func (o *TotpModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *TotpModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the totp modify collection params
func (o *TotpModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the totp modify collection params
func (o *TotpModifyCollectionParams) WithEnabled(enabled *bool) *TotpModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the totp modify collection params
func (o *TotpModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the totp modify collection params
func (o *TotpModifyCollectionParams) WithInfo(info TotpModifyCollectionBody) *TotpModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the totp modify collection params
func (o *TotpModifyCollectionParams) SetInfo(info TotpModifyCollectionBody) {
	o.Info = info
}

// WithOwnerName adds the ownerName to the totp modify collection params
func (o *TotpModifyCollectionParams) WithOwnerName(ownerName *string) *TotpModifyCollectionParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the totp modify collection params
func (o *TotpModifyCollectionParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the totp modify collection params
func (o *TotpModifyCollectionParams) WithOwnerUUID(ownerUUID *string) *TotpModifyCollectionParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the totp modify collection params
func (o *TotpModifyCollectionParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the totp modify collection params
func (o *TotpModifyCollectionParams) WithReturnRecords(returnRecords *bool) *TotpModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the totp modify collection params
func (o *TotpModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the totp modify collection params
func (o *TotpModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *TotpModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the totp modify collection params
func (o *TotpModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the totp modify collection params
func (o *TotpModifyCollectionParams) WithScope(scope *string) *TotpModifyCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the totp modify collection params
func (o *TotpModifyCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the totp modify collection params
func (o *TotpModifyCollectionParams) WithSerialRecords(serialRecords *bool) *TotpModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the totp modify collection params
func (o *TotpModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithShaFingerprint adds the shaFingerprint to the totp modify collection params
func (o *TotpModifyCollectionParams) WithShaFingerprint(shaFingerprint *string) *TotpModifyCollectionParams {
	o.SetShaFingerprint(shaFingerprint)
	return o
}

// SetShaFingerprint adds the shaFingerprint to the totp modify collection params
func (o *TotpModifyCollectionParams) SetShaFingerprint(shaFingerprint *string) {
	o.ShaFingerprint = shaFingerprint
}

// WriteToRequest writes these params to a swagger request
func (o *TotpModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccountName != nil {

		// query param account.name
		var qrAccountName string

		if o.AccountName != nil {
			qrAccountName = *o.AccountName
		}
		qAccountName := qrAccountName
		if qAccountName != "" {

			if err := r.SetQueryParam("account.name", qAccountName); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.ShaFingerprint != nil {

		// query param sha_fingerprint
		var qrShaFingerprint string

		if o.ShaFingerprint != nil {
			qrShaFingerprint = *o.ShaFingerprint
		}
		qShaFingerprint := qrShaFingerprint
		if qShaFingerprint != "" {

			if err := r.SetQueryParam("sha_fingerprint", qShaFingerprint); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
