// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewTotpModifyParams creates a new TotpModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTotpModifyParams() *TotpModifyParams {
	return &TotpModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTotpModifyParamsWithTimeout creates a new TotpModifyParams object
// with the ability to set a timeout on a request.
func NewTotpModifyParamsWithTimeout(timeout time.Duration) *TotpModifyParams {
	return &TotpModifyParams{
		timeout: timeout,
	}
}

// NewTotpModifyParamsWithContext creates a new TotpModifyParams object
// with the ability to set a context for a request.
func NewTotpModifyParamsWithContext(ctx context.Context) *TotpModifyParams {
	return &TotpModifyParams{
		Context: ctx,
	}
}

// NewTotpModifyParamsWithHTTPClient creates a new TotpModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewTotpModifyParamsWithHTTPClient(client *http.Client) *TotpModifyParams {
	return &TotpModifyParams{
		HTTPClient: client,
	}
}

/*
TotpModifyParams contains all the parameters to send to the API endpoint

	for the totp modify operation.

	Typically these are written to a http.Request.
*/
type TotpModifyParams struct {

	/* AccountName.

	   User account name
	*/
	AccountName string

	/* Info.

	   TOTP modification details.
	*/
	Info *models.Totp

	/* OwnerUUID.

	   Account owner UUID
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the totp modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TotpModifyParams) WithDefaults() *TotpModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the totp modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TotpModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the totp modify params
func (o *TotpModifyParams) WithTimeout(timeout time.Duration) *TotpModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the totp modify params
func (o *TotpModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the totp modify params
func (o *TotpModifyParams) WithContext(ctx context.Context) *TotpModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the totp modify params
func (o *TotpModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the totp modify params
func (o *TotpModifyParams) WithHTTPClient(client *http.Client) *TotpModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the totp modify params
func (o *TotpModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the totp modify params
func (o *TotpModifyParams) WithAccountName(accountName string) *TotpModifyParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the totp modify params
func (o *TotpModifyParams) SetAccountName(accountName string) {
	o.AccountName = accountName
}

// WithInfo adds the info to the totp modify params
func (o *TotpModifyParams) WithInfo(info *models.Totp) *TotpModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the totp modify params
func (o *TotpModifyParams) SetInfo(info *models.Totp) {
	o.Info = info
}

// WithOwnerUUID adds the ownerUUID to the totp modify params
func (o *TotpModifyParams) WithOwnerUUID(ownerUUID string) *TotpModifyParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the totp modify params
func (o *TotpModifyParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *TotpModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param account.name
	if err := r.SetPathParam("account.name", o.AccountName); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
