// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// TotpModifyReader is a Reader for the TotpModify structure.
type TotpModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TotpModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTotpModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewTotpModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewTotpModifyOK creates a TotpModifyOK with default headers values
func NewTotpModifyOK() *TotpModifyOK {
	return &TotpModifyOK{}
}

/*
TotpModifyOK describes a response with status code 200, with default header values.

OK
*/
type TotpModifyOK struct {
}

// IsSuccess returns true when this totp modify o k response has a 2xx status code
func (o *TotpModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this totp modify o k response has a 3xx status code
func (o *TotpModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this totp modify o k response has a 4xx status code
func (o *TotpModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this totp modify o k response has a 5xx status code
func (o *TotpModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this totp modify o k response a status code equal to that given
func (o *TotpModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the totp modify o k response
func (o *TotpModifyOK) Code() int {
	return 200
}

func (o *TotpModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/login/totps/{owner.uuid}/{account.name}][%d] totpModifyOK", 200)
}

func (o *TotpModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/login/totps/{owner.uuid}/{account.name}][%d] totpModifyOK", 200)
}

func (o *TotpModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTotpModifyDefault creates a TotpModifyDefault with default headers values
func NewTotpModifyDefault(code int) *TotpModifyDefault {
	return &TotpModifyDefault{
		_statusCode: code,
	}
}

/*
	TotpModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 144834564 | Only users with the admin role are allowed to modify the TOTP status. |
| 144834565 | Invalid option for the field -enabled |
| 144834566 | The user does not have a TOTP configuration available for modification. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type TotpModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this totp modify default response has a 2xx status code
func (o *TotpModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this totp modify default response has a 3xx status code
func (o *TotpModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this totp modify default response has a 4xx status code
func (o *TotpModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this totp modify default response has a 5xx status code
func (o *TotpModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this totp modify default response a status code equal to that given
func (o *TotpModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the totp modify default response
func (o *TotpModifyDefault) Code() int {
	return o._statusCode
}

func (o *TotpModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/login/totps/{owner.uuid}/{account.name}][%d] totp_modify default %s", o._statusCode, payload)
}

func (o *TotpModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/login/totps/{owner.uuid}/{account.name}][%d] totp_modify default %s", o._statusCode, payload)
}

func (o *TotpModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TotpModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
