// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WebauthnCredentialsDeleteCollectionReader is a Reader for the WebauthnCredentialsDeleteCollection structure.
type WebauthnCredentialsDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WebauthnCredentialsDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWebauthnCredentialsDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWebauthnCredentialsDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWebauthnCredentialsDeleteCollectionOK creates a WebauthnCredentialsDeleteCollectionOK with default headers values
func NewWebauthnCredentialsDeleteCollectionOK() *WebauthnCredentialsDeleteCollectionOK {
	return &WebauthnCredentialsDeleteCollectionOK{}
}

/*
WebauthnCredentialsDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type WebauthnCredentialsDeleteCollectionOK struct {
}

// IsSuccess returns true when this webauthn credentials delete collection o k response has a 2xx status code
func (o *WebauthnCredentialsDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this webauthn credentials delete collection o k response has a 3xx status code
func (o *WebauthnCredentialsDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this webauthn credentials delete collection o k response has a 4xx status code
func (o *WebauthnCredentialsDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this webauthn credentials delete collection o k response has a 5xx status code
func (o *WebauthnCredentialsDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this webauthn credentials delete collection o k response a status code equal to that given
func (o *WebauthnCredentialsDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the webauthn credentials delete collection o k response
func (o *WebauthnCredentialsDeleteCollectionOK) Code() int {
	return 200
}

func (o *WebauthnCredentialsDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/webauthn/credentials][%d] webauthnCredentialsDeleteCollectionOK", 200)
}

func (o *WebauthnCredentialsDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/webauthn/credentials][%d] webauthnCredentialsDeleteCollectionOK", 200)
}

func (o *WebauthnCredentialsDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWebauthnCredentialsDeleteCollectionDefault creates a WebauthnCredentialsDeleteCollectionDefault with default headers values
func NewWebauthnCredentialsDeleteCollectionDefault(code int) *WebauthnCredentialsDeleteCollectionDefault {
	return &WebauthnCredentialsDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
WebauthnCredentialsDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type WebauthnCredentialsDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this webauthn credentials delete collection default response has a 2xx status code
func (o *WebauthnCredentialsDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this webauthn credentials delete collection default response has a 3xx status code
func (o *WebauthnCredentialsDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this webauthn credentials delete collection default response has a 4xx status code
func (o *WebauthnCredentialsDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this webauthn credentials delete collection default response has a 5xx status code
func (o *WebauthnCredentialsDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this webauthn credentials delete collection default response a status code equal to that given
func (o *WebauthnCredentialsDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the webauthn credentials delete collection default response
func (o *WebauthnCredentialsDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *WebauthnCredentialsDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/webauthn/credentials][%d] webauthn_credentials_delete_collection default %s", o._statusCode, payload)
}

func (o *WebauthnCredentialsDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/webauthn/credentials][%d] webauthn_credentials_delete_collection default %s", o._statusCode, payload)
}

func (o *WebauthnCredentialsDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WebauthnCredentialsDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
WebauthnCredentialsDeleteCollectionBody webauthn credentials delete collection body
swagger:model WebauthnCredentialsDeleteCollectionBody
*/
type WebauthnCredentialsDeleteCollectionBody struct {

	// webauthn credentials response inline records
	WebauthnCredentialsResponseInlineRecords []*models.WebauthnCredentials `json:"records,omitempty"`
}

// Validate validates this webauthn credentials delete collection body
func (o *WebauthnCredentialsDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateWebauthnCredentialsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WebauthnCredentialsDeleteCollectionBody) validateWebauthnCredentialsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.WebauthnCredentialsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.WebauthnCredentialsResponseInlineRecords); i++ {
		if swag.IsZero(o.WebauthnCredentialsResponseInlineRecords[i]) { // not required
			continue
		}

		if o.WebauthnCredentialsResponseInlineRecords[i] != nil {
			if err := o.WebauthnCredentialsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this webauthn credentials delete collection body based on the context it is used
func (o *WebauthnCredentialsDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateWebauthnCredentialsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WebauthnCredentialsDeleteCollectionBody) contextValidateWebauthnCredentialsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.WebauthnCredentialsResponseInlineRecords); i++ {

		if o.WebauthnCredentialsResponseInlineRecords[i] != nil {
			if err := o.WebauthnCredentialsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *WebauthnCredentialsDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WebauthnCredentialsDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res WebauthnCredentialsDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
