// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWebauthnGlobalGetParams creates a new WebauthnGlobalGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWebauthnGlobalGetParams() *WebauthnGlobalGetParams {
	return &WebauthnGlobalGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWebauthnGlobalGetParamsWithTimeout creates a new WebauthnGlobalGetParams object
// with the ability to set a timeout on a request.
func NewWebauthnGlobalGetParamsWithTimeout(timeout time.Duration) *WebauthnGlobalGetParams {
	return &WebauthnGlobalGetParams{
		timeout: timeout,
	}
}

// NewWebauthnGlobalGetParamsWithContext creates a new WebauthnGlobalGetParams object
// with the ability to set a context for a request.
func NewWebauthnGlobalGetParamsWithContext(ctx context.Context) *WebauthnGlobalGetParams {
	return &WebauthnGlobalGetParams{
		Context: ctx,
	}
}

// NewWebauthnGlobalGetParamsWithHTTPClient creates a new WebauthnGlobalGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWebauthnGlobalGetParamsWithHTTPClient(client *http.Client) *WebauthnGlobalGetParams {
	return &WebauthnGlobalGetParams{
		HTTPClient: client,
	}
}

/*
WebauthnGlobalGetParams contains all the parameters to send to the API endpoint

	for the webauthn global get operation.

	Typically these are written to a http.Request.
*/
type WebauthnGlobalGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* OwnerUUID.

	   Used to identify a cluster or an SVM.
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the webauthn global get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebauthnGlobalGetParams) WithDefaults() *WebauthnGlobalGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the webauthn global get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebauthnGlobalGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the webauthn global get params
func (o *WebauthnGlobalGetParams) WithTimeout(timeout time.Duration) *WebauthnGlobalGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the webauthn global get params
func (o *WebauthnGlobalGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the webauthn global get params
func (o *WebauthnGlobalGetParams) WithContext(ctx context.Context) *WebauthnGlobalGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the webauthn global get params
func (o *WebauthnGlobalGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the webauthn global get params
func (o *WebauthnGlobalGetParams) WithHTTPClient(client *http.Client) *WebauthnGlobalGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the webauthn global get params
func (o *WebauthnGlobalGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the webauthn global get params
func (o *WebauthnGlobalGetParams) WithFields(fields []string) *WebauthnGlobalGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the webauthn global get params
func (o *WebauthnGlobalGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithOwnerUUID adds the ownerUUID to the webauthn global get params
func (o *WebauthnGlobalGetParams) WithOwnerUUID(ownerUUID string) *WebauthnGlobalGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the webauthn global get params
func (o *WebauthnGlobalGetParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WebauthnGlobalGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWebauthnGlobalGet binds the parameter fields
func (o *WebauthnGlobalGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
