// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WhoamiGetReader is a Reader for the WhoamiGet structure.
type WhoamiGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WhoamiGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWhoamiGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWhoamiGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWhoamiGetOK creates a WhoamiGetOK with default headers values
func NewWhoamiGetOK() *WhoamiGetOK {
	return &WhoamiGetOK{}
}

/*
WhoamiGetOK describes a response with status code 200, with default header values.

OK
*/
type WhoamiGetOK struct {
	Payload *models.Whoami
}

// IsSuccess returns true when this whoami get o k response has a 2xx status code
func (o *WhoamiGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this whoami get o k response has a 3xx status code
func (o *WhoamiGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this whoami get o k response has a 4xx status code
func (o *WhoamiGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this whoami get o k response has a 5xx status code
func (o *WhoamiGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this whoami get o k response a status code equal to that given
func (o *WhoamiGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the whoami get o k response
func (o *WhoamiGetOK) Code() int {
	return 200
}

func (o *WhoamiGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/whoami][%d] whoamiGetOK %s", 200, payload)
}

func (o *WhoamiGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/whoami][%d] whoamiGetOK %s", 200, payload)
}

func (o *WhoamiGetOK) GetPayload() *models.Whoami {
	return o.Payload
}

func (o *WhoamiGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Whoami)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWhoamiGetDefault creates a WhoamiGetDefault with default headers values
func NewWhoamiGetDefault(code int) *WhoamiGetDefault {
	return &WhoamiGetDefault{
		_statusCode: code,
	}
}

/*
WhoamiGetDefault describes a response with status code -1, with default header values.

Error
*/
type WhoamiGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this whoami get default response has a 2xx status code
func (o *WhoamiGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this whoami get default response has a 3xx status code
func (o *WhoamiGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this whoami get default response has a 4xx status code
func (o *WhoamiGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this whoami get default response has a 5xx status code
func (o *WhoamiGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this whoami get default response a status code equal to that given
func (o *WhoamiGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the whoami get default response
func (o *WhoamiGetDefault) Code() int {
	return o._statusCode
}

func (o *WhoamiGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/whoami][%d] whoami_get default %s", o._statusCode, payload)
}

func (o *WhoamiGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/whoami][%d] whoami_get default %s", o._statusCode, payload)
}

func (o *WhoamiGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WhoamiGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
