// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new snaplock API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for snaplock API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	SnaplockComplianceClockCollectionGet(params *SnaplockComplianceClockCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockComplianceClockCollectionGetOK, error)

	SnaplockComplianceClockCreate(params *SnaplockComplianceClockCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockComplianceClockCreateCreated, error)

	SnaplockComplianceClockGet(params *SnaplockComplianceClockGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockComplianceClockGetOK, error)

	SnaplockFilePrivilegedDelete(params *SnaplockFilePrivilegedDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFilePrivilegedDeleteOK, *SnaplockFilePrivilegedDeleteAccepted, error)

	SnaplockFileRetentionGet(params *SnaplockFileRetentionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFileRetentionGetOK, error)

	SnaplockFileRetentionTimeModify(params *SnaplockFileRetentionTimeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFileRetentionTimeModifyOK, error)

	SnaplockFingerprintOperationCollectionGet(params *SnaplockFingerprintOperationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFingerprintOperationCollectionGetOK, error)

	SnaplockFingerprintOperationCreate(params *SnaplockFingerprintOperationCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFingerprintOperationCreateCreated, error)

	SnaplockFingerprintOperationDelete(params *SnaplockFingerprintOperationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFingerprintOperationDeleteOK, error)

	SnaplockFingerprintOperationDeleteCollection(params *SnaplockFingerprintOperationDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFingerprintOperationDeleteCollectionOK, error)

	SnaplockFingerprintOperationGet(params *SnaplockFingerprintOperationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFingerprintOperationGetOK, error)

	SnaplockLegalHoldBegin(params *SnaplockLegalHoldBeginParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldBeginCreated, error)

	SnaplockLegalHoldCollectionGet(params *SnaplockLegalHoldCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldCollectionGetOK, error)

	SnaplockLegalHoldCreate(params *SnaplockLegalHoldCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldCreateCreated, error)

	SnaplockLegalHoldDelete(params *SnaplockLegalHoldDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldDeleteOK, error)

	SnaplockLegalHoldDeleteCollection(params *SnaplockLegalHoldDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldDeleteCollectionOK, error)

	SnaplockLegalHoldFilesGet(params *SnaplockLegalHoldFilesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldFilesGetOK, error)

	SnaplockLegalHoldGet(params *SnaplockLegalHoldGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldGetOK, error)

	SnaplockLegalHoldInstanceGet(params *SnaplockLegalHoldInstanceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldInstanceGetOK, error)

	SnaplockLegalHoldOperationDelete(params *SnaplockLegalHoldOperationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldOperationDeleteOK, error)

	SnaplockLogCollectionGet(params *SnaplockLogCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogCollectionGetOK, error)

	SnaplockLogCreate(params *SnaplockLogCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogCreateCreated, *SnaplockLogCreateAccepted, error)

	SnaplockLogDelete(params *SnaplockLogDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogDeleteOK, *SnaplockLogDeleteAccepted, error)

	SnaplockLogDeleteCollection(params *SnaplockLogDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogDeleteCollectionOK, *SnaplockLogDeleteCollectionAccepted, error)

	SnaplockLogGet(params *SnaplockLogGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogGetOK, error)

	SnaplockLogModify(params *SnaplockLogModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogModifyOK, *SnaplockLogModifyAccepted, error)

	SnaplockLogModifyCollection(params *SnaplockLogModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogModifyCollectionOK, *SnaplockLogModifyCollectionAccepted, error)

	SnaplockRetentionOperationCollectionGet(params *SnaplockRetentionOperationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionOperationCollectionGetOK, error)

	SnaplockRetentionOperationCreate(params *SnaplockRetentionOperationCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionOperationCreateCreated, error)

	SnaplockRetentionOperationDelete(params *SnaplockRetentionOperationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionOperationDeleteOK, error)

	SnaplockRetentionOperationDeleteCollection(params *SnaplockRetentionOperationDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionOperationDeleteCollectionOK, error)

	SnaplockRetentionOperationGet(params *SnaplockRetentionOperationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionOperationGetOK, error)

	SnaplockRetentionPolicyCollectionGet(params *SnaplockRetentionPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyCollectionGetOK, error)

	SnaplockRetentionPolicyCreate(params *SnaplockRetentionPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyCreateCreated, error)

	SnaplockRetentionPolicyDelete(params *SnaplockRetentionPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyDeleteOK, error)

	SnaplockRetentionPolicyDeleteCollection(params *SnaplockRetentionPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyDeleteCollectionOK, error)

	SnaplockRetentionPolicyGet(params *SnaplockRetentionPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyGetOK, error)

	SnaplockRetentionPolicyModify(params *SnaplockRetentionPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyModifyOK, error)

	SnaplockRetentionPolicyModifyCollection(params *SnaplockRetentionPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyModifyCollectionOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	SnaplockComplianceClockCollectionGet Retrieves the SnapLock ComplianceClock for all of the nodes in the cluster.

### Related ONTAP commands
* `snaplock compliance-clock show`
### Learn more
* [`DOC /storage/snaplock/compliance-clocks`](#docs-snaplock-storage_snaplock_compliance-clocks)
*/
func (a *Client) SnaplockComplianceClockCollectionGet(params *SnaplockComplianceClockCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockComplianceClockCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockComplianceClockCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_compliance_clock_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/compliance-clocks",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockComplianceClockCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockComplianceClockCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockComplianceClockCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockComplianceClockCreate Initializes the SnapLock ComplianceClock.

### Required properties
* `node.name` or `node.uuid` - Name or UUID of the node.
### Related ONTAP commands
* `snaplock compliance-clock initialize`
### Learn more
* [`DOC /storage/snaplock/compliance-clocks`](#docs-snaplock-storage_snaplock_compliance-clocks)
*/
func (a *Client) SnaplockComplianceClockCreate(params *SnaplockComplianceClockCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockComplianceClockCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockComplianceClockCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_compliance_clock_create",
		Method:             "POST",
		PathPattern:        "/storage/snaplock/compliance-clocks",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockComplianceClockCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockComplianceClockCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockComplianceClockCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockComplianceClockGet Retrieves the SnapLock ComplianceClock for a specific node.

### Related ONTAP commands
* `snaplock compliance-clock show`
### Learn more
* [`DOC /storage/snaplock/compliance-clocks`](#docs-snaplock-storage_snaplock_compliance-clocks)
*/
func (a *Client) SnaplockComplianceClockGet(params *SnaplockComplianceClockGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockComplianceClockGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockComplianceClockGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_compliance_clock_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/compliance-clocks/{node.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockComplianceClockGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockComplianceClockGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockComplianceClockGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockFilePrivilegedDelete Deletes unexpired WORM files of a SnapLock Enterprise volume. This is a privileged-delete operation. The only built-in role that has access to the command is vsadmin-snaplock.

### Related ONTAP commands
* `volume file privileged-delete`
### Learn more
* [`DOC /storage/snaplock/file/{volume.uuid}/{path}`](#docs-snaplock-storage_snaplock_file_{volume.uuid}_{path})
*/
func (a *Client) SnaplockFilePrivilegedDelete(params *SnaplockFilePrivilegedDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFilePrivilegedDeleteOK, *SnaplockFilePrivilegedDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockFilePrivilegedDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_file_privileged_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/file/{volume.uuid}/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockFilePrivilegedDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnaplockFilePrivilegedDeleteOK:
		return value, nil, nil
	case *SnaplockFilePrivilegedDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockFilePrivilegedDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockFileRetentionGet Retrieves the SnapLock retention details of the specified file. An indefinite expiry time indicates the file is under a Legal-Hold.

### Related ONTAP commands
* `volume file retention show`
### Learn more
* [`DOC /storage/snaplock/file/{volume.uuid}/{path}`](#docs-snaplock-storage_snaplock_file_{volume.uuid}_{path})
*/
func (a *Client) SnaplockFileRetentionGet(params *SnaplockFileRetentionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFileRetentionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockFileRetentionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_file_retention_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/file/{volume.uuid}/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockFileRetentionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockFileRetentionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockFileRetentionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockFileRetentionTimeModify Updates the SnapLock retention time of a file or extends the retention time of a WORM file. Input parameters "expiry_time" or "retention_period" can be used to set or extend the retention time of file. Both "expiry_time" and "retention_period" parameters expect the date in ISO 8601 format. Additionally, the "expiry_time" parameter can also be set to "infinite" or "unspecified" and the "retention_period" parameter can also be set to "infinite". The input parameters are mutually exclusive.

### Related ONTAP commands
* `volume file retention set`
### Learn more
* [`DOC /storage/snaplock/file/{volume.uuid}/{path}`](#docs-snaplock-storage_snaplock_file_{volume.uuid}_{path})
*/
func (a *Client) SnaplockFileRetentionTimeModify(params *SnaplockFileRetentionTimeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFileRetentionTimeModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockFileRetentionTimeModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_file_retention_time_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/snaplock/file/{volume.uuid}/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockFileRetentionTimeModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockFileRetentionTimeModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockFileRetentionTimeModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockFingerprintOperationCollectionGet Retrieves a list of all the fingerprint operations of the specified SVM and volume.

### Related ONTAP commands
* `volume file fingerprint show`
### Example
<br/>
```
GET "/api/storage/snaplock/file-fingerprints/?svm.uuid=23940494-3f3a-11e9-8675-0050568e8f89&volume.uuid=36cdb58c-3f3a-11e9-8675-0050568e8f89"
```
<br/>
### Learn more
* [`DOC /storage/snaplock/file-fingerprints`](#docs-snaplock-storage_snaplock_file-fingerprints)
*/
func (a *Client) SnaplockFingerprintOperationCollectionGet(params *SnaplockFingerprintOperationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFingerprintOperationCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockFingerprintOperationCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_fingerprint_operation_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/file-fingerprints",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockFingerprintOperationCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockFingerprintOperationCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockFingerprintOperationCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockFingerprintOperationCreate Creates a fingerprint computation session on the file and returns a session-id. This session-id is a unique identifier that you can use to retrieve the progress of an ongoing fingerprint operation. When the operation is complete, you can use the session-id to retrieve the complete fingerprint output for the file .

### Required properties
* `svm.uuid` or `svm.name` - Name or UUID of the SVM.
* `volume.name` or `volume.uuid` - Name or UUID of the volume.
* `path` - Path of the file.
### Default property values
If not specified in POST, the follow default property values are assigned:
* `algorithm` - _sha256_
### Related ONTAP commands
* `volume file fingerprint start`
### Example
<br/>
```
POST "/api/storage/snaplock/file-fingerprints" '{"svm":{"uuid":"23940494-3f3a-11e9-8675-0050568e8f89"},"volume": {"uuid":"26cdb58c-3f3a-11e9-8675-0050568e8f89"},"path":"/vol/a1.txt","algorithm":"md5"}'
```
<br/>
### Learn more
* [`DOC /storage/snaplock/file-fingerprints`](#docs-snaplock-storage_snaplock_file-fingerprints)
*/
func (a *Client) SnaplockFingerprintOperationCreate(params *SnaplockFingerprintOperationCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFingerprintOperationCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockFingerprintOperationCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_fingerprint_operation_create",
		Method:             "POST",
		PathPattern:        "/storage/snaplock/file-fingerprints",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockFingerprintOperationCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockFingerprintOperationCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockFingerprintOperationCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockFingerprintOperationDelete Aborts an in-progress fingerprint operation. This API takes session-id as input and aborts the fingerprint operation that is associated with the specified session-id.

### Related ONTAP commands
* `volume file fingerprint abort`
### Learn more
* [`DOC /storage/snaplock/file-fingerprints`](#docs-snaplock-storage_snaplock_file-fingerprints)
*/
func (a *Client) SnaplockFingerprintOperationDelete(params *SnaplockFingerprintOperationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFingerprintOperationDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockFingerprintOperationDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_fingerprint_operation_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/file-fingerprints/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockFingerprintOperationDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockFingerprintOperationDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockFingerprintOperationDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnaplockFingerprintOperationDeleteCollection snaplock fingerprint operation delete collection API
*/
func (a *Client) SnaplockFingerprintOperationDeleteCollection(params *SnaplockFingerprintOperationDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFingerprintOperationDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockFingerprintOperationDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_fingerprint_operation_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/file-fingerprints",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockFingerprintOperationDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockFingerprintOperationDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockFingerprintOperationDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockFingerprintOperationGet Retrieves the file fingerprint information for a specific session ID.

### Related ONTAP commands
* `volume file fingerprint dump`
### Learn more
* [`DOC /storage/snaplock/file-fingerprints`](#docs-snaplock-storage_snaplock_file-fingerprints)
*/
func (a *Client) SnaplockFingerprintOperationGet(params *SnaplockFingerprintOperationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockFingerprintOperationGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockFingerprintOperationGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_fingerprint_operation_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/file-fingerprints/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockFingerprintOperationGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockFingerprintOperationGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockFingerprintOperationGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLegalHoldBegin Starts a  Legal-Hold.

### Required properties
* `path` - Path of the file.
* `name` - Litigation name.
* `volume.name` or `volume.uuid` - Name or UUID  of the volume.
### Related ONTAP commands
* `snaplock legal-hold begin`
### Example
<br/>
```
POST "/api/storage/snaplock/litigations" '{"volume.name":"SLC1","name":"l3","path":"/b.txt"}'
```
<br/>
### Learn more
* [`DOC /storage/snaplock/litigations`](#docs-snaplock-storage_snaplock_litigations)
*/
func (a *Client) SnaplockLegalHoldBegin(params *SnaplockLegalHoldBeginParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldBeginCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLegalHoldBeginParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_legal_hold_begin",
		Method:             "POST",
		PathPattern:        "/storage/snaplock/litigations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLegalHoldBeginReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLegalHoldBeginCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLegalHoldBeginDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLegalHoldCollectionGet Retrieves the list of litigations under an SVM.

### Related ONTAP commands
* `snaplock legal-hold show`
### Learn more
* [`DOC /storage/snaplock/litigations`](#docs-snaplock-storage_snaplock_litigations)
*/
func (a *Client) SnaplockLegalHoldCollectionGet(params *SnaplockLegalHoldCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLegalHoldCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_legal_hold_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/litigations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLegalHoldCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLegalHoldCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLegalHoldCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLegalHoldCreate Creates or removes litigations for the specified path.

### Required properties
* `type` - Legal-Hold operation type.
* `path` - Litigation path.
### Related ONTAP commands
* `snaplock legal-hold begin`
* `snaplock legal-hold end`
### Learn more
* [`DOC /storage/snaplock/litigations/{litigation.id}/operations`](#docs-snaplock-storage_snaplock_litigations_{litigation.id}_operations)
*/
func (a *Client) SnaplockLegalHoldCreate(params *SnaplockLegalHoldCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLegalHoldCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_legal_hold_create",
		Method:             "POST",
		PathPattern:        "/storage/snaplock/litigations/{litigation.id}/operations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLegalHoldCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLegalHoldCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLegalHoldCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLegalHoldDelete Creates a legal-hold end on all of the files for the specified litigation ID. This is only allowed when an operation is no longer in progress.

### Related ONTAP commands
* `snaplock legal-hold end`
### Example
<br/>
```
DELETE "/api/storage/snaplock/litigations/fd72e138-4bc3-11e9-a85f-0050568eb48f%3Al3"
```
<br/>
### Learn more
* [`DOC /storage/snaplock/litigations`](#docs-snaplock-storage_snaplock_litigations)
*/
func (a *Client) SnaplockLegalHoldDelete(params *SnaplockLegalHoldDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLegalHoldDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_legal_hold_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/litigations/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLegalHoldDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLegalHoldDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLegalHoldDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnaplockLegalHoldDeleteCollection snaplock legal hold delete collection API
*/
func (a *Client) SnaplockLegalHoldDeleteCollection(params *SnaplockLegalHoldDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLegalHoldDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_legal_hold_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/litigations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLegalHoldDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLegalHoldDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLegalHoldDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnaplockLegalHoldFilesGet Displays the list of files for the specified litigation ID.
*/
func (a *Client) SnaplockLegalHoldFilesGet(params *SnaplockLegalHoldFilesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldFilesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLegalHoldFilesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_legal_hold_files_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/litigations/{litigation.id}/files",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLegalHoldFilesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLegalHoldFilesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLegalHoldFilesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLegalHoldGet Retrieves the status of legal-hold for the specified operation ID.

### Related ONTAP commands
* `snaplock legal-hold show`
### Learn more
* [`DOC /storage/snaplock/litigations/{litigation.id}/operations`](#docs-snaplock-storage_snaplock_litigations_{litigation.id}_operations)
*/
func (a *Client) SnaplockLegalHoldGet(params *SnaplockLegalHoldGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLegalHoldGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_legal_hold_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/litigations/{litigation.id}/operations/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLegalHoldGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLegalHoldGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLegalHoldGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLegalHoldInstanceGet Retrieves the list of ongoing operations for the specified litigation ID.

### Related ONTAP commands
* `snaplock legal-hold show`
### Learn more
* [`DOC /storage/snaplock/litigations`](#docs-snaplock-storage_snaplock_litigations)
*/
func (a *Client) SnaplockLegalHoldInstanceGet(params *SnaplockLegalHoldInstanceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldInstanceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLegalHoldInstanceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_legal_hold_instance_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/litigations/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLegalHoldInstanceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLegalHoldInstanceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLegalHoldInstanceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLegalHoldOperationDelete Aborts the ongoing legal-hold operation. An abort does not rollback any changes already made. You must re-run begin or end for cleanup.

### Related ONTAP commands
* `snaplock legal-hold abort`
### Example
<br/>
```
DELETE "/api/storage/snaplock/litigations/f8a67b60-4461-11e9-b327-0050568ebef5:l1/operations/16908292"
```
<br/>
### Learn more
* [`DOC /storage/snaplock/litigations/{litigation.id}/operations`](#docs-snaplock-storage_snaplock_litigations_{litigation.id}_operations)
*/
func (a *Client) SnaplockLegalHoldOperationDelete(params *SnaplockLegalHoldOperationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLegalHoldOperationDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLegalHoldOperationDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_legal_hold_operation_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/litigations/{litigation.id}/operations/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLegalHoldOperationDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLegalHoldOperationDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLegalHoldOperationDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLogCollectionGet Retrieves a list of SVMs configured with audit log volumes.

### Related ONTAP commands
* `snaplock log show`
### Learn more
* [`DOC /storage/snaplock/audit-logs`](#docs-snaplock-storage_snaplock_audit-logs)
*/
func (a *Client) SnaplockLogCollectionGet(params *SnaplockLogCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLogCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_log_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/audit-logs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLogCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLogCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLogCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLogCreate Creates a SnapLock log configuration for an SVM. A SnapLock log configuration consists of a volume to store the log, the maximum size of the log file, and the default period of time for which the log file should be retained. The volume must be a Read-Write SnapLock volume of type Enterprise or Compliance. The input parameter retention_period expects the duration in ISO 8601 format.

### Required properties
* `svm.uuid` or `svm.name` - Name or UUID of the SVM.
* `log_volume.volume.name` or `log_volume.volume.uuid` - Name or UUID of audit log volume.
### Recommended optional properties
* `log_volume.max_log_size` - Max log file size.
* `log_volume.volume.retention_period` - Retention period of log file.
### Default property values
If not specified in POST, the following default property values are assigned:
* `log_volume.retention_period` - _P6M_
* `log_volume.max_log_size` - _10MB_
### Related ONTAP commands
* `snaplock log create`
### Learn more
* [`DOC /storage/snaplock/audit-logs`](#docs-snaplock-storage_snaplock_audit-logs)
*/
func (a *Client) SnaplockLogCreate(params *SnaplockLogCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogCreateCreated, *SnaplockLogCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLogCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_log_create",
		Method:             "POST",
		PathPattern:        "/storage/snaplock/audit-logs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLogCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnaplockLogCreateCreated:
		return value, nil, nil
	case *SnaplockLogCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLogCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLogDelete Disassociates a SnapLock volume as the audit log volume for an SVM. This API closes all the active log files in the log volume and marks the volume as disabled for SnapLock logging.

### Related ONTAP commands
* `snaplock log delete`
### Learn more
* [`DOC /storage/snaplock/audit-logs`](#docs-snaplock-storage_snaplock_audit-logs)
*/
func (a *Client) SnaplockLogDelete(params *SnaplockLogDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogDeleteOK, *SnaplockLogDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLogDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_log_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/audit-logs/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLogDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnaplockLogDeleteOK:
		return value, nil, nil
	case *SnaplockLogDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLogDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnaplockLogDeleteCollection snaplock log delete collection API
*/
func (a *Client) SnaplockLogDeleteCollection(params *SnaplockLogDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogDeleteCollectionOK, *SnaplockLogDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLogDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_log_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/audit-logs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLogDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnaplockLogDeleteCollectionOK:
		return value, nil, nil
	case *SnaplockLogDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLogDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLogGet Retrieves SnapLock logs for the specified SVM.

### Related ONTAP commands
* `snaplock log show`
### Learn more
* [`DOC /storage/snaplock/audit-logs`](#docs-snaplock-storage_snaplock_audit-logs)
*/
func (a *Client) SnaplockLogGet(params *SnaplockLogGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLogGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_log_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/audit-logs/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLogGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockLogGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLogGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockLogModify Updates one of the following:
	- the audit log volume,
	- the attributes of the audit log volume present, or
	- archive the current audit log files

### Related ONTAP commands
* `snaplock log modify`
### Learn more
* [`DOC /storage/snaplock/audit-logs`](#docs-snaplock-storage_snaplock_audit-logs)
*/
func (a *Client) SnaplockLogModify(params *SnaplockLogModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogModifyOK, *SnaplockLogModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLogModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_log_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/snaplock/audit-logs/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLogModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnaplockLogModifyOK:
		return value, nil, nil
	case *SnaplockLogModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLogModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnaplockLogModifyCollection snaplock log modify collection API
*/
func (a *Client) SnaplockLogModifyCollection(params *SnaplockLogModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockLogModifyCollectionOK, *SnaplockLogModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockLogModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_log_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/snaplock/audit-logs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockLogModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnaplockLogModifyCollectionOK:
		return value, nil, nil
	case *SnaplockLogModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockLogModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockRetentionOperationCollectionGet Retrieves a list of all EBR operations.

### Related ONTAP commands
* `snaplock event-retention show`
### Learn more
* [`DOC /storage/snaplock/event-retention/operations`](#docs-snaplock-storage_snaplock_event-retention_operations)
*/
func (a *Client) SnaplockRetentionOperationCollectionGet(params *SnaplockRetentionOperationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionOperationCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionOperationCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_operation_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/event-retention/operations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionOperationCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionOperationCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionOperationCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockRetentionOperationCreate Start an EBR operation. This operation applies an EBR policy to a specific volume or to a path within the volume.

### Required properties
  - `path` - Path of the file.
  - `policy.name` - Name of the EBR policy.
    Either volume.name or volume.uuid must be specified when applying EBR policy to the volume or a path within the volume.
  - `volume.name` - Volume name.
  - `volume.uuid` - Volume uuid.

### Related ONTAP commands
* `snaplock event-retention apply`
### Learn more
* [`DOC /storage/snaplock/event-retention/operations`](#docs-snaplock-storage_snaplock_event-retention_operations)
*/
func (a *Client) SnaplockRetentionOperationCreate(params *SnaplockRetentionOperationCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionOperationCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionOperationCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_operation_create",
		Method:             "POST",
		PathPattern:        "/storage/snaplock/event-retention/operations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionOperationCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionOperationCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionOperationCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockRetentionOperationDelete Aborts an ongoing EBR operation.

### Related ONTAP commands
* `snaplock event-retention abort`
### Learn more
* [`DOC /storage/snaplock/event-retention/operations`](#docs-snaplock-storage_snaplock_event-retention_operations)
*/
func (a *Client) SnaplockRetentionOperationDelete(params *SnaplockRetentionOperationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionOperationDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionOperationDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_operation_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/event-retention/operations/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionOperationDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionOperationDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionOperationDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnaplockRetentionOperationDeleteCollection snaplock retention operation delete collection API
*/
func (a *Client) SnaplockRetentionOperationDeleteCollection(params *SnaplockRetentionOperationDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionOperationDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionOperationDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_operation_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/event-retention/operations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionOperationDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionOperationDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionOperationDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockRetentionOperationGet Retrieves a list of attributes for an EBR operation.

### Related ONTAP commands
* `snaplock event-retention show`
### Learn more
* [`DOC /storage/snaplock/event-retention/operations`](#docs-snaplock-storage_snaplock_event-retention_operations)
*/
func (a *Client) SnaplockRetentionOperationGet(params *SnaplockRetentionOperationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionOperationGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionOperationGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_operation_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/event-retention/operations/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionOperationGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionOperationGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionOperationGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockRetentionPolicyCollectionGet Retrieves all event retention policies for an SVM.

### Related ONTAP commands
* `snaplock event-retention policy show`
### Learn more
* [`DOC /storage/snaplock/event-retention/policies`](#docs-snaplock-storage_snaplock_event-retention_policies)
*/
func (a *Client) SnaplockRetentionPolicyCollectionGet(params *SnaplockRetentionPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionPolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/event-retention/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionPolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionPolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionPolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockRetentionPolicyCreate Creates an Event Based Retention (EBR) policy for an SVM. The input parameter retention_period expects the duration in ISO 8601 format or infinite.

### Required properties
* `name` - Event retention policy name.
* `retention_period` - Retention period of the EBR policy.
### Related ONTAP commands
* `snaplock event-retention policy create`
### Learn more
* [`DOC /storage/snaplock/event-retention/policies`](#docs-snaplock-storage_snaplock_event-retention_policies)
*/
func (a *Client) SnaplockRetentionPolicyCreate(params *SnaplockRetentionPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionPolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_policy_create",
		Method:             "POST",
		PathPattern:        "/storage/snaplock/event-retention/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionPolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionPolicyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionPolicyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockRetentionPolicyDelete Deletes the specified Event Based Retention (EBR) policy.

### Related ONTAP commands
* `snaplock event-retention policy delete`
### Example
Delete the specified Event Based Retention policy "policy_name":
<br/>
```
DELETE "/api/storage/snaplock/event-retention/policies/{policy.name}"
```
<br/>
### Learn more
* [`DOC /storage/snaplock/event-retention/policies`](#docs-snaplock-storage_snaplock_event-retention_policies)
*/
func (a *Client) SnaplockRetentionPolicyDelete(params *SnaplockRetentionPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionPolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_policy_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/event-retention/policies/{policy.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionPolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionPolicyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionPolicyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnaplockRetentionPolicyDeleteCollection snaplock retention policy delete collection API
*/
func (a *Client) SnaplockRetentionPolicyDeleteCollection(params *SnaplockRetentionPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionPolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_policy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/snaplock/event-retention/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionPolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionPolicyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionPolicyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockRetentionPolicyGet Retrieves a list of attributes of the specified Event Based Retention (EBR) policy.

### Related ONTAP commands
* `snaplock event-retention policy show`
### Learn more
* [`DOC /storage/snaplock/event-retention/policies`](#docs-snaplock-storage_snaplock_event-retention_policies)
*/
func (a *Client) SnaplockRetentionPolicyGet(params *SnaplockRetentionPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionPolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_policy_get",
		Method:             "GET",
		PathPattern:        "/storage/snaplock/event-retention/policies/{policy.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionPolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionPolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionPolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnaplockRetentionPolicyModify Updates the retention period of an Event Based Retention (EBR) policy.

### Related ONTAP commands
* `snaplock event-retention policy modify`
### Example
Updates the retention period of an EBR policy "policy_name":
<br/>
```
PATCH "/api/storage/snaplock/event-retention/policies/{policy.name}" '{"retention_period": "P20Y"}'
```
<br/>
### Learn more
* [`DOC /storage/snaplock/event-retention/policies`](#docs-snaplock-storage_snaplock_event-retention_policies)
*/
func (a *Client) SnaplockRetentionPolicyModify(params *SnaplockRetentionPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionPolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/snaplock/event-retention/policies/{policy.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionPolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionPolicyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionPolicyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnaplockRetentionPolicyModifyCollection snaplock retention policy modify collection API
*/
func (a *Client) SnaplockRetentionPolicyModifyCollection(params *SnaplockRetentionPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnaplockRetentionPolicyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnaplockRetentionPolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snaplock_retention_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/snaplock/event-retention/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnaplockRetentionPolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnaplockRetentionPolicyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnaplockRetentionPolicyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
