// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSnaplockComplianceClockCreateParams creates a new SnaplockComplianceClockCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnaplockComplianceClockCreateParams() *SnaplockComplianceClockCreateParams {
	return &SnaplockComplianceClockCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnaplockComplianceClockCreateParamsWithTimeout creates a new SnaplockComplianceClockCreateParams object
// with the ability to set a timeout on a request.
func NewSnaplockComplianceClockCreateParamsWithTimeout(timeout time.Duration) *SnaplockComplianceClockCreateParams {
	return &SnaplockComplianceClockCreateParams{
		timeout: timeout,
	}
}

// NewSnaplockComplianceClockCreateParamsWithContext creates a new SnaplockComplianceClockCreateParams object
// with the ability to set a context for a request.
func NewSnaplockComplianceClockCreateParamsWithContext(ctx context.Context) *SnaplockComplianceClockCreateParams {
	return &SnaplockComplianceClockCreateParams{
		Context: ctx,
	}
}

// NewSnaplockComplianceClockCreateParamsWithHTTPClient creates a new SnaplockComplianceClockCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnaplockComplianceClockCreateParamsWithHTTPClient(client *http.Client) *SnaplockComplianceClockCreateParams {
	return &SnaplockComplianceClockCreateParams{
		HTTPClient: client,
	}
}

/*
SnaplockComplianceClockCreateParams contains all the parameters to send to the API endpoint

	for the snaplock compliance clock create operation.

	Typically these are written to a http.Request.
*/
type SnaplockComplianceClockCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.SnaplockComplianceClock

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snaplock compliance clock create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockComplianceClockCreateParams) WithDefaults() *SnaplockComplianceClockCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snaplock compliance clock create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockComplianceClockCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := SnaplockComplianceClockCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snaplock compliance clock create params
func (o *SnaplockComplianceClockCreateParams) WithTimeout(timeout time.Duration) *SnaplockComplianceClockCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snaplock compliance clock create params
func (o *SnaplockComplianceClockCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snaplock compliance clock create params
func (o *SnaplockComplianceClockCreateParams) WithContext(ctx context.Context) *SnaplockComplianceClockCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snaplock compliance clock create params
func (o *SnaplockComplianceClockCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snaplock compliance clock create params
func (o *SnaplockComplianceClockCreateParams) WithHTTPClient(client *http.Client) *SnaplockComplianceClockCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snaplock compliance clock create params
func (o *SnaplockComplianceClockCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the snaplock compliance clock create params
func (o *SnaplockComplianceClockCreateParams) WithInfo(info *models.SnaplockComplianceClock) *SnaplockComplianceClockCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snaplock compliance clock create params
func (o *SnaplockComplianceClockCreateParams) SetInfo(info *models.SnaplockComplianceClock) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the snaplock compliance clock create params
func (o *SnaplockComplianceClockCreateParams) WithReturnRecords(returnRecords *bool) *SnaplockComplianceClockCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snaplock compliance clock create params
func (o *SnaplockComplianceClockCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SnaplockComplianceClockCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
