// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockComplianceClockGetReader is a Reader for the SnaplockComplianceClockGet structure.
type SnaplockComplianceClockGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockComplianceClockGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockComplianceClockGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockComplianceClockGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockComplianceClockGetOK creates a SnaplockComplianceClockGetOK with default headers values
func NewSnaplockComplianceClockGetOK() *SnaplockComplianceClockGetOK {
	return &SnaplockComplianceClockGetOK{}
}

/*
SnaplockComplianceClockGetOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockComplianceClockGetOK struct {
	Payload *models.SnaplockComplianceClock
}

// IsSuccess returns true when this snaplock compliance clock get o k response has a 2xx status code
func (o *SnaplockComplianceClockGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock compliance clock get o k response has a 3xx status code
func (o *SnaplockComplianceClockGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock compliance clock get o k response has a 4xx status code
func (o *SnaplockComplianceClockGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock compliance clock get o k response has a 5xx status code
func (o *SnaplockComplianceClockGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock compliance clock get o k response a status code equal to that given
func (o *SnaplockComplianceClockGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock compliance clock get o k response
func (o *SnaplockComplianceClockGetOK) Code() int {
	return 200
}

func (o *SnaplockComplianceClockGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/compliance-clocks/{node.uuid}][%d] snaplockComplianceClockGetOK %s", 200, payload)
}

func (o *SnaplockComplianceClockGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/compliance-clocks/{node.uuid}][%d] snaplockComplianceClockGetOK %s", 200, payload)
}

func (o *SnaplockComplianceClockGetOK) GetPayload() *models.SnaplockComplianceClock {
	return o.Payload
}

func (o *SnaplockComplianceClockGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnaplockComplianceClock)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnaplockComplianceClockGetDefault creates a SnaplockComplianceClockGetDefault with default headers values
func NewSnaplockComplianceClockGetDefault(code int) *SnaplockComplianceClockGetDefault {
	return &SnaplockComplianceClockGetDefault{
		_statusCode: code,
	}
}

/*
	SnaplockComplianceClockGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
|  14090240   | A node with the specified UUID does not exist  |
|  14090446   | Invalid session ID |
*/
type SnaplockComplianceClockGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock compliance clock get default response has a 2xx status code
func (o *SnaplockComplianceClockGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock compliance clock get default response has a 3xx status code
func (o *SnaplockComplianceClockGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock compliance clock get default response has a 4xx status code
func (o *SnaplockComplianceClockGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock compliance clock get default response has a 5xx status code
func (o *SnaplockComplianceClockGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock compliance clock get default response a status code equal to that given
func (o *SnaplockComplianceClockGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock compliance clock get default response
func (o *SnaplockComplianceClockGetDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockComplianceClockGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/compliance-clocks/{node.uuid}][%d] snaplock_compliance_clock_get default %s", o._statusCode, payload)
}

func (o *SnaplockComplianceClockGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/compliance-clocks/{node.uuid}][%d] snaplock_compliance_clock_get default %s", o._statusCode, payload)
}

func (o *SnaplockComplianceClockGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockComplianceClockGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
