// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnaplockFilePrivilegedDeleteParams creates a new SnaplockFilePrivilegedDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnaplockFilePrivilegedDeleteParams() *SnaplockFilePrivilegedDeleteParams {
	return &SnaplockFilePrivilegedDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnaplockFilePrivilegedDeleteParamsWithTimeout creates a new SnaplockFilePrivilegedDeleteParams object
// with the ability to set a timeout on a request.
func NewSnaplockFilePrivilegedDeleteParamsWithTimeout(timeout time.Duration) *SnaplockFilePrivilegedDeleteParams {
	return &SnaplockFilePrivilegedDeleteParams{
		timeout: timeout,
	}
}

// NewSnaplockFilePrivilegedDeleteParamsWithContext creates a new SnaplockFilePrivilegedDeleteParams object
// with the ability to set a context for a request.
func NewSnaplockFilePrivilegedDeleteParamsWithContext(ctx context.Context) *SnaplockFilePrivilegedDeleteParams {
	return &SnaplockFilePrivilegedDeleteParams{
		Context: ctx,
	}
}

// NewSnaplockFilePrivilegedDeleteParamsWithHTTPClient creates a new SnaplockFilePrivilegedDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnaplockFilePrivilegedDeleteParamsWithHTTPClient(client *http.Client) *SnaplockFilePrivilegedDeleteParams {
	return &SnaplockFilePrivilegedDeleteParams{
		HTTPClient: client,
	}
}

/*
SnaplockFilePrivilegedDeleteParams contains all the parameters to send to the API endpoint

	for the snaplock file privileged delete operation.

	Typically these are written to a http.Request.
*/
type SnaplockFilePrivilegedDeleteParams struct {

	/* Path.

	   Path of the file in the form "/\<dirpath\>/\<filename\>"
	*/
	Path string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* VolumeUUID.

	   Volume UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snaplock file privileged delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockFilePrivilegedDeleteParams) WithDefaults() *SnaplockFilePrivilegedDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snaplock file privileged delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockFilePrivilegedDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := SnaplockFilePrivilegedDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) WithTimeout(timeout time.Duration) *SnaplockFilePrivilegedDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) WithContext(ctx context.Context) *SnaplockFilePrivilegedDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) WithHTTPClient(client *http.Client) *SnaplockFilePrivilegedDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithPath adds the path to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) WithPath(path string) *SnaplockFilePrivilegedDeleteParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) SetPath(path string) {
	o.Path = path
}

// WithReturnTimeout adds the returnTimeout to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) WithReturnTimeout(returnTimeout *int64) *SnaplockFilePrivilegedDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithVolumeUUID adds the volumeUUID to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) WithVolumeUUID(volumeUUID string) *SnaplockFilePrivilegedDeleteParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the snaplock file privileged delete params
func (o *SnaplockFilePrivilegedDeleteParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SnaplockFilePrivilegedDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
