// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnaplockFileRetentionGetParams creates a new SnaplockFileRetentionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnaplockFileRetentionGetParams() *SnaplockFileRetentionGetParams {
	return &SnaplockFileRetentionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnaplockFileRetentionGetParamsWithTimeout creates a new SnaplockFileRetentionGetParams object
// with the ability to set a timeout on a request.
func NewSnaplockFileRetentionGetParamsWithTimeout(timeout time.Duration) *SnaplockFileRetentionGetParams {
	return &SnaplockFileRetentionGetParams{
		timeout: timeout,
	}
}

// NewSnaplockFileRetentionGetParamsWithContext creates a new SnaplockFileRetentionGetParams object
// with the ability to set a context for a request.
func NewSnaplockFileRetentionGetParamsWithContext(ctx context.Context) *SnaplockFileRetentionGetParams {
	return &SnaplockFileRetentionGetParams{
		Context: ctx,
	}
}

// NewSnaplockFileRetentionGetParamsWithHTTPClient creates a new SnaplockFileRetentionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnaplockFileRetentionGetParamsWithHTTPClient(client *http.Client) *SnaplockFileRetentionGetParams {
	return &SnaplockFileRetentionGetParams{
		HTTPClient: client,
	}
}

/*
SnaplockFileRetentionGetParams contains all the parameters to send to the API endpoint

	for the snaplock file retention get operation.

	Typically these are written to a http.Request.
*/
type SnaplockFileRetentionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Path.

	   Path of the file in the form "/\<dirpath\>/\<filename\>"
	*/
	Path string

	/* VolumeUUID.

	   Volume UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snaplock file retention get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockFileRetentionGetParams) WithDefaults() *SnaplockFileRetentionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snaplock file retention get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockFileRetentionGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) WithTimeout(timeout time.Duration) *SnaplockFileRetentionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) WithContext(ctx context.Context) *SnaplockFileRetentionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) WithHTTPClient(client *http.Client) *SnaplockFileRetentionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) WithFields(fields []string) *SnaplockFileRetentionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithPath adds the path to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) WithPath(path string) *SnaplockFileRetentionGetParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) SetPath(path string) {
	o.Path = path
}

// WithVolumeUUID adds the volumeUUID to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) WithVolumeUUID(volumeUUID string) *SnaplockFileRetentionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the snaplock file retention get params
func (o *SnaplockFileRetentionGetParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SnaplockFileRetentionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSnaplockFileRetentionGet binds the parameter fields
func (o *SnaplockFileRetentionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
