// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnaplockFingerprintOperationCollectionGetParams creates a new SnaplockFingerprintOperationCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnaplockFingerprintOperationCollectionGetParams() *SnaplockFingerprintOperationCollectionGetParams {
	return &SnaplockFingerprintOperationCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnaplockFingerprintOperationCollectionGetParamsWithTimeout creates a new SnaplockFingerprintOperationCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSnaplockFingerprintOperationCollectionGetParamsWithTimeout(timeout time.Duration) *SnaplockFingerprintOperationCollectionGetParams {
	return &SnaplockFingerprintOperationCollectionGetParams{
		timeout: timeout,
	}
}

// NewSnaplockFingerprintOperationCollectionGetParamsWithContext creates a new SnaplockFingerprintOperationCollectionGetParams object
// with the ability to set a context for a request.
func NewSnaplockFingerprintOperationCollectionGetParamsWithContext(ctx context.Context) *SnaplockFingerprintOperationCollectionGetParams {
	return &SnaplockFingerprintOperationCollectionGetParams{
		Context: ctx,
	}
}

// NewSnaplockFingerprintOperationCollectionGetParamsWithHTTPClient creates a new SnaplockFingerprintOperationCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnaplockFingerprintOperationCollectionGetParamsWithHTTPClient(client *http.Client) *SnaplockFingerprintOperationCollectionGetParams {
	return &SnaplockFingerprintOperationCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SnaplockFingerprintOperationCollectionGetParams contains all the parameters to send to the API endpoint

	for the snaplock fingerprint operation collection get operation.

	Typically these are written to a http.Request.
*/
type SnaplockFingerprintOperationCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmUUID.

	   SVM UUID
	*/
	SvmUUID string

	/* VolumeUUID.

	   Volume UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snaplock fingerprint operation collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockFingerprintOperationCollectionGetParams) WithDefaults() *SnaplockFingerprintOperationCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snaplock fingerprint operation collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockFingerprintOperationCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SnaplockFingerprintOperationCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) WithTimeout(timeout time.Duration) *SnaplockFingerprintOperationCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) WithContext(ctx context.Context) *SnaplockFingerprintOperationCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) WithHTTPClient(client *http.Client) *SnaplockFingerprintOperationCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) WithFields(fields []string) *SnaplockFingerprintOperationCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) WithMaxRecords(maxRecords *int64) *SnaplockFingerprintOperationCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) WithOrderBy(orderBy []string) *SnaplockFingerprintOperationCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) WithReturnRecords(returnRecords *bool) *SnaplockFingerprintOperationCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SnaplockFingerprintOperationCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmUUID adds the svmUUID to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) WithSvmUUID(svmUUID string) *SnaplockFingerprintOperationCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithVolumeUUID adds the volumeUUID to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) WithVolumeUUID(volumeUUID string) *SnaplockFingerprintOperationCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the snaplock fingerprint operation collection get params
func (o *SnaplockFingerprintOperationCollectionGetParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SnaplockFingerprintOperationCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// query param svm.uuid
	qrSvmUUID := o.SvmUUID
	qSvmUUID := qrSvmUUID
	if qSvmUUID != "" {

		if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
			return err
		}
	}

	// query param volume.uuid
	qrVolumeUUID := o.VolumeUUID
	qVolumeUUID := qrVolumeUUID
	if qVolumeUUID != "" {

		if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSnaplockFingerprintOperationCollectionGet binds the parameter fields
func (o *SnaplockFingerprintOperationCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSnaplockFingerprintOperationCollectionGet binds the parameter order_by
func (o *SnaplockFingerprintOperationCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
