// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockFingerprintOperationCollectionGetReader is a Reader for the SnaplockFingerprintOperationCollectionGet structure.
type SnaplockFingerprintOperationCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockFingerprintOperationCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockFingerprintOperationCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockFingerprintOperationCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockFingerprintOperationCollectionGetOK creates a SnaplockFingerprintOperationCollectionGetOK with default headers values
func NewSnaplockFingerprintOperationCollectionGetOK() *SnaplockFingerprintOperationCollectionGetOK {
	return &SnaplockFingerprintOperationCollectionGetOK{}
}

/*
SnaplockFingerprintOperationCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockFingerprintOperationCollectionGetOK struct {
	Payload *models.SnaplockFileFingerprintResponse
}

// IsSuccess returns true when this snaplock fingerprint operation collection get o k response has a 2xx status code
func (o *SnaplockFingerprintOperationCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock fingerprint operation collection get o k response has a 3xx status code
func (o *SnaplockFingerprintOperationCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock fingerprint operation collection get o k response has a 4xx status code
func (o *SnaplockFingerprintOperationCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock fingerprint operation collection get o k response has a 5xx status code
func (o *SnaplockFingerprintOperationCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock fingerprint operation collection get o k response a status code equal to that given
func (o *SnaplockFingerprintOperationCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock fingerprint operation collection get o k response
func (o *SnaplockFingerprintOperationCollectionGetOK) Code() int {
	return 200
}

func (o *SnaplockFingerprintOperationCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/file-fingerprints][%d] snaplockFingerprintOperationCollectionGetOK %s", 200, payload)
}

func (o *SnaplockFingerprintOperationCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/file-fingerprints][%d] snaplockFingerprintOperationCollectionGetOK %s", 200, payload)
}

func (o *SnaplockFingerprintOperationCollectionGetOK) GetPayload() *models.SnaplockFileFingerprintResponse {
	return o.Payload
}

func (o *SnaplockFingerprintOperationCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnaplockFileFingerprintResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnaplockFingerprintOperationCollectionGetDefault creates a SnaplockFingerprintOperationCollectionGetDefault with default headers values
func NewSnaplockFingerprintOperationCollectionGetDefault(code int) *SnaplockFingerprintOperationCollectionGetDefault {
	return &SnaplockFingerprintOperationCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	SnaplockFingerprintOperationCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 14090442    | Invalid Vserver UUID  |
| 14090445    | Invalid key values. Provide Vserver UUID and Volume UUID  |
*/
type SnaplockFingerprintOperationCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock fingerprint operation collection get default response has a 2xx status code
func (o *SnaplockFingerprintOperationCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock fingerprint operation collection get default response has a 3xx status code
func (o *SnaplockFingerprintOperationCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock fingerprint operation collection get default response has a 4xx status code
func (o *SnaplockFingerprintOperationCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock fingerprint operation collection get default response has a 5xx status code
func (o *SnaplockFingerprintOperationCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock fingerprint operation collection get default response a status code equal to that given
func (o *SnaplockFingerprintOperationCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock fingerprint operation collection get default response
func (o *SnaplockFingerprintOperationCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockFingerprintOperationCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/file-fingerprints][%d] snaplock_fingerprint_operation_collection_get default %s", o._statusCode, payload)
}

func (o *SnaplockFingerprintOperationCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/file-fingerprints][%d] snaplock_fingerprint_operation_collection_get default %s", o._statusCode, payload)
}

func (o *SnaplockFingerprintOperationCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockFingerprintOperationCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
