// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockFingerprintOperationDeleteCollectionReader is a Reader for the SnaplockFingerprintOperationDeleteCollection structure.
type SnaplockFingerprintOperationDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockFingerprintOperationDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockFingerprintOperationDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockFingerprintOperationDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockFingerprintOperationDeleteCollectionOK creates a SnaplockFingerprintOperationDeleteCollectionOK with default headers values
func NewSnaplockFingerprintOperationDeleteCollectionOK() *SnaplockFingerprintOperationDeleteCollectionOK {
	return &SnaplockFingerprintOperationDeleteCollectionOK{}
}

/*
SnaplockFingerprintOperationDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockFingerprintOperationDeleteCollectionOK struct {
}

// IsSuccess returns true when this snaplock fingerprint operation delete collection o k response has a 2xx status code
func (o *SnaplockFingerprintOperationDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock fingerprint operation delete collection o k response has a 3xx status code
func (o *SnaplockFingerprintOperationDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock fingerprint operation delete collection o k response has a 4xx status code
func (o *SnaplockFingerprintOperationDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock fingerprint operation delete collection o k response has a 5xx status code
func (o *SnaplockFingerprintOperationDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock fingerprint operation delete collection o k response a status code equal to that given
func (o *SnaplockFingerprintOperationDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock fingerprint operation delete collection o k response
func (o *SnaplockFingerprintOperationDeleteCollectionOK) Code() int {
	return 200
}

func (o *SnaplockFingerprintOperationDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/file-fingerprints][%d] snaplockFingerprintOperationDeleteCollectionOK", 200)
}

func (o *SnaplockFingerprintOperationDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/file-fingerprints][%d] snaplockFingerprintOperationDeleteCollectionOK", 200)
}

func (o *SnaplockFingerprintOperationDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnaplockFingerprintOperationDeleteCollectionDefault creates a SnaplockFingerprintOperationDeleteCollectionDefault with default headers values
func NewSnaplockFingerprintOperationDeleteCollectionDefault(code int) *SnaplockFingerprintOperationDeleteCollectionDefault {
	return &SnaplockFingerprintOperationDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnaplockFingerprintOperationDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 14090440    | File fingerprint operation has completed  |
| 14090446    | Invalid session ID  |
*/
type SnaplockFingerprintOperationDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock fingerprint operation delete collection default response has a 2xx status code
func (o *SnaplockFingerprintOperationDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock fingerprint operation delete collection default response has a 3xx status code
func (o *SnaplockFingerprintOperationDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock fingerprint operation delete collection default response has a 4xx status code
func (o *SnaplockFingerprintOperationDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock fingerprint operation delete collection default response has a 5xx status code
func (o *SnaplockFingerprintOperationDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock fingerprint operation delete collection default response a status code equal to that given
func (o *SnaplockFingerprintOperationDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock fingerprint operation delete collection default response
func (o *SnaplockFingerprintOperationDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockFingerprintOperationDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/file-fingerprints][%d] snaplock_fingerprint_operation_delete_collection default %s", o._statusCode, payload)
}

func (o *SnaplockFingerprintOperationDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/file-fingerprints][%d] snaplock_fingerprint_operation_delete_collection default %s", o._statusCode, payload)
}

func (o *SnaplockFingerprintOperationDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockFingerprintOperationDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnaplockFingerprintOperationDeleteCollectionBody snaplock fingerprint operation delete collection body
swagger:model SnaplockFingerprintOperationDeleteCollectionBody
*/
type SnaplockFingerprintOperationDeleteCollectionBody struct {

	// snaplock file fingerprint response inline records
	SnaplockFileFingerprintResponseInlineRecords []*models.SnaplockFileFingerprintGet `json:"records,omitempty"`
}

// Validate validates this snaplock fingerprint operation delete collection body
func (o *SnaplockFingerprintOperationDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnaplockFileFingerprintResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockFingerprintOperationDeleteCollectionBody) validateSnaplockFileFingerprintResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnaplockFileFingerprintResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnaplockFileFingerprintResponseInlineRecords); i++ {
		if swag.IsZero(o.SnaplockFileFingerprintResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnaplockFileFingerprintResponseInlineRecords[i] != nil {
			if err := o.SnaplockFileFingerprintResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this snaplock fingerprint operation delete collection body based on the context it is used
func (o *SnaplockFingerprintOperationDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnaplockFileFingerprintResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockFingerprintOperationDeleteCollectionBody) contextValidateSnaplockFileFingerprintResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnaplockFileFingerprintResponseInlineRecords); i++ {

		if o.SnaplockFileFingerprintResponseInlineRecords[i] != nil {
			if err := o.SnaplockFileFingerprintResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnaplockFingerprintOperationDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnaplockFingerprintOperationDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnaplockFingerprintOperationDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
