// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockFingerprintOperationDeleteReader is a Reader for the SnaplockFingerprintOperationDelete structure.
type SnaplockFingerprintOperationDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockFingerprintOperationDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockFingerprintOperationDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockFingerprintOperationDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockFingerprintOperationDeleteOK creates a SnaplockFingerprintOperationDeleteOK with default headers values
func NewSnaplockFingerprintOperationDeleteOK() *SnaplockFingerprintOperationDeleteOK {
	return &SnaplockFingerprintOperationDeleteOK{}
}

/*
SnaplockFingerprintOperationDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockFingerprintOperationDeleteOK struct {
}

// IsSuccess returns true when this snaplock fingerprint operation delete o k response has a 2xx status code
func (o *SnaplockFingerprintOperationDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock fingerprint operation delete o k response has a 3xx status code
func (o *SnaplockFingerprintOperationDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock fingerprint operation delete o k response has a 4xx status code
func (o *SnaplockFingerprintOperationDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock fingerprint operation delete o k response has a 5xx status code
func (o *SnaplockFingerprintOperationDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock fingerprint operation delete o k response a status code equal to that given
func (o *SnaplockFingerprintOperationDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock fingerprint operation delete o k response
func (o *SnaplockFingerprintOperationDeleteOK) Code() int {
	return 200
}

func (o *SnaplockFingerprintOperationDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/file-fingerprints/{id}][%d] snaplockFingerprintOperationDeleteOK", 200)
}

func (o *SnaplockFingerprintOperationDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/file-fingerprints/{id}][%d] snaplockFingerprintOperationDeleteOK", 200)
}

func (o *SnaplockFingerprintOperationDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnaplockFingerprintOperationDeleteDefault creates a SnaplockFingerprintOperationDeleteDefault with default headers values
func NewSnaplockFingerprintOperationDeleteDefault(code int) *SnaplockFingerprintOperationDeleteDefault {
	return &SnaplockFingerprintOperationDeleteDefault{
		_statusCode: code,
	}
}

/*
	SnaplockFingerprintOperationDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 14090440    | File fingerprint operation has completed  |
| 14090446    | Invalid session ID  |
*/
type SnaplockFingerprintOperationDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock fingerprint operation delete default response has a 2xx status code
func (o *SnaplockFingerprintOperationDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock fingerprint operation delete default response has a 3xx status code
func (o *SnaplockFingerprintOperationDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock fingerprint operation delete default response has a 4xx status code
func (o *SnaplockFingerprintOperationDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock fingerprint operation delete default response has a 5xx status code
func (o *SnaplockFingerprintOperationDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock fingerprint operation delete default response a status code equal to that given
func (o *SnaplockFingerprintOperationDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock fingerprint operation delete default response
func (o *SnaplockFingerprintOperationDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockFingerprintOperationDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/file-fingerprints/{id}][%d] snaplock_fingerprint_operation_delete default %s", o._statusCode, payload)
}

func (o *SnaplockFingerprintOperationDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/file-fingerprints/{id}][%d] snaplock_fingerprint_operation_delete default %s", o._statusCode, payload)
}

func (o *SnaplockFingerprintOperationDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockFingerprintOperationDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
