// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockFingerprintOperationGetReader is a Reader for the SnaplockFingerprintOperationGet structure.
type SnaplockFingerprintOperationGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockFingerprintOperationGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockFingerprintOperationGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockFingerprintOperationGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockFingerprintOperationGetOK creates a SnaplockFingerprintOperationGetOK with default headers values
func NewSnaplockFingerprintOperationGetOK() *SnaplockFingerprintOperationGetOK {
	return &SnaplockFingerprintOperationGetOK{}
}

/*
SnaplockFingerprintOperationGetOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockFingerprintOperationGetOK struct {
	Payload *models.SnaplockFileFingerprint
}

// IsSuccess returns true when this snaplock fingerprint operation get o k response has a 2xx status code
func (o *SnaplockFingerprintOperationGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock fingerprint operation get o k response has a 3xx status code
func (o *SnaplockFingerprintOperationGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock fingerprint operation get o k response has a 4xx status code
func (o *SnaplockFingerprintOperationGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock fingerprint operation get o k response has a 5xx status code
func (o *SnaplockFingerprintOperationGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock fingerprint operation get o k response a status code equal to that given
func (o *SnaplockFingerprintOperationGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock fingerprint operation get o k response
func (o *SnaplockFingerprintOperationGetOK) Code() int {
	return 200
}

func (o *SnaplockFingerprintOperationGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/file-fingerprints/{id}][%d] snaplockFingerprintOperationGetOK %s", 200, payload)
}

func (o *SnaplockFingerprintOperationGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/file-fingerprints/{id}][%d] snaplockFingerprintOperationGetOK %s", 200, payload)
}

func (o *SnaplockFingerprintOperationGetOK) GetPayload() *models.SnaplockFileFingerprint {
	return o.Payload
}

func (o *SnaplockFingerprintOperationGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnaplockFileFingerprint)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnaplockFingerprintOperationGetDefault creates a SnaplockFingerprintOperationGetDefault with default headers values
func NewSnaplockFingerprintOperationGetDefault(code int) *SnaplockFingerprintOperationGetDefault {
	return &SnaplockFingerprintOperationGetDefault{
		_statusCode: code,
	}
}

/*
	SnaplockFingerprintOperationGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 14090441    | Invalid key values. Provide session ID or Vserver UUID and volume UUID  |
| 14090449    | File fingerprint operation has not completed  |
*/
type SnaplockFingerprintOperationGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock fingerprint operation get default response has a 2xx status code
func (o *SnaplockFingerprintOperationGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock fingerprint operation get default response has a 3xx status code
func (o *SnaplockFingerprintOperationGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock fingerprint operation get default response has a 4xx status code
func (o *SnaplockFingerprintOperationGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock fingerprint operation get default response has a 5xx status code
func (o *SnaplockFingerprintOperationGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock fingerprint operation get default response a status code equal to that given
func (o *SnaplockFingerprintOperationGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock fingerprint operation get default response
func (o *SnaplockFingerprintOperationGetDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockFingerprintOperationGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/file-fingerprints/{id}][%d] snaplock_fingerprint_operation_get default %s", o._statusCode, payload)
}

func (o *SnaplockFingerprintOperationGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/file-fingerprints/{id}][%d] snaplock_fingerprint_operation_get default %s", o._statusCode, payload)
}

func (o *SnaplockFingerprintOperationGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockFingerprintOperationGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
