// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockLegalHoldDeleteCollectionReader is a Reader for the SnaplockLegalHoldDeleteCollection structure.
type SnaplockLegalHoldDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockLegalHoldDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockLegalHoldDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockLegalHoldDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockLegalHoldDeleteCollectionOK creates a SnaplockLegalHoldDeleteCollectionOK with default headers values
func NewSnaplockLegalHoldDeleteCollectionOK() *SnaplockLegalHoldDeleteCollectionOK {
	return &SnaplockLegalHoldDeleteCollectionOK{}
}

/*
SnaplockLegalHoldDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockLegalHoldDeleteCollectionOK struct {
}

// IsSuccess returns true when this snaplock legal hold delete collection o k response has a 2xx status code
func (o *SnaplockLegalHoldDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock legal hold delete collection o k response has a 3xx status code
func (o *SnaplockLegalHoldDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock legal hold delete collection o k response has a 4xx status code
func (o *SnaplockLegalHoldDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock legal hold delete collection o k response has a 5xx status code
func (o *SnaplockLegalHoldDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock legal hold delete collection o k response a status code equal to that given
func (o *SnaplockLegalHoldDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock legal hold delete collection o k response
func (o *SnaplockLegalHoldDeleteCollectionOK) Code() int {
	return 200
}

func (o *SnaplockLegalHoldDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/litigations][%d] snaplockLegalHoldDeleteCollectionOK", 200)
}

func (o *SnaplockLegalHoldDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/litigations][%d] snaplockLegalHoldDeleteCollectionOK", 200)
}

func (o *SnaplockLegalHoldDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnaplockLegalHoldDeleteCollectionDefault creates a SnaplockLegalHoldDeleteCollectionDefault with default headers values
func NewSnaplockLegalHoldDeleteCollectionDefault(code int) *SnaplockLegalHoldDeleteCollectionDefault {
	return &SnaplockLegalHoldDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnaplockLegalHoldDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13763280    | Only a user with security login role \"vsadmin-snaplock\" is allowed to perform this operation.  |
| 14090343    | Invalid Field  |
| 14090346    | Internal Error. Wait a few minutes, then try the command again  |
| 14090642    | Legal-Hold operation is in progress. Legal-Hold end cannot be performed. Wait for the operation to complete or abort the operation  |
*/
type SnaplockLegalHoldDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock legal hold delete collection default response has a 2xx status code
func (o *SnaplockLegalHoldDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock legal hold delete collection default response has a 3xx status code
func (o *SnaplockLegalHoldDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock legal hold delete collection default response has a 4xx status code
func (o *SnaplockLegalHoldDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock legal hold delete collection default response has a 5xx status code
func (o *SnaplockLegalHoldDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock legal hold delete collection default response a status code equal to that given
func (o *SnaplockLegalHoldDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock legal hold delete collection default response
func (o *SnaplockLegalHoldDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockLegalHoldDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/litigations][%d] snaplock_legal_hold_delete_collection default %s", o._statusCode, payload)
}

func (o *SnaplockLegalHoldDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/litigations][%d] snaplock_legal_hold_delete_collection default %s", o._statusCode, payload)
}

func (o *SnaplockLegalHoldDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockLegalHoldDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnaplockLegalHoldDeleteCollectionBody snaplock legal hold delete collection body
swagger:model SnaplockLegalHoldDeleteCollectionBody
*/
type SnaplockLegalHoldDeleteCollectionBody struct {

	// snaplock litigation response inline records
	SnaplockLitigationResponseInlineRecords []*models.SnaplockLitigationGet `json:"records,omitempty"`
}

// Validate validates this snaplock legal hold delete collection body
func (o *SnaplockLegalHoldDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnaplockLitigationResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockLegalHoldDeleteCollectionBody) validateSnaplockLitigationResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnaplockLitigationResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnaplockLitigationResponseInlineRecords); i++ {
		if swag.IsZero(o.SnaplockLitigationResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnaplockLitigationResponseInlineRecords[i] != nil {
			if err := o.SnaplockLitigationResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this snaplock legal hold delete collection body based on the context it is used
func (o *SnaplockLegalHoldDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnaplockLitigationResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockLegalHoldDeleteCollectionBody) contextValidateSnaplockLitigationResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnaplockLitigationResponseInlineRecords); i++ {

		if o.SnaplockLitigationResponseInlineRecords[i] != nil {
			if err := o.SnaplockLitigationResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnaplockLegalHoldDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnaplockLegalHoldDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnaplockLegalHoldDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
