// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnaplockLogCollectionGetParams creates a new SnaplockLogCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnaplockLogCollectionGetParams() *SnaplockLogCollectionGetParams {
	return &SnaplockLogCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnaplockLogCollectionGetParamsWithTimeout creates a new SnaplockLogCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSnaplockLogCollectionGetParamsWithTimeout(timeout time.Duration) *SnaplockLogCollectionGetParams {
	return &SnaplockLogCollectionGetParams{
		timeout: timeout,
	}
}

// NewSnaplockLogCollectionGetParamsWithContext creates a new SnaplockLogCollectionGetParams object
// with the ability to set a context for a request.
func NewSnaplockLogCollectionGetParamsWithContext(ctx context.Context) *SnaplockLogCollectionGetParams {
	return &SnaplockLogCollectionGetParams{
		Context: ctx,
	}
}

// NewSnaplockLogCollectionGetParamsWithHTTPClient creates a new SnaplockLogCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnaplockLogCollectionGetParamsWithHTTPClient(client *http.Client) *SnaplockLogCollectionGetParams {
	return &SnaplockLogCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SnaplockLogCollectionGetParams contains all the parameters to send to the API endpoint

	for the snaplock log collection get operation.

	Typically these are written to a http.Request.
*/
type SnaplockLogCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LogFilesBaseName.

	   Filter by log_files.base_name
	*/
	LogFilesBaseName *string

	/* LogFilesExpiryTime.

	   Filter by log_files.expiry_time
	*/
	LogFilesExpiryTime *string

	/* LogFilesPath.

	   Filter by log_files.path
	*/
	LogFilesPath *string

	/* LogFilesSize.

	   Filter by log_files.size
	*/
	LogFilesSize *int64

	/* LogVolumeMaxLogSize.

	   Filter by log_volume.max_log_size
	*/
	LogVolumeMaxLogSize *int64

	/* LogVolumeRetentionPeriod.

	   Filter by log_volume.retention_period
	*/
	LogVolumeRetentionPeriod *string

	/* LogVolumeVolumeName.

	   Filter by log_volume.volume.name
	*/
	LogVolumeVolumeName *string

	/* LogVolumeVolumeUUID.

	   Filter by log_volume.volume.uuid
	*/
	LogVolumeVolumeUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snaplock log collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockLogCollectionGetParams) WithDefaults() *SnaplockLogCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snaplock log collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockLogCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SnaplockLogCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithTimeout(timeout time.Duration) *SnaplockLogCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithContext(ctx context.Context) *SnaplockLogCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithHTTPClient(client *http.Client) *SnaplockLogCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithFields(fields []string) *SnaplockLogCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLogFilesBaseName adds the logFilesBaseName to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithLogFilesBaseName(logFilesBaseName *string) *SnaplockLogCollectionGetParams {
	o.SetLogFilesBaseName(logFilesBaseName)
	return o
}

// SetLogFilesBaseName adds the logFilesBaseName to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetLogFilesBaseName(logFilesBaseName *string) {
	o.LogFilesBaseName = logFilesBaseName
}

// WithLogFilesExpiryTime adds the logFilesExpiryTime to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithLogFilesExpiryTime(logFilesExpiryTime *string) *SnaplockLogCollectionGetParams {
	o.SetLogFilesExpiryTime(logFilesExpiryTime)
	return o
}

// SetLogFilesExpiryTime adds the logFilesExpiryTime to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetLogFilesExpiryTime(logFilesExpiryTime *string) {
	o.LogFilesExpiryTime = logFilesExpiryTime
}

// WithLogFilesPath adds the logFilesPath to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithLogFilesPath(logFilesPath *string) *SnaplockLogCollectionGetParams {
	o.SetLogFilesPath(logFilesPath)
	return o
}

// SetLogFilesPath adds the logFilesPath to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetLogFilesPath(logFilesPath *string) {
	o.LogFilesPath = logFilesPath
}

// WithLogFilesSize adds the logFilesSize to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithLogFilesSize(logFilesSize *int64) *SnaplockLogCollectionGetParams {
	o.SetLogFilesSize(logFilesSize)
	return o
}

// SetLogFilesSize adds the logFilesSize to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetLogFilesSize(logFilesSize *int64) {
	o.LogFilesSize = logFilesSize
}

// WithLogVolumeMaxLogSize adds the logVolumeMaxLogSize to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithLogVolumeMaxLogSize(logVolumeMaxLogSize *int64) *SnaplockLogCollectionGetParams {
	o.SetLogVolumeMaxLogSize(logVolumeMaxLogSize)
	return o
}

// SetLogVolumeMaxLogSize adds the logVolumeMaxLogSize to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetLogVolumeMaxLogSize(logVolumeMaxLogSize *int64) {
	o.LogVolumeMaxLogSize = logVolumeMaxLogSize
}

// WithLogVolumeRetentionPeriod adds the logVolumeRetentionPeriod to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithLogVolumeRetentionPeriod(logVolumeRetentionPeriod *string) *SnaplockLogCollectionGetParams {
	o.SetLogVolumeRetentionPeriod(logVolumeRetentionPeriod)
	return o
}

// SetLogVolumeRetentionPeriod adds the logVolumeRetentionPeriod to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetLogVolumeRetentionPeriod(logVolumeRetentionPeriod *string) {
	o.LogVolumeRetentionPeriod = logVolumeRetentionPeriod
}

// WithLogVolumeVolumeName adds the logVolumeVolumeName to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithLogVolumeVolumeName(logVolumeVolumeName *string) *SnaplockLogCollectionGetParams {
	o.SetLogVolumeVolumeName(logVolumeVolumeName)
	return o
}

// SetLogVolumeVolumeName adds the logVolumeVolumeName to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetLogVolumeVolumeName(logVolumeVolumeName *string) {
	o.LogVolumeVolumeName = logVolumeVolumeName
}

// WithLogVolumeVolumeUUID adds the logVolumeVolumeUUID to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithLogVolumeVolumeUUID(logVolumeVolumeUUID *string) *SnaplockLogCollectionGetParams {
	o.SetLogVolumeVolumeUUID(logVolumeVolumeUUID)
	return o
}

// SetLogVolumeVolumeUUID adds the logVolumeVolumeUuid to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetLogVolumeVolumeUUID(logVolumeVolumeUUID *string) {
	o.LogVolumeVolumeUUID = logVolumeVolumeUUID
}

// WithMaxRecords adds the maxRecords to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithMaxRecords(maxRecords *int64) *SnaplockLogCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithOrderBy(orderBy []string) *SnaplockLogCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithReturnRecords(returnRecords *bool) *SnaplockLogCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SnaplockLogCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithSvmName(svmName *string) *SnaplockLogCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) WithSvmUUID(svmUUID *string) *SnaplockLogCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the snaplock log collection get params
func (o *SnaplockLogCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SnaplockLogCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LogFilesBaseName != nil {

		// query param log_files.base_name
		var qrLogFilesBaseName string

		if o.LogFilesBaseName != nil {
			qrLogFilesBaseName = *o.LogFilesBaseName
		}
		qLogFilesBaseName := qrLogFilesBaseName
		if qLogFilesBaseName != "" {

			if err := r.SetQueryParam("log_files.base_name", qLogFilesBaseName); err != nil {
				return err
			}
		}
	}

	if o.LogFilesExpiryTime != nil {

		// query param log_files.expiry_time
		var qrLogFilesExpiryTime string

		if o.LogFilesExpiryTime != nil {
			qrLogFilesExpiryTime = *o.LogFilesExpiryTime
		}
		qLogFilesExpiryTime := qrLogFilesExpiryTime
		if qLogFilesExpiryTime != "" {

			if err := r.SetQueryParam("log_files.expiry_time", qLogFilesExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.LogFilesPath != nil {

		// query param log_files.path
		var qrLogFilesPath string

		if o.LogFilesPath != nil {
			qrLogFilesPath = *o.LogFilesPath
		}
		qLogFilesPath := qrLogFilesPath
		if qLogFilesPath != "" {

			if err := r.SetQueryParam("log_files.path", qLogFilesPath); err != nil {
				return err
			}
		}
	}

	if o.LogFilesSize != nil {

		// query param log_files.size
		var qrLogFilesSize int64

		if o.LogFilesSize != nil {
			qrLogFilesSize = *o.LogFilesSize
		}
		qLogFilesSize := swag.FormatInt64(qrLogFilesSize)
		if qLogFilesSize != "" {

			if err := r.SetQueryParam("log_files.size", qLogFilesSize); err != nil {
				return err
			}
		}
	}

	if o.LogVolumeMaxLogSize != nil {

		// query param log_volume.max_log_size
		var qrLogVolumeMaxLogSize int64

		if o.LogVolumeMaxLogSize != nil {
			qrLogVolumeMaxLogSize = *o.LogVolumeMaxLogSize
		}
		qLogVolumeMaxLogSize := swag.FormatInt64(qrLogVolumeMaxLogSize)
		if qLogVolumeMaxLogSize != "" {

			if err := r.SetQueryParam("log_volume.max_log_size", qLogVolumeMaxLogSize); err != nil {
				return err
			}
		}
	}

	if o.LogVolumeRetentionPeriod != nil {

		// query param log_volume.retention_period
		var qrLogVolumeRetentionPeriod string

		if o.LogVolumeRetentionPeriod != nil {
			qrLogVolumeRetentionPeriod = *o.LogVolumeRetentionPeriod
		}
		qLogVolumeRetentionPeriod := qrLogVolumeRetentionPeriod
		if qLogVolumeRetentionPeriod != "" {

			if err := r.SetQueryParam("log_volume.retention_period", qLogVolumeRetentionPeriod); err != nil {
				return err
			}
		}
	}

	if o.LogVolumeVolumeName != nil {

		// query param log_volume.volume.name
		var qrLogVolumeVolumeName string

		if o.LogVolumeVolumeName != nil {
			qrLogVolumeVolumeName = *o.LogVolumeVolumeName
		}
		qLogVolumeVolumeName := qrLogVolumeVolumeName
		if qLogVolumeVolumeName != "" {

			if err := r.SetQueryParam("log_volume.volume.name", qLogVolumeVolumeName); err != nil {
				return err
			}
		}
	}

	if o.LogVolumeVolumeUUID != nil {

		// query param log_volume.volume.uuid
		var qrLogVolumeVolumeUUID string

		if o.LogVolumeVolumeUUID != nil {
			qrLogVolumeVolumeUUID = *o.LogVolumeVolumeUUID
		}
		qLogVolumeVolumeUUID := qrLogVolumeVolumeUUID
		if qLogVolumeVolumeUUID != "" {

			if err := r.SetQueryParam("log_volume.volume.uuid", qLogVolumeVolumeUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSnaplockLogCollectionGet binds the parameter fields
func (o *SnaplockLogCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSnaplockLogCollectionGet binds the parameter order_by
func (o *SnaplockLogCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
