// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockLogDeleteCollectionReader is a Reader for the SnaplockLogDeleteCollection structure.
type SnaplockLogDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockLogDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockLogDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSnaplockLogDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockLogDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockLogDeleteCollectionOK creates a SnaplockLogDeleteCollectionOK with default headers values
func NewSnaplockLogDeleteCollectionOK() *SnaplockLogDeleteCollectionOK {
	return &SnaplockLogDeleteCollectionOK{}
}

/*
SnaplockLogDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockLogDeleteCollectionOK struct {
	Payload *models.SnaplockLogJobLinkResponse
}

// IsSuccess returns true when this snaplock log delete collection o k response has a 2xx status code
func (o *SnaplockLogDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock log delete collection o k response has a 3xx status code
func (o *SnaplockLogDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock log delete collection o k response has a 4xx status code
func (o *SnaplockLogDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock log delete collection o k response has a 5xx status code
func (o *SnaplockLogDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock log delete collection o k response a status code equal to that given
func (o *SnaplockLogDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock log delete collection o k response
func (o *SnaplockLogDeleteCollectionOK) Code() int {
	return 200
}

func (o *SnaplockLogDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/audit-logs][%d] snaplockLogDeleteCollectionOK %s", 200, payload)
}

func (o *SnaplockLogDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/audit-logs][%d] snaplockLogDeleteCollectionOK %s", 200, payload)
}

func (o *SnaplockLogDeleteCollectionOK) GetPayload() *models.SnaplockLogJobLinkResponse {
	return o.Payload
}

func (o *SnaplockLogDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnaplockLogJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnaplockLogDeleteCollectionAccepted creates a SnaplockLogDeleteCollectionAccepted with default headers values
func NewSnaplockLogDeleteCollectionAccepted() *SnaplockLogDeleteCollectionAccepted {
	return &SnaplockLogDeleteCollectionAccepted{}
}

/*
SnaplockLogDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SnaplockLogDeleteCollectionAccepted struct {
	Payload *models.SnaplockLogJobLinkResponse
}

// IsSuccess returns true when this snaplock log delete collection accepted response has a 2xx status code
func (o *SnaplockLogDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock log delete collection accepted response has a 3xx status code
func (o *SnaplockLogDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock log delete collection accepted response has a 4xx status code
func (o *SnaplockLogDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock log delete collection accepted response has a 5xx status code
func (o *SnaplockLogDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock log delete collection accepted response a status code equal to that given
func (o *SnaplockLogDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the snaplock log delete collection accepted response
func (o *SnaplockLogDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *SnaplockLogDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/audit-logs][%d] snaplockLogDeleteCollectionAccepted %s", 202, payload)
}

func (o *SnaplockLogDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/audit-logs][%d] snaplockLogDeleteCollectionAccepted %s", 202, payload)
}

func (o *SnaplockLogDeleteCollectionAccepted) GetPayload() *models.SnaplockLogJobLinkResponse {
	return o.Payload
}

func (o *SnaplockLogDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnaplockLogJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnaplockLogDeleteCollectionDefault creates a SnaplockLogDeleteCollectionDefault with default headers values
func NewSnaplockLogDeleteCollectionDefault(code int) *SnaplockLogDeleteCollectionDefault {
	return &SnaplockLogDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnaplockLogDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 14090346    | Internal Error. Wait a few minutes, then try the command again  |
*/
type SnaplockLogDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock log delete collection default response has a 2xx status code
func (o *SnaplockLogDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock log delete collection default response has a 3xx status code
func (o *SnaplockLogDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock log delete collection default response has a 4xx status code
func (o *SnaplockLogDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock log delete collection default response has a 5xx status code
func (o *SnaplockLogDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock log delete collection default response a status code equal to that given
func (o *SnaplockLogDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock log delete collection default response
func (o *SnaplockLogDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockLogDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/audit-logs][%d] snaplock_log_delete_collection default %s", o._statusCode, payload)
}

func (o *SnaplockLogDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/audit-logs][%d] snaplock_log_delete_collection default %s", o._statusCode, payload)
}

func (o *SnaplockLogDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockLogDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnaplockLogDeleteCollectionBody snaplock log delete collection body
swagger:model SnaplockLogDeleteCollectionBody
*/
type SnaplockLogDeleteCollectionBody struct {

	// snaplock log response inline records
	SnaplockLogResponseInlineRecords []*models.SnaplockLog `json:"records,omitempty"`
}

// Validate validates this snaplock log delete collection body
func (o *SnaplockLogDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnaplockLogResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockLogDeleteCollectionBody) validateSnaplockLogResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnaplockLogResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnaplockLogResponseInlineRecords); i++ {
		if swag.IsZero(o.SnaplockLogResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnaplockLogResponseInlineRecords[i] != nil {
			if err := o.SnaplockLogResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this snaplock log delete collection body based on the context it is used
func (o *SnaplockLogDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnaplockLogResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockLogDeleteCollectionBody) contextValidateSnaplockLogResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnaplockLogResponseInlineRecords); i++ {

		if o.SnaplockLogResponseInlineRecords[i] != nil {
			if err := o.SnaplockLogResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnaplockLogDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnaplockLogDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnaplockLogDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
