// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockRetentionOperationCollectionGetReader is a Reader for the SnaplockRetentionOperationCollectionGet structure.
type SnaplockRetentionOperationCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockRetentionOperationCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockRetentionOperationCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockRetentionOperationCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockRetentionOperationCollectionGetOK creates a SnaplockRetentionOperationCollectionGetOK with default headers values
func NewSnaplockRetentionOperationCollectionGetOK() *SnaplockRetentionOperationCollectionGetOK {
	return &SnaplockRetentionOperationCollectionGetOK{}
}

/*
SnaplockRetentionOperationCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockRetentionOperationCollectionGetOK struct {
	Payload *models.EbrOperationResponse
}

// IsSuccess returns true when this snaplock retention operation collection get o k response has a 2xx status code
func (o *SnaplockRetentionOperationCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock retention operation collection get o k response has a 3xx status code
func (o *SnaplockRetentionOperationCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock retention operation collection get o k response has a 4xx status code
func (o *SnaplockRetentionOperationCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock retention operation collection get o k response has a 5xx status code
func (o *SnaplockRetentionOperationCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock retention operation collection get o k response a status code equal to that given
func (o *SnaplockRetentionOperationCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock retention operation collection get o k response
func (o *SnaplockRetentionOperationCollectionGetOK) Code() int {
	return 200
}

func (o *SnaplockRetentionOperationCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/event-retention/operations][%d] snaplockRetentionOperationCollectionGetOK %s", 200, payload)
}

func (o *SnaplockRetentionOperationCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/event-retention/operations][%d] snaplockRetentionOperationCollectionGetOK %s", 200, payload)
}

func (o *SnaplockRetentionOperationCollectionGetOK) GetPayload() *models.EbrOperationResponse {
	return o.Payload
}

func (o *SnaplockRetentionOperationCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.EbrOperationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnaplockRetentionOperationCollectionGetDefault creates a SnaplockRetentionOperationCollectionGetDefault with default headers values
func NewSnaplockRetentionOperationCollectionGetDefault(code int) *SnaplockRetentionOperationCollectionGetDefault {
	return &SnaplockRetentionOperationCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	SnaplockRetentionOperationCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 14090242    | Only a user with the security login role \"vsadmin-snaplock\" is allowed to perform this operation. |
*/
type SnaplockRetentionOperationCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock retention operation collection get default response has a 2xx status code
func (o *SnaplockRetentionOperationCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock retention operation collection get default response has a 3xx status code
func (o *SnaplockRetentionOperationCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock retention operation collection get default response has a 4xx status code
func (o *SnaplockRetentionOperationCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock retention operation collection get default response has a 5xx status code
func (o *SnaplockRetentionOperationCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock retention operation collection get default response a status code equal to that given
func (o *SnaplockRetentionOperationCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock retention operation collection get default response
func (o *SnaplockRetentionOperationCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockRetentionOperationCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/event-retention/operations][%d] snaplock_retention_operation_collection_get default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionOperationCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/event-retention/operations][%d] snaplock_retention_operation_collection_get default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionOperationCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockRetentionOperationCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
