// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockRetentionOperationDeleteCollectionReader is a Reader for the SnaplockRetentionOperationDeleteCollection structure.
type SnaplockRetentionOperationDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockRetentionOperationDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockRetentionOperationDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockRetentionOperationDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockRetentionOperationDeleteCollectionOK creates a SnaplockRetentionOperationDeleteCollectionOK with default headers values
func NewSnaplockRetentionOperationDeleteCollectionOK() *SnaplockRetentionOperationDeleteCollectionOK {
	return &SnaplockRetentionOperationDeleteCollectionOK{}
}

/*
SnaplockRetentionOperationDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockRetentionOperationDeleteCollectionOK struct {
}

// IsSuccess returns true when this snaplock retention operation delete collection o k response has a 2xx status code
func (o *SnaplockRetentionOperationDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock retention operation delete collection o k response has a 3xx status code
func (o *SnaplockRetentionOperationDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock retention operation delete collection o k response has a 4xx status code
func (o *SnaplockRetentionOperationDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock retention operation delete collection o k response has a 5xx status code
func (o *SnaplockRetentionOperationDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock retention operation delete collection o k response a status code equal to that given
func (o *SnaplockRetentionOperationDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock retention operation delete collection o k response
func (o *SnaplockRetentionOperationDeleteCollectionOK) Code() int {
	return 200
}

func (o *SnaplockRetentionOperationDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/operations][%d] snaplockRetentionOperationDeleteCollectionOK", 200)
}

func (o *SnaplockRetentionOperationDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/operations][%d] snaplockRetentionOperationDeleteCollectionOK", 200)
}

func (o *SnaplockRetentionOperationDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnaplockRetentionOperationDeleteCollectionDefault creates a SnaplockRetentionOperationDeleteCollectionDefault with default headers values
func NewSnaplockRetentionOperationDeleteCollectionDefault(code int) *SnaplockRetentionOperationDeleteCollectionDefault {
	return &SnaplockRetentionOperationDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnaplockRetentionOperationDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 14090541    | A completed or failed operation cannot be aborted |
| 14090242    | Only a user with the security login role \"vsadmin-snaplock\" is allowed to perform this operation. |
*/
type SnaplockRetentionOperationDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock retention operation delete collection default response has a 2xx status code
func (o *SnaplockRetentionOperationDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock retention operation delete collection default response has a 3xx status code
func (o *SnaplockRetentionOperationDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock retention operation delete collection default response has a 4xx status code
func (o *SnaplockRetentionOperationDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock retention operation delete collection default response has a 5xx status code
func (o *SnaplockRetentionOperationDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock retention operation delete collection default response a status code equal to that given
func (o *SnaplockRetentionOperationDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock retention operation delete collection default response
func (o *SnaplockRetentionOperationDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockRetentionOperationDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/operations][%d] snaplock_retention_operation_delete_collection default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionOperationDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/operations][%d] snaplock_retention_operation_delete_collection default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionOperationDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockRetentionOperationDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnaplockRetentionOperationDeleteCollectionBody snaplock retention operation delete collection body
swagger:model SnaplockRetentionOperationDeleteCollectionBody
*/
type SnaplockRetentionOperationDeleteCollectionBody struct {

	// ebr operation response inline records
	EbrOperationResponseInlineRecords []*models.EbrOperation `json:"records,omitempty"`
}

// Validate validates this snaplock retention operation delete collection body
func (o *SnaplockRetentionOperationDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateEbrOperationResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionOperationDeleteCollectionBody) validateEbrOperationResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.EbrOperationResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.EbrOperationResponseInlineRecords); i++ {
		if swag.IsZero(o.EbrOperationResponseInlineRecords[i]) { // not required
			continue
		}

		if o.EbrOperationResponseInlineRecords[i] != nil {
			if err := o.EbrOperationResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this snaplock retention operation delete collection body based on the context it is used
func (o *SnaplockRetentionOperationDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEbrOperationResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionOperationDeleteCollectionBody) contextValidateEbrOperationResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.EbrOperationResponseInlineRecords); i++ {

		if o.EbrOperationResponseInlineRecords[i] != nil {
			if err := o.EbrOperationResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnaplockRetentionOperationDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnaplockRetentionOperationDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnaplockRetentionOperationDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
