// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockRetentionOperationDeleteReader is a Reader for the SnaplockRetentionOperationDelete structure.
type SnaplockRetentionOperationDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockRetentionOperationDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockRetentionOperationDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockRetentionOperationDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockRetentionOperationDeleteOK creates a SnaplockRetentionOperationDeleteOK with default headers values
func NewSnaplockRetentionOperationDeleteOK() *SnaplockRetentionOperationDeleteOK {
	return &SnaplockRetentionOperationDeleteOK{}
}

/*
SnaplockRetentionOperationDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockRetentionOperationDeleteOK struct {
}

// IsSuccess returns true when this snaplock retention operation delete o k response has a 2xx status code
func (o *SnaplockRetentionOperationDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock retention operation delete o k response has a 3xx status code
func (o *SnaplockRetentionOperationDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock retention operation delete o k response has a 4xx status code
func (o *SnaplockRetentionOperationDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock retention operation delete o k response has a 5xx status code
func (o *SnaplockRetentionOperationDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock retention operation delete o k response a status code equal to that given
func (o *SnaplockRetentionOperationDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock retention operation delete o k response
func (o *SnaplockRetentionOperationDeleteOK) Code() int {
	return 200
}

func (o *SnaplockRetentionOperationDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/operations/{id}][%d] snaplockRetentionOperationDeleteOK", 200)
}

func (o *SnaplockRetentionOperationDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/operations/{id}][%d] snaplockRetentionOperationDeleteOK", 200)
}

func (o *SnaplockRetentionOperationDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnaplockRetentionOperationDeleteDefault creates a SnaplockRetentionOperationDeleteDefault with default headers values
func NewSnaplockRetentionOperationDeleteDefault(code int) *SnaplockRetentionOperationDeleteDefault {
	return &SnaplockRetentionOperationDeleteDefault{
		_statusCode: code,
	}
}

/*
	SnaplockRetentionOperationDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 14090541    | A completed or failed operation cannot be aborted |
| 14090242    | Only a user with the security login role \"vsadmin-snaplock\" is allowed to perform this operation. |
*/
type SnaplockRetentionOperationDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock retention operation delete default response has a 2xx status code
func (o *SnaplockRetentionOperationDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock retention operation delete default response has a 3xx status code
func (o *SnaplockRetentionOperationDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock retention operation delete default response has a 4xx status code
func (o *SnaplockRetentionOperationDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock retention operation delete default response has a 5xx status code
func (o *SnaplockRetentionOperationDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock retention operation delete default response a status code equal to that given
func (o *SnaplockRetentionOperationDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock retention operation delete default response
func (o *SnaplockRetentionOperationDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockRetentionOperationDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/operations/{id}][%d] snaplock_retention_operation_delete default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionOperationDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/operations/{id}][%d] snaplock_retention_operation_delete default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionOperationDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockRetentionOperationDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
