// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockRetentionPolicyCollectionGetReader is a Reader for the SnaplockRetentionPolicyCollectionGet structure.
type SnaplockRetentionPolicyCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockRetentionPolicyCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockRetentionPolicyCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockRetentionPolicyCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockRetentionPolicyCollectionGetOK creates a SnaplockRetentionPolicyCollectionGetOK with default headers values
func NewSnaplockRetentionPolicyCollectionGetOK() *SnaplockRetentionPolicyCollectionGetOK {
	return &SnaplockRetentionPolicyCollectionGetOK{}
}

/*
SnaplockRetentionPolicyCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockRetentionPolicyCollectionGetOK struct {
	Payload *models.SnaplockRetentionPolicyResponse
}

// IsSuccess returns true when this snaplock retention policy collection get o k response has a 2xx status code
func (o *SnaplockRetentionPolicyCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock retention policy collection get o k response has a 3xx status code
func (o *SnaplockRetentionPolicyCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock retention policy collection get o k response has a 4xx status code
func (o *SnaplockRetentionPolicyCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock retention policy collection get o k response has a 5xx status code
func (o *SnaplockRetentionPolicyCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock retention policy collection get o k response a status code equal to that given
func (o *SnaplockRetentionPolicyCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock retention policy collection get o k response
func (o *SnaplockRetentionPolicyCollectionGetOK) Code() int {
	return 200
}

func (o *SnaplockRetentionPolicyCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/event-retention/policies][%d] snaplockRetentionPolicyCollectionGetOK %s", 200, payload)
}

func (o *SnaplockRetentionPolicyCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/event-retention/policies][%d] snaplockRetentionPolicyCollectionGetOK %s", 200, payload)
}

func (o *SnaplockRetentionPolicyCollectionGetOK) GetPayload() *models.SnaplockRetentionPolicyResponse {
	return o.Payload
}

func (o *SnaplockRetentionPolicyCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnaplockRetentionPolicyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnaplockRetentionPolicyCollectionGetDefault creates a SnaplockRetentionPolicyCollectionGetDefault with default headers values
func NewSnaplockRetentionPolicyCollectionGetDefault(code int) *SnaplockRetentionPolicyCollectionGetDefault {
	return &SnaplockRetentionPolicyCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	SnaplockRetentionPolicyCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
|   918253    | Incorrect format for the retention period, duration must be in the ISO-8601 format or infinite or unspecified. |
| 13763280    | Only a user with security login role \"vsadmin-snaplock\" is allowed to perform this operation.  |
*/
type SnaplockRetentionPolicyCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock retention policy collection get default response has a 2xx status code
func (o *SnaplockRetentionPolicyCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock retention policy collection get default response has a 3xx status code
func (o *SnaplockRetentionPolicyCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock retention policy collection get default response has a 4xx status code
func (o *SnaplockRetentionPolicyCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock retention policy collection get default response has a 5xx status code
func (o *SnaplockRetentionPolicyCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock retention policy collection get default response a status code equal to that given
func (o *SnaplockRetentionPolicyCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock retention policy collection get default response
func (o *SnaplockRetentionPolicyCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockRetentionPolicyCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/event-retention/policies][%d] snaplock_retention_policy_collection_get default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionPolicyCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/snaplock/event-retention/policies][%d] snaplock_retention_policy_collection_get default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionPolicyCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockRetentionPolicyCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
