// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSnaplockRetentionPolicyCreateParams creates a new SnaplockRetentionPolicyCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnaplockRetentionPolicyCreateParams() *SnaplockRetentionPolicyCreateParams {
	return &SnaplockRetentionPolicyCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnaplockRetentionPolicyCreateParamsWithTimeout creates a new SnaplockRetentionPolicyCreateParams object
// with the ability to set a timeout on a request.
func NewSnaplockRetentionPolicyCreateParamsWithTimeout(timeout time.Duration) *SnaplockRetentionPolicyCreateParams {
	return &SnaplockRetentionPolicyCreateParams{
		timeout: timeout,
	}
}

// NewSnaplockRetentionPolicyCreateParamsWithContext creates a new SnaplockRetentionPolicyCreateParams object
// with the ability to set a context for a request.
func NewSnaplockRetentionPolicyCreateParamsWithContext(ctx context.Context) *SnaplockRetentionPolicyCreateParams {
	return &SnaplockRetentionPolicyCreateParams{
		Context: ctx,
	}
}

// NewSnaplockRetentionPolicyCreateParamsWithHTTPClient creates a new SnaplockRetentionPolicyCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnaplockRetentionPolicyCreateParamsWithHTTPClient(client *http.Client) *SnaplockRetentionPolicyCreateParams {
	return &SnaplockRetentionPolicyCreateParams{
		HTTPClient: client,
	}
}

/*
SnaplockRetentionPolicyCreateParams contains all the parameters to send to the API endpoint

	for the snaplock retention policy create operation.

	Typically these are written to a http.Request.
*/
type SnaplockRetentionPolicyCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.SnaplockRetentionPolicy

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snaplock retention policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockRetentionPolicyCreateParams) WithDefaults() *SnaplockRetentionPolicyCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snaplock retention policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnaplockRetentionPolicyCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := SnaplockRetentionPolicyCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snaplock retention policy create params
func (o *SnaplockRetentionPolicyCreateParams) WithTimeout(timeout time.Duration) *SnaplockRetentionPolicyCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snaplock retention policy create params
func (o *SnaplockRetentionPolicyCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snaplock retention policy create params
func (o *SnaplockRetentionPolicyCreateParams) WithContext(ctx context.Context) *SnaplockRetentionPolicyCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snaplock retention policy create params
func (o *SnaplockRetentionPolicyCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snaplock retention policy create params
func (o *SnaplockRetentionPolicyCreateParams) WithHTTPClient(client *http.Client) *SnaplockRetentionPolicyCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snaplock retention policy create params
func (o *SnaplockRetentionPolicyCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the snaplock retention policy create params
func (o *SnaplockRetentionPolicyCreateParams) WithInfo(info *models.SnaplockRetentionPolicy) *SnaplockRetentionPolicyCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snaplock retention policy create params
func (o *SnaplockRetentionPolicyCreateParams) SetInfo(info *models.SnaplockRetentionPolicy) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the snaplock retention policy create params
func (o *SnaplockRetentionPolicyCreateParams) WithReturnRecords(returnRecords *bool) *SnaplockRetentionPolicyCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snaplock retention policy create params
func (o *SnaplockRetentionPolicyCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SnaplockRetentionPolicyCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
