// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockRetentionPolicyDeleteCollectionReader is a Reader for the SnaplockRetentionPolicyDeleteCollection structure.
type SnaplockRetentionPolicyDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockRetentionPolicyDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockRetentionPolicyDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockRetentionPolicyDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockRetentionPolicyDeleteCollectionOK creates a SnaplockRetentionPolicyDeleteCollectionOK with default headers values
func NewSnaplockRetentionPolicyDeleteCollectionOK() *SnaplockRetentionPolicyDeleteCollectionOK {
	return &SnaplockRetentionPolicyDeleteCollectionOK{}
}

/*
SnaplockRetentionPolicyDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockRetentionPolicyDeleteCollectionOK struct {
}

// IsSuccess returns true when this snaplock retention policy delete collection o k response has a 2xx status code
func (o *SnaplockRetentionPolicyDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock retention policy delete collection o k response has a 3xx status code
func (o *SnaplockRetentionPolicyDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock retention policy delete collection o k response has a 4xx status code
func (o *SnaplockRetentionPolicyDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock retention policy delete collection o k response has a 5xx status code
func (o *SnaplockRetentionPolicyDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock retention policy delete collection o k response a status code equal to that given
func (o *SnaplockRetentionPolicyDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock retention policy delete collection o k response
func (o *SnaplockRetentionPolicyDeleteCollectionOK) Code() int {
	return 200
}

func (o *SnaplockRetentionPolicyDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/policies][%d] snaplockRetentionPolicyDeleteCollectionOK", 200)
}

func (o *SnaplockRetentionPolicyDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/policies][%d] snaplockRetentionPolicyDeleteCollectionOK", 200)
}

func (o *SnaplockRetentionPolicyDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnaplockRetentionPolicyDeleteCollectionDefault creates a SnaplockRetentionPolicyDeleteCollectionDefault with default headers values
func NewSnaplockRetentionPolicyDeleteCollectionDefault(code int) *SnaplockRetentionPolicyDeleteCollectionDefault {
	return &SnaplockRetentionPolicyDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnaplockRetentionPolicyDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13763280    | Only a user with security login role \"vsadmin-snaplock\" is allowed to perform this operation.  |
*/
type SnaplockRetentionPolicyDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock retention policy delete collection default response has a 2xx status code
func (o *SnaplockRetentionPolicyDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock retention policy delete collection default response has a 3xx status code
func (o *SnaplockRetentionPolicyDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock retention policy delete collection default response has a 4xx status code
func (o *SnaplockRetentionPolicyDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock retention policy delete collection default response has a 5xx status code
func (o *SnaplockRetentionPolicyDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock retention policy delete collection default response a status code equal to that given
func (o *SnaplockRetentionPolicyDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock retention policy delete collection default response
func (o *SnaplockRetentionPolicyDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockRetentionPolicyDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/policies][%d] snaplock_retention_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionPolicyDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/snaplock/event-retention/policies][%d] snaplock_retention_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionPolicyDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockRetentionPolicyDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnaplockRetentionPolicyDeleteCollectionBody snaplock retention policy delete collection body
swagger:model SnaplockRetentionPolicyDeleteCollectionBody
*/
type SnaplockRetentionPolicyDeleteCollectionBody struct {

	// snaplock retention policy response inline records
	SnaplockRetentionPolicyResponseInlineRecords []*models.SnaplockRetentionPolicy `json:"records,omitempty"`
}

// Validate validates this snaplock retention policy delete collection body
func (o *SnaplockRetentionPolicyDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnaplockRetentionPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionPolicyDeleteCollectionBody) validateSnaplockRetentionPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnaplockRetentionPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnaplockRetentionPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.SnaplockRetentionPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnaplockRetentionPolicyResponseInlineRecords[i] != nil {
			if err := o.SnaplockRetentionPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this snaplock retention policy delete collection body based on the context it is used
func (o *SnaplockRetentionPolicyDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnaplockRetentionPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionPolicyDeleteCollectionBody) contextValidateSnaplockRetentionPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnaplockRetentionPolicyResponseInlineRecords); i++ {

		if o.SnaplockRetentionPolicyResponseInlineRecords[i] != nil {
			if err := o.SnaplockRetentionPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnaplockRetentionPolicyDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnaplockRetentionPolicyDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnaplockRetentionPolicyDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
