// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockRetentionPolicyModifyCollectionReader is a Reader for the SnaplockRetentionPolicyModifyCollection structure.
type SnaplockRetentionPolicyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockRetentionPolicyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockRetentionPolicyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockRetentionPolicyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockRetentionPolicyModifyCollectionOK creates a SnaplockRetentionPolicyModifyCollectionOK with default headers values
func NewSnaplockRetentionPolicyModifyCollectionOK() *SnaplockRetentionPolicyModifyCollectionOK {
	return &SnaplockRetentionPolicyModifyCollectionOK{}
}

/*
SnaplockRetentionPolicyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockRetentionPolicyModifyCollectionOK struct {
}

// IsSuccess returns true when this snaplock retention policy modify collection o k response has a 2xx status code
func (o *SnaplockRetentionPolicyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock retention policy modify collection o k response has a 3xx status code
func (o *SnaplockRetentionPolicyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock retention policy modify collection o k response has a 4xx status code
func (o *SnaplockRetentionPolicyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock retention policy modify collection o k response has a 5xx status code
func (o *SnaplockRetentionPolicyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock retention policy modify collection o k response a status code equal to that given
func (o *SnaplockRetentionPolicyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock retention policy modify collection o k response
func (o *SnaplockRetentionPolicyModifyCollectionOK) Code() int {
	return 200
}

func (o *SnaplockRetentionPolicyModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/snaplock/event-retention/policies][%d] snaplockRetentionPolicyModifyCollectionOK", 200)
}

func (o *SnaplockRetentionPolicyModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /storage/snaplock/event-retention/policies][%d] snaplockRetentionPolicyModifyCollectionOK", 200)
}

func (o *SnaplockRetentionPolicyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnaplockRetentionPolicyModifyCollectionDefault creates a SnaplockRetentionPolicyModifyCollectionDefault with default headers values
func NewSnaplockRetentionPolicyModifyCollectionDefault(code int) *SnaplockRetentionPolicyModifyCollectionDefault {
	return &SnaplockRetentionPolicyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnaplockRetentionPolicyModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
|   918253    | Incorrect format for the retention period, duration must be in the ISO-8601 format or infinite or unspecified. |
| 13763280    | Only a user with security login role \"vsadmin-snaplock\" is allowed to perform this operation.  |
*/
type SnaplockRetentionPolicyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock retention policy modify collection default response has a 2xx status code
func (o *SnaplockRetentionPolicyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock retention policy modify collection default response has a 3xx status code
func (o *SnaplockRetentionPolicyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock retention policy modify collection default response has a 4xx status code
func (o *SnaplockRetentionPolicyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock retention policy modify collection default response has a 5xx status code
func (o *SnaplockRetentionPolicyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock retention policy modify collection default response a status code equal to that given
func (o *SnaplockRetentionPolicyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock retention policy modify collection default response
func (o *SnaplockRetentionPolicyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockRetentionPolicyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/snaplock/event-retention/policies][%d] snaplock_retention_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionPolicyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/snaplock/event-retention/policies][%d] snaplock_retention_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionPolicyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockRetentionPolicyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnaplockRetentionPolicyModifyCollectionBody snaplock retention policy modify collection body
swagger:model SnaplockRetentionPolicyModifyCollectionBody
*/
type SnaplockRetentionPolicyModifyCollectionBody struct {

	// links
	Links *models.SnaplockRetentionPolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the EBR policy name
	Name *string `json:"name,omitempty"`

	// Specifies the retention period of an event based retention policy. The retention period value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours or minutes. A period specified for years, months and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively. For example "P10Y" represents a duration of 10 years. Similarly, a duration in hours, minutes is represented by "PT<num>H", "PT<num>M" respectively. The period string must contain only a single time element i.e. either years, months, days, hours or minutes. A duration which combines different periods is not supported, example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the retention period field also accepts the strings "infinite" and "unspecified".
	// Example: P30M
	RetentionPeriod *string `json:"retention_period,omitempty"`

	// snaplock retention policy response inline records
	SnaplockRetentionPolicyResponseInlineRecords []*models.SnaplockRetentionPolicy `json:"records,omitempty"`

	// svm
	Svm *models.SnaplockRetentionPolicyInlineSvm `json:"svm,omitempty"`
}

// Validate validates this snaplock retention policy modify collection body
func (o *SnaplockRetentionPolicyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplockRetentionPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionPolicyModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnaplockRetentionPolicyModifyCollectionBody) validateSnaplockRetentionPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnaplockRetentionPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnaplockRetentionPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.SnaplockRetentionPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnaplockRetentionPolicyResponseInlineRecords[i] != nil {
			if err := o.SnaplockRetentionPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnaplockRetentionPolicyModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock retention policy modify collection body based on the context it is used
func (o *SnaplockRetentionPolicyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnaplockRetentionPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionPolicyModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnaplockRetentionPolicyModifyCollectionBody) contextValidateSnaplockRetentionPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnaplockRetentionPolicyResponseInlineRecords); i++ {

		if o.SnaplockRetentionPolicyResponseInlineRecords[i] != nil {
			if err := o.SnaplockRetentionPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnaplockRetentionPolicyModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnaplockRetentionPolicyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnaplockRetentionPolicyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnaplockRetentionPolicyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnaplockRetentionPolicyInlineLinks snaplock retention policy inline links
swagger:model snaplock_retention_policy_inline__links
*/
type SnaplockRetentionPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snaplock retention policy inline links
func (o *SnaplockRetentionPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock retention policy inline links based on the context it is used
func (o *SnaplockRetentionPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnaplockRetentionPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnaplockRetentionPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnaplockRetentionPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnaplockRetentionPolicyInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model snaplock_retention_policy_inline_svm
*/
type SnaplockRetentionPolicyInlineSvm struct {

	// links
	Links *models.SnaplockRetentionPolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snaplock retention policy inline svm
func (o *SnaplockRetentionPolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionPolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock retention policy inline svm based on the context it is used
func (o *SnaplockRetentionPolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionPolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnaplockRetentionPolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnaplockRetentionPolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res SnaplockRetentionPolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnaplockRetentionPolicyInlineSvmInlineLinks snaplock retention policy inline svm inline links
swagger:model snaplock_retention_policy_inline_svm_inline__links
*/
type SnaplockRetentionPolicyInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snaplock retention policy inline svm inline links
func (o *SnaplockRetentionPolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionPolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock retention policy inline svm inline links based on the context it is used
func (o *SnaplockRetentionPolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnaplockRetentionPolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnaplockRetentionPolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnaplockRetentionPolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnaplockRetentionPolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
