// Code generated by go-swagger; DO NOT EDIT.

package snaplock

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnaplockRetentionPolicyModifyReader is a Reader for the SnaplockRetentionPolicyModify structure.
type SnaplockRetentionPolicyModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnaplockRetentionPolicyModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnaplockRetentionPolicyModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnaplockRetentionPolicyModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnaplockRetentionPolicyModifyOK creates a SnaplockRetentionPolicyModifyOK with default headers values
func NewSnaplockRetentionPolicyModifyOK() *SnaplockRetentionPolicyModifyOK {
	return &SnaplockRetentionPolicyModifyOK{}
}

/*
SnaplockRetentionPolicyModifyOK describes a response with status code 200, with default header values.

OK
*/
type SnaplockRetentionPolicyModifyOK struct {
}

// IsSuccess returns true when this snaplock retention policy modify o k response has a 2xx status code
func (o *SnaplockRetentionPolicyModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snaplock retention policy modify o k response has a 3xx status code
func (o *SnaplockRetentionPolicyModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snaplock retention policy modify o k response has a 4xx status code
func (o *SnaplockRetentionPolicyModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snaplock retention policy modify o k response has a 5xx status code
func (o *SnaplockRetentionPolicyModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snaplock retention policy modify o k response a status code equal to that given
func (o *SnaplockRetentionPolicyModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snaplock retention policy modify o k response
func (o *SnaplockRetentionPolicyModifyOK) Code() int {
	return 200
}

func (o *SnaplockRetentionPolicyModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/snaplock/event-retention/policies/{policy.name}][%d] snaplockRetentionPolicyModifyOK", 200)
}

func (o *SnaplockRetentionPolicyModifyOK) String() string {
	return fmt.Sprintf("[PATCH /storage/snaplock/event-retention/policies/{policy.name}][%d] snaplockRetentionPolicyModifyOK", 200)
}

func (o *SnaplockRetentionPolicyModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnaplockRetentionPolicyModifyDefault creates a SnaplockRetentionPolicyModifyDefault with default headers values
func NewSnaplockRetentionPolicyModifyDefault(code int) *SnaplockRetentionPolicyModifyDefault {
	return &SnaplockRetentionPolicyModifyDefault{
		_statusCode: code,
	}
}

/*
	SnaplockRetentionPolicyModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
|   918253    | Incorrect format for the retention period, duration must be in the ISO-8601 format or infinite or unspecified. |
| 13763280    | Only a user with security login role \"vsadmin-snaplock\" is allowed to perform this operation.  |
*/
type SnaplockRetentionPolicyModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snaplock retention policy modify default response has a 2xx status code
func (o *SnaplockRetentionPolicyModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snaplock retention policy modify default response has a 3xx status code
func (o *SnaplockRetentionPolicyModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snaplock retention policy modify default response has a 4xx status code
func (o *SnaplockRetentionPolicyModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snaplock retention policy modify default response has a 5xx status code
func (o *SnaplockRetentionPolicyModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snaplock retention policy modify default response a status code equal to that given
func (o *SnaplockRetentionPolicyModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snaplock retention policy modify default response
func (o *SnaplockRetentionPolicyModifyDefault) Code() int {
	return o._statusCode
}

func (o *SnaplockRetentionPolicyModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/snaplock/event-retention/policies/{policy.name}][%d] snaplock_retention_policy_modify default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionPolicyModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/snaplock/event-retention/policies/{policy.name}][%d] snaplock_retention_policy_modify default %s", o._statusCode, payload)
}

func (o *SnaplockRetentionPolicyModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnaplockRetentionPolicyModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
