// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new snapmirror API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for snapmirror API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	SnapmirrorPoliciesGet(params *SnapmirrorPoliciesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPoliciesGetOK, error)

	SnapmirrorPolicyCreate(params *SnapmirrorPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyCreateCreated, *SnapmirrorPolicyCreateAccepted, error)

	SnapmirrorPolicyDelete(params *SnapmirrorPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyDeleteOK, *SnapmirrorPolicyDeleteAccepted, error)

	SnapmirrorPolicyDeleteCollection(params *SnapmirrorPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyDeleteCollectionOK, *SnapmirrorPolicyDeleteCollectionAccepted, error)

	SnapmirrorPolicyGet(params *SnapmirrorPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyGetOK, error)

	SnapmirrorPolicyModify(params *SnapmirrorPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyModifyOK, *SnapmirrorPolicyModifyAccepted, error)

	SnapmirrorPolicyModifyCollection(params *SnapmirrorPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyModifyCollectionOK, *SnapmirrorPolicyModifyCollectionAccepted, error)

	SnapmirrorRelationshipCreate(params *SnapmirrorRelationshipCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipCreateCreated, *SnapmirrorRelationshipCreateAccepted, error)

	SnapmirrorRelationshipDelete(params *SnapmirrorRelationshipDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipDeleteOK, *SnapmirrorRelationshipDeleteAccepted, error)

	SnapmirrorRelationshipDeleteCollection(params *SnapmirrorRelationshipDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipDeleteCollectionOK, *SnapmirrorRelationshipDeleteCollectionAccepted, error)

	SnapmirrorRelationshipGet(params *SnapmirrorRelationshipGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipGetOK, error)

	SnapmirrorRelationshipModify(params *SnapmirrorRelationshipModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipModifyOK, *SnapmirrorRelationshipModifyAccepted, error)

	SnapmirrorRelationshipModifyCollection(params *SnapmirrorRelationshipModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipModifyCollectionOK, *SnapmirrorRelationshipModifyCollectionAccepted, error)

	SnapmirrorRelationshipTransferCreate(params *SnapmirrorRelationshipTransferCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipTransferCreateCreated, error)

	SnapmirrorRelationshipTransferGet(params *SnapmirrorRelationshipTransferGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipTransferGetOK, error)

	SnapmirrorRelationshipTransferModify(params *SnapmirrorRelationshipTransferModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipTransferModifyOK, error)

	SnapmirrorRelationshipTransferModifyCollection(params *SnapmirrorRelationshipTransferModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipTransferModifyCollectionOK, error)

	SnapmirrorRelationshipTransfersGet(params *SnapmirrorRelationshipTransfersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipTransfersGetOK, error)

	SnapmirrorRelationshipsGet(params *SnapmirrorRelationshipsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipsGetOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	SnapmirrorPoliciesGet Retrieves SnapMirror policies of type "async" and "sync".

### Related ONTAP commands
* `snapmirror policy show`
### Example
The following example shows how to retrieve a collection of SnapMirror policies.
<br/>
```
GET "/api/snapmirror/policies"
```
<br/>
### Learn more
* [`DOC /snapmirror/policies`](#docs-snapmirror-snapmirror_policies)
*/
func (a *Client) SnapmirrorPoliciesGet(params *SnapmirrorPoliciesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPoliciesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorPoliciesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_policies_get",
		Method:             "GET",
		PathPattern:        "/snapmirror/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorPoliciesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapmirrorPoliciesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorPoliciesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorPolicyCreate Creates a SnapMirror policy. The property "identity_preservation" is applicable to only SnapMirror relationships with SVM endpoints and it indicates which configuration of the source SVM is replicated to the destination SVM.</br>

It takes the following values:
- `full` - indicates that the source SVM configuration is replicated to the destination SVM endpoint.
- `exclude_network_config` - indicates that the source SVM configuration other than network configuration is replicated to the destination SVM endpoint.
- `exclude_network_and_protocol_config` - indicates that the source SVM configuration is not replicated to the destination SVM endpoint.<br/>
### Important notes
- The property "identity_preservation" is applicable to only SnapMirror relationships with SVM endpoints and it indicates which configuration of the source SVM is replicated to the destination SVM.
- The properties "identity_preservation" and "transfer_schedule" are not applicable for "sync" type policies.
- The properties "copy_all_source_snapshots", "copy_latest_source_snapshot", and "create_snapshot_on_source" are mutually exclusive.
- The properties "copy_all_source_snapshots", "copy_latest_source_snapshot", and "create_snapshot_on_source" are not applicable for "sync" type policies.
- No "retention" properties can be specified if "copy_all_source_snapshots" or 'copy_latest_source_snapshot' is specified.
- The properties "retention.creation_schedule" and "retention.prefix" are not applicable for "sync" type policies.
- The property "retention.creation_schedule" is not applicable for "async" policies with "create_snapshot_on_source" set to "false".
- The property "sync_common_snapshot_schedule" is not applicable for an "async" type policy.
- The property "retention.count" specifies the maximum number of snapshots that are retained on the SnapMirror destination volume.
- When the property "retention.label" is specified, the snapshots that have a SnapMirror label matching this property is transferred to the SnapMirror destination.
- When the property "retention.creation_schedule" is specified, snapshots are directly created on the SnapMirror destination. The snapshots created have the same content as the latest snapshot already present on the SnapMirror destination.
- The property "transfer_schedule" cannot be set to null (no-quotes) during SnapMirror policy POST.
- The properties "retention.label" and "retention.count" must be specified for "async" policies with "create_snapshot_on_source" set to "false".
- The property "retention.warn" is not supported for a policy when the "retention.preserve" property is false.
- The property "retention.warn" value must be less than the property "retention.count" value for a rule in a policy.

### Required properties
* `name` - Name of the new SnapMirror policy.
### Recommended optional properties
* `svm.name` or `svm.uuid` - Name or UUID of the SVM that owns the SnapMirror policy.
### Default property values
If not specified in POST, the following default property values are assigned:
* `type` - _async_
* `sync_type` - _sync_ (when `type` is _sync_)
* `network_compression_enabled` - _false_
* `throttle` - _0_
* `identity_preservation` - `_exclude_network_and_protocol_config_`

### Related ONTAP commands
* `snapmirror policy create`
### Examples

	Creating a SnapMirror policy of type "sync"
	 <br/>
	 ```
	 POST "/api/snapmirror/policies/" '{"name": "policy1", "svm.name": "VS0", "type": "sync", "sync_type": "sync"}'
	 ```
	 <br/>
	Creating a SnapMirror policy of type "async" with two sets of retention values, one with a creation_schedule
	 <br/>
	 ```
	 POST "/api/snapmirror/policies" '{"name": "policy_ret", "svm": {"name": "vs1"}, "retention": [{"label": "weekly", "count": "2", "creation_schedule": {"name": "weekly"}}, {"label":"daily", "count":"7"}]}'
	 ```
	 <br/>
	Creating a SnapMirror policy of type "async"
	 ```
	 POST "/api/snapmirror/policies" '{"name": "newPolicy", "svm":{"name" : "vs1"}, "type": "async"}'
	 ```
	 <br/>
	Creating a SnapMirror policy of type "async" which replicates all snapshots
	 ```
	 POST "/api/snapmirror/policies" '{"name": "newPolicy", "svm":{"name" : "vs1"}, "type": "async", "copy_all_source_snapshots": "true"}'
	 ```
	 <br/>
	Creating a SnapMirror policy of type "async" which replicates latest snapshot
	 ```
	 POST "/api/snapmirror/policies" '{"name": "newPolicy2", "svm":{"name" : "vs1"}, "type": "async", "copy_latest_source_snapshot": "true"}'
	 ```
	 <br/>
	Creating a SnapMirror policy of type "async" which does not create snapshots on source
	 ```
	 POST "/api/snapmirror/policies" '{"name": "newPolicy", "svm":{"name" : "vs1"}, "type": "async", "create_snapshot_on_source": "false", "retention": [{"label": "daily", "count": 7}]}'
	 ```
	 <br/>
	Creating a SnapMirror policy of type "sync" with sync_type as "automated_failover"
	 <br/>
	 ```
	 POST "/api/snapmirror/policies/" '{"name": "policy1", "svm.name": "VS0", "type": "sync", "sync_type": "automated_failover" }'
	 ```
	 <br/>
	Creating a SnapMirror policy of type "sync" with sync_type as "automated_failover_duplex"
	 <br/>
	 ```
	 POST "/api/snapmirror/policies/" '{"name": "policy_afd", "svm.name": "VS0", "type": "sync", "sync_type": "automated_failover_duplex" }'
	 ```
	 <br/>



	Creating a SnapMirror policy of type "async" with two sets of retention values and retention periods
	 ```
	 POST "/api/snapmirror/policies" '{"name": "policy_ret", "svm": {"name": "vs1"}, "retention": [{"label": "weekly", "count": "2", "period": "P7D"}, {"label":"daily", "count":"7", "period": "PT3H"}]}'
	 ```
	 <br/>
	 Creating a SnapMirror policy of type "async" with retention value as "infinite"
	 ```
	 POST "/api/snapmirror/policies" '{"name": "policy_ret", "svm": {"name": "vs1"}, "retention": [{"label": "weekly", "count": "5", "period": "infinite"}]}'
	 ```
	 <br/>
	 Creating a SnapMirror policy of type "async" with properties retention preserve as true and retention warn as 3.
	 ```
	 POST "/api/snapmirror/policies" '{"name": "policy_ret", "svm": {"name": "vs1"}, "retention": [{"label": "weekly", "count": "5", "preserve": true, "warn": 3}]}'
	 ```
	 <br/>

### Learn more
* [`DOC /snapmirror/policies`](#docs-snapmirror-snapmirror_policies)
*/
func (a *Client) SnapmirrorPolicyCreate(params *SnapmirrorPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyCreateCreated, *SnapmirrorPolicyCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorPolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_policy_create",
		Method:             "POST",
		PathPattern:        "/snapmirror/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorPolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapmirrorPolicyCreateCreated:
		return value, nil, nil
	case *SnapmirrorPolicyCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorPolicyCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorPolicyDelete Deletes a SnapMirror policy.

### Related ONTAP commands
* `snapmirror policy delete`
### Example
<br/>
```
DELETE "/api/snapmirror/policies/510c15d4-f9e6-11e8-bdb5-0050568e12c2"
```
<br/>
### Learn more
* [`DOC /snapmirror/policies`](#docs-snapmirror-snapmirror_policies)
*/
func (a *Client) SnapmirrorPolicyDelete(params *SnapmirrorPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyDeleteOK, *SnapmirrorPolicyDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorPolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_policy_delete",
		Method:             "DELETE",
		PathPattern:        "/snapmirror/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorPolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapmirrorPolicyDeleteOK:
		return value, nil, nil
	case *SnapmirrorPolicyDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorPolicyDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapmirrorPolicyDeleteCollection snapmirror policy delete collection API
*/
func (a *Client) SnapmirrorPolicyDeleteCollection(params *SnapmirrorPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyDeleteCollectionOK, *SnapmirrorPolicyDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorPolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_policy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/snapmirror/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorPolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapmirrorPolicyDeleteCollectionOK:
		return value, nil, nil
	case *SnapmirrorPolicyDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorPolicyDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorPolicyGet Retrieves a specific SnapMirror policy.

### Example
<br/>
```
GET "/api/snapmirror/policies/567aaac0-f863-11e8-a666-0050568e12c2"
```
<br/>
### Learn more
* [`DOC /snapmirror/policies`](#docs-snapmirror-snapmirror_policies)
*/
func (a *Client) SnapmirrorPolicyGet(params *SnapmirrorPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorPolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_policy_get",
		Method:             "GET",
		PathPattern:        "/snapmirror/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorPolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapmirrorPolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorPolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorPolicyModify Updates the SnapMirror policy.

### Important notes
* The properties "retention.label" and "retention.count" are mandatory if "retention" is provided in the input. The provided "retention.label" is the final list and it replaces the existing values.
* The value of the "identity_preservation" property cannot be changed if the SnapMirror relationships associated with the policy have different identity_preservation configurations.
* If the SnapMirror policy "identity_preservation" value matches the "identity_preservation" value of the associated SnapMirror relationships, then the "identity_preservation" value can be changed from a higher "identity_preservation" threshold value to a lower "identity_preservation" threshold value but not vice-versa. For example, the threshold value of the "identity_preservation" property can be changed from "full" to "exclude_network_config", but cannot be increased from "exclude_network_and_protocol_config" to "exclude_network_config" to "full". The threshold value of the "identity_preservation" cannot be changed to "exclude_network_and_protocol_config" for IDP SVMDR.<br/>
* The policy properties "copy_all_source_snapshots", "copy_latest_source_snapshot", and "create_snapshot_on_source" cannot be modified.
* No "retention" properties can be modified if the "copy_all_source_snapshots" or "copy_latest_source_snapshot" property is present in the policy.
* Replacing or deleting all retention rules of a policy that has the "create_snapshot_on_source" property set to false in a single API call is not supported.
* Modifying the property "retention.label" for all retention rules of a policy that has the "create_snapshot_on_source" property set to false in a single API call is not supported.
* To remove a transfer_schedule on a SnapMirror policy set the "transfer_schedule" to null (no-quotes) during SnapMirror policy PATCH.

### Related ONTAP commands
* `snapmirror policy modify`
### Example

	Updating the "retention" property to add rules to a policy without any rules.
	 <br/>
	 ```
	 PATCH "/api/snapmirror/policies/fe65686d-00dc-11e9-b5fb-0050568e3f83" '{"retention": [{"label": "newlabel", "count": 2}, {"label": "weekly", "count": 2, "creation_schedule": {"name": "weekly"}}, {"label": "daily", "count": 14}]}'
	 ```
	 <br/>
	Updating the "retention" property to add rules to a policy with existing rules {"retention": [{"label": "oldLabel1", "count": 2}, {"label": "oldLabel2", "count": 5}]
	 <br/>
	 ```
	 PATCH "/api/snapmirror/policies/fe65686d-00dc-11e9-b5fb-0050568e3f83" '{"retention": [{"label": "oldLabel1", "count": 2}, {"label": "oldLabel2", "count": 5}, {"label": "newlabel", "count": 3}, {"label": "weekly", "count": 1}]}'
	 ```
	 <br/>
	Updating the "retention" property to remove a rule (oldLabel1) and add new rule to a policy with existing rules {"retention": [{"label": "oldLabel1", "count": 2}, {"label": "oldLabel2", "count": 3}]
	 <br/>
	 ```
	 PATCH "/api/snapmirror/policies/fe65686d-00dc-11e9-b5fb-0050568e3f83" '{"retention": [{"label": "oldLabel2", "count": 3}, {"label": "newlabel", "count": 2}]}'
	 ```
	 <br/>
	Updating "transfer_schedule", "throttle", and "identity_preservation" properties
	 <br/>
	 ```
	 PATCH "/api/snapmirror/policies/8aef950b-3bef-11e9-80ac-0050568ea591" '{"transfer_schedule.name" : "weekly", "throttle" : "100", "identity_preservation":"exclude_network_and_protocol_config"}'
	 ```
	 <br/>
	 Removing the SnapMirror transfer_schedule for a SnapMirror policy. Transfer_schedule can be specified as UUID or name or both with the value set to null (no-quotes).
	 <br/>
	 ```
	 PATCH "/api/snapmirror/policies/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"transfer_schedule":{"uuid":null, "name":null}}'
	 ```
	 <br/>

	Updating the "retention" property to have retention.preserve and retention.warn for existing rule.
	 <br/>
	 ```
	 PATCH "/api/snapmirror/policies/fe65686d-00dc-11e9-b5fb-0050568e3f83" '{"retention": [{"label": "oldLabel1", "count": 3, "preserve": true, "warn": 2}]}'
	 ```
	 <br/>

### Learn more
* [`DOC /snapmirror/policies`](#docs-snapmirror-snapmirror_policies)
*/
func (a *Client) SnapmirrorPolicyModify(params *SnapmirrorPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyModifyOK, *SnapmirrorPolicyModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorPolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/snapmirror/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorPolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapmirrorPolicyModifyOK:
		return value, nil, nil
	case *SnapmirrorPolicyModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorPolicyModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapmirrorPolicyModifyCollection snapmirror policy modify collection API
*/
func (a *Client) SnapmirrorPolicyModifyCollection(params *SnapmirrorPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorPolicyModifyCollectionOK, *SnapmirrorPolicyModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorPolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/snapmirror/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorPolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapmirrorPolicyModifyCollectionOK:
		return value, nil, nil
	case *SnapmirrorPolicyModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorPolicyModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorRelationshipCreate Creates a SnapMirror relationship. This API can optionally provision the destination endpoint when it does not exist. This API must be executed on the cluster containing the destination endpoint unless the destination endpoint is being provisioned. When the destination endpoint is being provisioned, this API can also be executed from the cluster containing the source endpoint. Provisioning of the destination endpoint from the source cluster is supported for the FlexVol volume, FlexGroup volume and Application Consistency Group endpoints.<br/>

For SVM endpoints, provisioning the destination SVM endpoint is not supported from the source cluster. When the destination endpoint exists, the source SVM and the destination SVM must be in an SVM peer relationship. When provisioning the destination endpoint, the SVM peer relationship between the source SVM and the destination SVM is established as part of the destination provision, provided that the source SVM has SVM peering permissions for the destination cluster.

### Required properties
* `source.path` - Path to the source endpoint of the SnapMirror relationship.
* `destination.path` - Path to the destination endpoint of the SnapMirror relationship.
* `source.consistency_group_volumes` - List of FlexVol volumes of type "RW" that are constituents of an Application Consistency Group.
* `destination.consistency_group_volumes` - List of FlexVol volumes of type "DP" that are constituents of an Application Consistency Group.
### Recommended optional properties
* `policy.name` or `policy.uuid` - Policy governing the SnapMirror relationship.
* `state` - Set the state to "snapmirrored" to automatically initialize the relationship.
* `create_destination.enabled` - Enable this property to provision the destination endpoint.

### Default property values
If not specified in POST, the following default property values are assigned:
* `policy.name` - _Asynchronous_
* `restore` - _false_
* `create_destination.tiering.policy` - `_snapshot_only_` (when `create_destination.tiering.supported` is _true_ for FlexVol volume)
* `create_destination.tiering.policy` - `_none_` (when `create_destination.tiering.supported` is _true_ for FlexGroup volume)
* `create_destination.storage_service.enforce_performance` - `_false_`

* `destination.ipspace` - `_Default_`
* `throttle` - _0_
* `backoff_level` - `_high_`
* `policy.name` - _Asynchronous_
* `restore` - _false_

* `destination.ipspace` - `_Default_`
* `throttle` - _0_
* `backoff_level` - `_high_`
### Related ONTAP commands
* `snapmirror create`
* `snapmirror protect`
### Important notes
* The property "transfer_schedule" if set on a SnapMirror relationship overrides the "transfer_schedule" set on the policy being used with the SnapMirror relationship.
* The property "throttle" if set on a SnapMirror relationship overrides the "throttle" set on the policy being used with the SnapMirror relationship.
* The properties "transfer_schedule" and "throttle" are not supported when "restore" is set to "true".
* The property "transfer_schedule" cannot be set to null (no-quotes) during SnapMirror relationship POST.
* The property "throttle" is not supported when "create_destination.enabled" is set to "true".
* The property "identity_preservation" is applicable to only SnapMirror relationships with SVM endpoints and it indicates which configuration of the source SVM is replicated to the destination SVM.
* The property "backoff_level" is not supported when "create_destination.enabled" is set to "true".
* The property "backoff_level" is only applicable for FlexVol SnapMirror relationships.
### Examples
The following examples show how to create FlexVol volumes, FlexGroup volumes, SVM and Application Consistency Group SnapMirror relationships. Note that the source SVM name must be the local name of the peer SVM.</br>

	Creating a FlexVol SnapMirror relationship of type XDP.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:src_vol"}, "destination": { "path": "dst_svm:dst_vol"}}'
	```
	<br/>
	Creating a FlexGroup SnapMirror relationship of type XDP.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:source_flexgroup"}, "destination": { "path": "dst_svm:dest_flexgroup"}}'
	```
	<br/>
	Creating a SVM SnapMirror relationship of type XDP.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": { "path": "src_svm:"}, "destination": { "path": "dst_svm:"}}'
	```
	<br/>
	Creating a SnapMirror relationship in order to restore from a destination.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:src_vol"}, "destination": { "path": "dst_svm:dst_vol"}, "restore": "true"}'
	```
	<br/>
	Provision the destination FlexVol volume endpoint and create a SnapMirror relationship of type XDP.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:src_vol"}, "destination": { "path": "dst_svm:dst_vol"}, "create_destination": { "enabled": "true" }}'
	```
	Provision the destination FlexVol volume endpoint on a Fabricpool with a tiering policy and create a SnapMirror relationship of type XDP.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:src_vol"}, "destination": { "path": "dst_svm:dst_vol"}, "create_destination": { "enabled": "true", "tiering": { "supported": "true", "policy": "auto" } } }'
	```
	Provision the destination FlexVol volume endpoint using storage service and create a SnapMirror relationship of type XDP.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:src_vol"}, "destination": { "path": "dst_svm:dst_vol"}, "create_destination": { "enabled": "true", "storage_service": { "enabled": "true", "name": "extreme", "enforce_performance": "true" } } }'
	```
	Provision the destination SVM endpoint and create a SnapMirror relationship of type XDP.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:", "cluster": { "name": "cluster_src" }}, "destination": { "path": "dst_svm:"}, "create_destination": { "enabled: "true" }}'
	```
	Create an asynchronous SnapMirror relationship with Application Consistency Group endpoint.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": { "path": "src_svm:/cg/cg_src_vol", "consistency_group_volumes": [{ "name": "src_vol_1" }, { "name": "src_vol_2" }] }, "destination": { "path": "dst_svm:/cg/cg_dst_vol", "consistency_group_volumes": [{ "name": "dst_vol_1" }, { "name": "dst_vol_2" }] }, "policy": "Asynchronous" }'
	```
	Create an asynchronous SnapMirror relationship with a child Application Consistency Group endpoint.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": { "path": "src_svm:/cg/parent_src_cg/sub_child_cg" }, "destination": { "path": "dst_svm:/cg/cg_dst_vol" }, "policy": "MirrorAndVault" }'
	```
	<personalities supports=asar2>
	Provision the destination Application Consistency Group endpoint on a Fabricpool with a tiering policy, create an asynchronous SnapMirror relationship with a SnapMirror policy of type "async", and initialize the SnapMirror relationship with state as "snapmirrored".
	<br/>
	```
	</personalities>
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:/cg/cg_src_vol", "consistency_group_volumes": [{ "name": "src_vol_1" }, { "name": "src_vol_2" }] }, "destination": { "path": "dst_svm:/cg/cg_dst_vol", "consistency_group_volumes": [{ "name": "dst_vol_1" }, { "name": "dst_vol_2" }] }, "create_destination": { "enabled": "true", "tiering": { "supported": "true" } }, "policy": "Asynchronous", "state": "snapmirrored" }'
	```
	Create a SnapMirror active sync relationship with the Application Consistency Group endpoint.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": { "path": "src_svm:/cg/cg_src_vol", "consistency_group_volumes": [{ "name": "src_vol_1" }, { "name": "src_vol_2" }] }, "destination": { "path": "dst_svm:/cg/cg_dst_vol", "consistency_group_volumes": [{ "name": "dst_vol_1" }, { "name": "dst_vol_2" }] }, "policy": "AutomatedFailOver" }'
	```
	Provision the destination Application Consistency Group endpoint on a Fabricpool with a tiering policy, create a SnapMirror active sync relationship with a SnapMirror policy of type "sync" and sync_type of "automated_failover", and initialize the SnapMirror relationship with state as "in_sync".
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:/cg/cg_src_vol", "consistency_group_volumes": [{ "name": "src_vol_1" }, { "name": "src_vol_2" }] }, "destination": { "path": "dst_svm:/cg/cg_dst_vol", "consistency_group_volumes": [{ "name": "dst_vol_1" }, { "name": "dst_vol_2" }] }, "create_destination": { "enabled": "true", "tiering": { "supported": "true" } }, "policy": "AutomatedFailOver", "state": "in_sync" }'
	```
	Provision the destination Application Consistency Group endpoint with storage service, create a SnapMirror active sync relationship with a SnapMirror policy of type "sync" and sync_type of "automated_failover", and initialize the SnapMirror relationship with state as "in_sync".
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:/cg/cg_src_vol", "consistency_group_volumes": [{ "name": "src_vol_1" }, { "name": "src_vol_2" }] }, "destination": { "path": "dst_svm:/cg/cg_dst_vol", "consistency_group_volumes": [{ "name": "dst_vol_1" }, { "name": "dst_vol_2" }] }, "create_destination": { "enabled": "true", "storage_service": { "enabled": "true", "name": "extreme", "enforce_performance": "true" } }, "policy": "AutomatedFailOver", "state": "in_sync" }'
	```
	<br/>

Provision the destination Application Consistency Group endpoint with storage service, create an asynchronous application consistency group relationship with a SnapMirror policy of type "async" and an async_type of "XDPDefault", and initialize the SnapMirror relationship with state as "SnapMirrored".

	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:/cg/cg_src_vol", "consistency_group_volumes": [{ "name": "src_vol_1" }, { "name": "src_vol_2" }] }, "destination": { "path": "dst_svm:/cg/cg_dst_vol", "consistency_group_volumes": [{ "name": "dst_vol_1" }, { "name": "dst_vol_2" }] }, "create_destination": { "enabled": "true", "storage_service": { "enabled": "true", "name": "extreme", "enforce_performance": "true" } }, "policy": "XDPDefault", "state": "snapmirrored" }'
	```
	<br/>
	Creating a FlexVol volume SnapMirror relationship of type XDP with transfer_schedule and throttle.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:src_vol"}, "destination": { "path": "dst_svm:dst_vol"}, "transfer_schedule":{"uuid":"817500fa-092d-44c5-9c10-7b54f7b2f20a", "name":"5min"}, "throttle":100}'
	```
	<br/>

	Creating an asynchronous SnapMirror relationship with backoff_level set to medium.
	<br/>
	```
	POST "/api/snapmirror/relationships/" '{"source": {"path": "src_svm:src_vol"}, "destination": { "path": "dst_svm:dst_vol"}, "backoff_level": "medium"}'
	```
	<br/>

### Learn more
* [`DOC /snapmirror/relationships`](#docs-snapmirror-snapmirror_relationships)
*/
func (a *Client) SnapmirrorRelationshipCreate(params *SnapmirrorRelationshipCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipCreateCreated, *SnapmirrorRelationshipCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_create",
		Method:             "POST",
		PathPattern:        "/snapmirror/relationships",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapmirrorRelationshipCreateCreated:
		return value, nil, nil
	case *SnapmirrorRelationshipCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorRelationshipDelete Deletes a SnapMirror relationship.

### Important notes
* The "destination_only", "source_only", and "source_info_only" flags are mutually exclusive. If no flag is specified, the relationship is deleted from both the source and destination and all common snapshots between the source and destination are also deleted.
* For a restore relationship, the call must be executed on the cluster containing the destination endpoint without specifying the destination_only, source_only, or source_info_only parameters.
* Additionally, ensure that there are no ongoing transfers on a restore relationship before calling this API.
* The "failover", "force-failover" and "failback" query parameters are only applicable for SVM-DR SnapMirror relationships.
* When a SnapMirror relationship associated with a pair of source and destination Consistency Groups is deleted, the corresponding Consistency Groups on the source and destination clusters are not automatically deleted and remain in place.
* The "delete_lun_maps_in_destination" query parameter is applicable only for SnapMirror active sync relationships.
* The "unmap_namespace" query parameter is applicable only for NVMe SnapMirror active sync relationships.
### Related ONTAP commands
* `snapmirror delete`
* `snapmirror release`
### Examples
The following examples show how to delete the relationship from both the source and destination, the destination only, and the source only.
<br/>

	Deleting the relationship from both the source and destination. This API must be run on the cluster containing the destination endpoint.
	<br/>
	```
	DELETE "/api/snapmirror/relationships/4512b2d2-fd60-11e8-8929-005056bbfe52"
	```
	<br/>
	Deleting the relationship on the destination only. This API must be run on the cluster containing the destination endpoint.
	<br/>
	```
	DELETE "/api/snapmirror/relationships/fd1e0697-02ba-11e9-acc7-005056a7697f/?destination_only=true"
	```
	<br/>
	Deleting the relationship on the source only. This API must be run on the cluster containing the source endpoint.
	<br/>
	```
	DELETE "/api/snapmirror/relationships/93e828ba-02bc-11e9-acc7-005056a7697f/?source_only=true"
	```
	<br/>
	Deleting the source information only. This API must be run on the cluster containing the source endpoint. This does not delete the common snapshots between the source and destination.
	<br/>
	```
	DELETE "/api/snapmirror/relationships/caf545a2-fc60-11e8-aa13-005056a707ff/?source_info_only=true"
	```
	<br/>
	Deleting the relationship from source and destination cluster along with deleting the LUN maps for the volumes of the CG in destination cluster. This API must be run on the cluster containing the destination endpoint.
	<br/>
	```
	DELETE "/api/snapmirror/relationships/feda8f5e-e29e-11ed-94aa-005056a78ce2/?delete_lun_maps_in_destination=true"
	```
	<br/>
	Deleting the relationship from destination cluster along with deleting the namespace maps for the volumes of the CG in destination cluster. This API must be run on the cluster containing the destination endpoint.
	<br/>
	```
	DELETE "/api/snapmirror/relationships/feda8f5e-e29e-11ed-94aa-005056a78ce2/?unmap_namespace=true"
	```
	<br/>

### Learn more
* [`DOC /snapmirror/relationships`](#docs-snapmirror-snapmirror_relationships)
*/
func (a *Client) SnapmirrorRelationshipDelete(params *SnapmirrorRelationshipDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipDeleteOK, *SnapmirrorRelationshipDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_delete",
		Method:             "DELETE",
		PathPattern:        "/snapmirror/relationships/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapmirrorRelationshipDeleteOK:
		return value, nil, nil
	case *SnapmirrorRelationshipDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapmirrorRelationshipDeleteCollection snapmirror relationship delete collection API
*/
func (a *Client) SnapmirrorRelationshipDeleteCollection(params *SnapmirrorRelationshipDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipDeleteCollectionOK, *SnapmirrorRelationshipDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/snapmirror/relationships",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapmirrorRelationshipDeleteCollectionOK:
		return value, nil, nil
	case *SnapmirrorRelationshipDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorRelationshipGet Retrieves a SnapMirror relationship.

### Related ONTAP commands
* `snapmirror show`
* `snapmirror list-destinations`
### Expensive properties

* `source.consistency_group_volumes.name`
* `destination.consistency_group_volumes.name`
### Example
<br/>
```
GET "/api/snapmirror/relationships/caf545a2-fc60-11e8-aa13-005056a707ff/"
```
<br/>
### Learn more
* [`DOC /snapmirror/relationships`](#docs-snapmirror-snapmirror_relationships)
*/
func (a *Client) SnapmirrorRelationshipGet(params *SnapmirrorRelationshipGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_get",
		Method:             "GET",
		PathPattern:        "/snapmirror/relationships/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapmirrorRelationshipGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorRelationshipModify Updates a SnapMirror relationship. This API is used to initiate SnapMirror operations such as "initialize", "resync", "break", "quiesce", and "resume" by specifying the appropriate value for the "state" field. It is also used to modify the SnapMirror policy associated with the specified relationship. Additionally, a SnapMirror relationship can be failed over to the destination endpoint or a failed over SnapMirror relationship can be failed back to the original state or a SnapMirror relationship direction can be reversed using this API. This API can also be used to expand the SnapMirror active sync relationship with the specified source and destination volumes.

<br>To initialize the relationship, PATCH the state to "snapmirrored" for relationships with a policy of type "async" or "in_sync" for relationships with a policy of type "sync".
<br>To break the relationship or to failover to the destination endpoint and start serving data from the destination endpoint, PATCH the state to "broken_off" for relationships with a policy of type "async" or "sync". SnapMirror relationships with the policy type as "sync" and sync_type as "automated_failover" cannot be "broken_off".
<br>To resync the broken relationship, PATCH the state to "snapmirrored" for relationships with a policy of type "async" or "in_sync" for relationships with a policy of type "sync".
<br>To failback the failed over relationship and start serving data from the source endpoint, PATCH the state to "snapmirrored" for relationships with a policy of type "async" or "in_sync" for relationships with a policy of type "sync" and set the query flag "failback" as "true". SnapMirror relationships with the policy type as "sync" and sync_type as "automated_failover" can be in "broken_off" state due to a failed attempt of automated SnapMirror failover operation.
<br>To pause the relationship, suspending further transfers, PATCH the state to "paused" for relationships with a policy of type "async" or "sync". SnapMirror relationships with the policy type as "sync" and sync_type as "automated_failover" cannot be "paused".
<br>To resume transfers for a paused relationship, PATCH the state to "snapmirrored" for relationships with a policy of type "async" or "in_sync" for relationships with a policy of type "sync".
<br>To reverse the direction of the relationship, PATCH the "source.path" with the destination endpoint and the "destination.path" with the source endpoint and the relationship state to "snapmirrored" for relationships with a policy of type "async" or "in_sync" for relationships with a policy of type "sync". For relationships with a policy of type "async" and relationship state as "snapmirrored", stop IO on the source endpoint and perform a SnapMirror transfer POST operation before reversing the direction of the relationship to prevent any loss of data.
<br>The values "in_sync", "out_of_sync", and "synchronizing" are only applicable to relationships with a policy of type "sync".
<br>When "transfer_schedule" is specified along with "state" during PATCH, first the schedule is modified on the relationship and then the respective SnapMirror operation is initiated. The "transfer_schedule" specified is used to update asynchronous relationships.
<br>When "throttle" is specified along with "state" during PATCH, first the throttle is modified on the relationship, which will be used by any upcoming transfers and then the respective SnapMirror operation is initiated. If the SnapMirror operation initiated a transfer then it will also use the new throttle. If "throttle" needs to be applied for a specific transfer use SnapMirror Transfer REST API.
<br>For SnapMirror active sync relationships, when "consistency_group_volumes" is specified during PATCH, first the existing FlexVol volume relationship is deleted and released and then the volumes are added to the SnapMirror active sync relationship.

### Examples
### Related ONTAP commands
* `snapmirror modify`
* `snapmirror initialize`
* `snapmirror resync`
* `snapmirror break`
* `snapmirror quiesce`
* `snapmirror resume`
### Important notes
* The property "transfer_schedule" if set on a SnapMirror relationship overrides the "transfer_schedule" set on the policy being used with the SnapMirror relationship.
* The property "throttle" if set on a SnapMirror relationship overrides the "throttle" set on the policy being used with the SnapMirror relationship.
* The properties "transfer_schedule" and "throttle" are not supported when "failback" is set to "true".
* The properties "transfer_schedule" and "throttle" are not supported when "failover" is set to "true".
* The properties "transfer_schedule" and "throttle" are not supported when "force_failover" is set to "true".
* The properties "transfer_schedule" and "throttle" are not supported when the direction of the relationship is being reversed.
* To remove a transfer_schedule on a SnapMirror relationship set the "transfer_schedule" to null (no-quotes) during SnapMirror relationship PATCH.
* The property "identity_preservation" value can be changed from a higher "identity_preservation" threshold value to a lower "identity_preservation" threshold value but not vice-versa. For example, the threshold value of the "identity_preservation" property can be changed from "full" to "exclude_network_config", but cannot be increased from "exclude_network_and_protocol_config" to "exclude_network_config" to "full". The threshold value of the "identity_preservation" cannot be changed to "exclude_network_and_protocol_config" for IDP SVMDR.

* The property "backoff_level" is only applicable for FlexVol SnapMirror relationships.
### Examples
The following examples show how to perform the SnapMirror "resync", "initialize", "resume", "quiesce", and "break" operations. In addition, a relationship can be failed over to the destination endpoint and start serving data from the destination endpoint. A failed over relationship can be failed back to the source endpoint and serve data from the source endpoint. Also a relationship can be reversed by making the source endpoint as the new destination endpoint and the destination endpoint as the new source endpoint.
<br/>

	To update an associated SnapMirror policy.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"policy": { "name" : "MirrorAndVaultDiscardNetwork"}}'
	```
	<br/>
	To perform SnapMirror "resync" for an asynchronous SnapMirror relationship.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"state":"snapmirrored"}'
	```
	<br/>
	To perform SnapMirror "initialize" for an asynchronous SnapMirror relationship.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"state":"snapmirrored"}'
	```
	<br/>
	To perform SnapMirror "resume" for an asynchronous SnapMirror relationship.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"state":"snapmirrored"}'
	```
	<br/>
	To perform SnapMirror "quiesce" for an asynchronous SnapMirror relationship.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff" '{"state":"paused"}'
	```
	<br/>
	To perform SnapMirror "break" for an asynchronous SnapMirror relationship. This operation does a failover to the destination endpoint. After a the failover, data can then be served from the destination endpoint.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff" '{"state":"broken_off"}'
	```
	<br/>
	To forcefully failover to the destination endpoint and start serving data from the destination endpoint.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/?force=true" '{"state":"broken_off"}'
	```
	<br/>
	To failback to the source endpoint and start serving data from the source endpoint for an asynchronous relationship.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/?failback=true" '{"state":"snapmirrored"}'
	```
	<br/>
	To failback to the source endpoint and start serving data from the source endpoint for a synchronous relationship.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/?failback=true" '{"state":"in_sync"}'
	```
	<br/>
	To reverse the direction of an asynchronous relationship, that is, make the source endpoint as the new destination endpoint and make the destination endpoint as the new source endpoint.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"source": {"path": "dst_svm:dst_vol"}, "destination": {"path": "src_svm:src_vol"}, "state": "snapmirrored"}'
	```
	<br/>
	To reverse the direction of a synchronous relationship, that is, make the source endpoint as the new destination endpoint and make the destination endpoint as the new source endpoint.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"source": {"path": "dst_svm:dst_vol"}, "destination": {"path": "src_svm:src_vol"}, "state": "in_sync"}'
	```
	<br/>
	Updating SnapMirror transfer_schedule and throttle for an asynchronous SnapMirror relationship. Transfer_schedule can be specified as UUID or name or both.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"transfer_schedule":{"uuid":"817500fa-092d-44c5-9c10-7b54f7b2f20a", "name":"5min"}, "throttle":100}'
	```
	<br/>
	Removing the SnapMirror transfer_schedule for an asynchronous SnapMirror relationship.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"transfer_schedule":{"uuid":null, "name":null}}'
	```
	<br/>
	Removing the SnapMirror throttle for an asynchronous SnapMirror relationship.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"throttle":0}'
	```
	<br/>
	To perform SnapMirror "resync" and update the SnapMirror transfer_schedule for an asynchronous SnapMirror relationship. First the transfer_schedule is modified and then the resync transfer is initiated.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"state":"snapmirrored", transfer_schedule":{"uuid":"817500fa-092d-44c5-9c10-7b54f7b2f20a", "name":"5min"}}'
	```
	<br/>
	To perform SnapMirror "initialize" and update the SnapMirror throttle for an asynchronous SnapMirror relationship. First the throttle is modified and then the initialize transfer is initiated. The initialize transfer will use this new throttle.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"state":"snapmirrored", "throttle":100}'
	```
	<br/>
	To perform SnapMirror "resync" and update the SnapMirror throttle for an asynchronous SnapMirror relationship. First the throttle is modified and then the resync transfer is initiated. The resync transfer will use this new throttle.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"state":"snapmirrored", "throttle":100}'
	```
	<br/>
	To perform a SnapMirror active sync or Asynchronous Consistency Group expansion.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{ "source" : {"consistency_group_volumes":[{"name":"vol"}]}, "destination" : {"consistency_group_volumes":[{"name":"voldp"}]} }'
	```
	<br/>
	Updating SnapMirror backoff_level for an asynchronous SnapMirror relationship.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"backoff_level": "none"}'
	```
	<br/>
	To perform SnapMirror "initialize" and update the SnapMirror backoff_level for an asynchronous SnapMirror relationship. First the backoff_level is modified and then the initialize transfer is initiated. The initialize transfer will use this new backoff_level.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"state":"snapmirrored", "backoff_level": "medium"}'
	```
	<br/>
	To perform SnapMirror "resync" and update the SnapMirror backoff_level for an asynchronous SnapMirror relationship. First the backoff_level is modified and then the resync transfer is initiated. The resync transfer will use this new backoff_level.
	<br/>
	```
	PATCH "/api/snapmirror/relationships/98bb2608-fc60-11e8-aa13-005056a707ff/" '{"state":"snapmirrored", "backoff_level": "medium"}'
	```

### Learn more
* [`DOC /snapmirror/relationships`](#docs-snapmirror-snapmirror_relationships)
*/
func (a *Client) SnapmirrorRelationshipModify(params *SnapmirrorRelationshipModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipModifyOK, *SnapmirrorRelationshipModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_modify",
		Method:             "PATCH",
		PathPattern:        "/snapmirror/relationships/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapmirrorRelationshipModifyOK:
		return value, nil, nil
	case *SnapmirrorRelationshipModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapmirrorRelationshipModifyCollection snapmirror relationship modify collection API
*/
func (a *Client) SnapmirrorRelationshipModifyCollection(params *SnapmirrorRelationshipModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipModifyCollectionOK, *SnapmirrorRelationshipModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/snapmirror/relationships",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SnapmirrorRelationshipModifyCollectionOK:
		return value, nil, nil
	case *SnapmirrorRelationshipModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorRelationshipTransferCreate Starts a SnapMirror transfer operation. This API initiates a restore operation if the SnapMirror relationship is of type "restore". Otherwise, it initiates a SnapMirror "initialize" operation or "update" operation based on the current SnapMirror state.

### Default property values
* `storage_efficiency_enabled` - _true_
### Related ONTAP commands
* `snapmirror update`
* `snapmirror initialize`
* `snapmirror restore`

### Examples
The following examples show how to perform SnapMirror "initialize", "update", and "restore" operations.
<br/>

	Perform SnapMirror initialize or update
	<br/>
	```
	POST "/api/snapmirror/relationships/e4e7e130-0279-11e9-b566-0050568e9909/transfers" '{}'
	```
	<br/>
	Perform SnapMirror initialize, update or restore with throttle value set
	<br/>
	```
	POST "/api/snapmirror/relationships/e4e7e130-0279-11e9-b566-0050568e9909/transfers" '{"throttle":"100"}'
	```
	<br/>
	Perform SnapMirror restore transfer of a file
	<br/>
	```
	POST "/api/snapmirror/relationships/c8c62a90-0fef-11e9-b09e-0050568e7067/transfers" '{"source_snapshot": "src", "files":[{"source_path": "/a1.txt.0", "destination_path": "/a1-renamed.txt.0"}]}'
	```
	<br/>
	Performing a SnapMirror initialize or update using a particular snapshot.
	<br/>
	```
	POST "/api/snapmirror/relationships/e4e7e130-0279-11e9-b566-0050568e9909/transfers" '{"source_snapshot":"snap1"}'
	```
	<br/>

### Learn more
* [`DOC /snapmirror/relationships/{relationship.uuid}/transfers`](#docs-snapmirror-snapmirror_relationships_{relationship.uuid}_transfers)
*/
func (a *Client) SnapmirrorRelationshipTransferCreate(params *SnapmirrorRelationshipTransferCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipTransferCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipTransferCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_transfer_create",
		Method:             "POST",
		PathPattern:        "/snapmirror/relationships/{relationship.uuid}/transfers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipTransferCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapmirrorRelationshipTransferCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipTransferCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorRelationshipTransferGet Retrieves the attributes of a specific ongoing SnapMirror transfer.

### Related ONTAP commands
* `snapmirror show`
### Example
<br/>
```
GET "/api/snapmirror/relationships/293baa53-e63d-11e8-bff1-005056a793dd/transfers/293baa53-e63d-11e8-bff1-005056a793dd"
```
<br/>
### Learn more
* [`DOC /snapmirror/relationships/{relationship.uuid}/transfers`](#docs-snapmirror-snapmirror_relationships_{relationship.uuid}_transfers)
*/
func (a *Client) SnapmirrorRelationshipTransferGet(params *SnapmirrorRelationshipTransferGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipTransferGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipTransferGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_transfer_get",
		Method:             "GET",
		PathPattern:        "/snapmirror/relationships/{relationship.uuid}/transfers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipTransferGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapmirrorRelationshipTransferGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipTransferGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorRelationshipTransferModify Aborts an ongoing SnapMirror transfer. This operation is applicable on asynchronous SnapMirror relationships.

### Related ONTAP commands
* `snapmirror abort`
### Example
<br/>
```
PATCH "/api/snapmirror/relationships/293baa53-e63d-11e8-bff1-005056a793dd/transfers/293baa53-e63d-11e8-bff1-005056a793dd" '{"state":"aborted"}'
```
<br/>
### Learn more
* [`DOC /snapmirror/relationships/{relationship.uuid}/transfers`](#docs-snapmirror-snapmirror_relationships_{relationship.uuid}_transfers)
*/
func (a *Client) SnapmirrorRelationshipTransferModify(params *SnapmirrorRelationshipTransferModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipTransferModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipTransferModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_transfer_modify",
		Method:             "PATCH",
		PathPattern:        "/snapmirror/relationships/{relationship.uuid}/transfers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipTransferModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapmirrorRelationshipTransferModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipTransferModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnapmirrorRelationshipTransferModifyCollection snapmirror relationship transfer modify collection API
*/
func (a *Client) SnapmirrorRelationshipTransferModifyCollection(params *SnapmirrorRelationshipTransferModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipTransferModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipTransferModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_transfer_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/snapmirror/relationships/{relationship.uuid}/transfers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipTransferModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapmirrorRelationshipTransferModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipTransferModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorRelationshipTransfersGet Retrieves the list of ongoing SnapMirror transfers for the specified relationship.

### Related ONTAP commands
* `snapmirror show`
### Example
<br/>
```
GET "/api/snapmirror/relationships/293baa53-e63d-11e8-bff1-005056a793dd/transfers"
```
### Learn more
* [`DOC /snapmirror/relationships/{relationship.uuid}/transfers`](#docs-snapmirror-snapmirror_relationships_{relationship.uuid}_transfers)
<br/>
*/
func (a *Client) SnapmirrorRelationshipTransfersGet(params *SnapmirrorRelationshipTransfersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipTransfersGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipTransfersGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationship_transfers_get",
		Method:             "GET",
		PathPattern:        "/snapmirror/relationships/{relationship.uuid}/transfers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipTransfersGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapmirrorRelationshipTransfersGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipTransfersGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnapmirrorRelationshipsGet Retrieves information for SnapMirror relationships whose destination endpoints are in the current SVM or the current cluster, depending on the cluster context.

### Related ONTAP commands
* `snapmirror show`
* `snapmirror list-destinations`
### Expensive properties

* `source.consistency_group_volumes.name`
* `destination.consistency_group_volumes.name`
* `svmdr_volumes.name`
### Examples
The following examples show how to retrieve the list of SnapMirror relationships and the list of SnapMirror destinations.

 1. Retrieving the list of SnapMirror relationships. This API must be run on the cluster containing the destination endpoint.
    <br/>
    ```
    GET "/api/snapmirror/relationships/"
    ```
    <br/>

 2. Retrieving the list of SnapMirror destinations on source. This must be run on the cluster containing the source endpoint.
    <br/>
    ```
    GET "/api/snapmirror/relationships/?list_destinations_only=true"
    ```
    <br/>

 3. Retrieving the relationship UUID of SnapMirror relationships with lag time greater than 2 days. This API must be run on the cluster containing the destination endpoint.
    <br/>
    ```
    GET "/api/snapmirror/relationships/?fields=uuid&lag_time=>P2DT"
    ```
    <br/>

 4. Retrieving the list of SnapMirror relationships with lag time less than 10 hours. This API must be run on the cluster containing the destination endpoint.
    <br/>
    ```
    GET "/api/snapmirror/relationships/?lag_time=<PT10H"
    ```
    <br/>

 6. Retrieving the list of constituent volumes for SVM DR Snapmirror relationships.
    <br/>
    ```
    GET "/api/snapmirror/relationships/?fields=svmdr_volumes.name"
    ```
    <br/>
    </private>

### Learn more
* [`DOC /snapmirror/relationships`](#docs-snapmirror-snapmirror_relationships)
*/
func (a *Client) SnapmirrorRelationshipsGet(params *SnapmirrorRelationshipsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnapmirrorRelationshipsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnapmirrorRelationshipsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snapmirror_relationships_get",
		Method:             "GET",
		PathPattern:        "/snapmirror/relationships",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnapmirrorRelationshipsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnapmirrorRelationshipsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnapmirrorRelationshipsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
