// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnapmirrorPoliciesGetParams creates a new SnapmirrorPoliciesGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapmirrorPoliciesGetParams() *SnapmirrorPoliciesGetParams {
	return &SnapmirrorPoliciesGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapmirrorPoliciesGetParamsWithTimeout creates a new SnapmirrorPoliciesGetParams object
// with the ability to set a timeout on a request.
func NewSnapmirrorPoliciesGetParamsWithTimeout(timeout time.Duration) *SnapmirrorPoliciesGetParams {
	return &SnapmirrorPoliciesGetParams{
		timeout: timeout,
	}
}

// NewSnapmirrorPoliciesGetParamsWithContext creates a new SnapmirrorPoliciesGetParams object
// with the ability to set a context for a request.
func NewSnapmirrorPoliciesGetParamsWithContext(ctx context.Context) *SnapmirrorPoliciesGetParams {
	return &SnapmirrorPoliciesGetParams{
		Context: ctx,
	}
}

// NewSnapmirrorPoliciesGetParamsWithHTTPClient creates a new SnapmirrorPoliciesGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapmirrorPoliciesGetParamsWithHTTPClient(client *http.Client) *SnapmirrorPoliciesGetParams {
	return &SnapmirrorPoliciesGetParams{
		HTTPClient: client,
	}
}

/*
SnapmirrorPoliciesGetParams contains all the parameters to send to the API endpoint

	for the snapmirror policies get operation.

	Typically these are written to a http.Request.
*/
type SnapmirrorPoliciesGetParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* CopyAllSourceSnapshots.

	   Filter by copy_all_source_snapshots
	*/
	CopyAllSourceSnapshots *bool

	/* CopyLatestSourceSnapshot.

	   Filter by copy_latest_source_snapshot
	*/
	CopyLatestSourceSnapshot *bool

	/* CreateSnapshotOnSource.

	   Filter by create_snapshot_on_source
	*/
	CreateSnapshotOnSource *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IdentityPreservation.

	   Filter by identity_preservation
	*/
	IdentityPreservation *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NetworkCompressionEnabled.

	   Filter by network_compression_enabled
	*/
	NetworkCompressionEnabled *bool

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* RetentionCount.

	   Filter by retention.count
	*/
	RetentionCount *int64

	/* RetentionCreationScheduleName.

	   Filter by retention.creation_schedule.name
	*/
	RetentionCreationScheduleName *string

	/* RetentionCreationScheduleUUID.

	   Filter by retention.creation_schedule.uuid
	*/
	RetentionCreationScheduleUUID *string

	/* RetentionLabel.

	   Filter by retention.label
	*/
	RetentionLabel *string

	/* RetentionPeriod.

	   Filter by retention.period
	*/
	RetentionPeriod *string

	/* RetentionPrefix.

	   Filter by retention.prefix
	*/
	RetentionPrefix *string

	/* RetentionPreserve.

	   Filter by retention.preserve
	*/
	RetentionPreserve *bool

	/* RetentionWarn.

	   Filter by retention.warn
	*/
	RetentionWarn *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Rpo.

	   Filter by rpo
	*/
	Rpo *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* SyncCommonSnapshotScheduleName.

	   Filter by sync_common_snapshot_schedule.name
	*/
	SyncCommonSnapshotScheduleName *string

	/* SyncCommonSnapshotScheduleUUID.

	   Filter by sync_common_snapshot_schedule.uuid
	*/
	SyncCommonSnapshotScheduleUUID *string

	/* SyncType.

	   Filter by sync_type
	*/
	SyncType *string

	/* Throttle.

	   Filter by throttle
	*/
	Throttle *int64

	/* TransferScheduleName.

	   Filter by transfer_schedule.name
	*/
	TransferScheduleName *string

	/* TransferScheduleUUID.

	   Filter by transfer_schedule.uuid
	*/
	TransferScheduleUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapmirror policies get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorPoliciesGetParams) WithDefaults() *SnapmirrorPoliciesGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapmirror policies get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorPoliciesGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SnapmirrorPoliciesGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithTimeout(timeout time.Duration) *SnapmirrorPoliciesGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithContext(ctx context.Context) *SnapmirrorPoliciesGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithHTTPClient(client *http.Client) *SnapmirrorPoliciesGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithComment(comment *string) *SnapmirrorPoliciesGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithCopyAllSourceSnapshots adds the copyAllSourceSnapshots to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithCopyAllSourceSnapshots(copyAllSourceSnapshots *bool) *SnapmirrorPoliciesGetParams {
	o.SetCopyAllSourceSnapshots(copyAllSourceSnapshots)
	return o
}

// SetCopyAllSourceSnapshots adds the copyAllSourceSnapshots to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetCopyAllSourceSnapshots(copyAllSourceSnapshots *bool) {
	o.CopyAllSourceSnapshots = copyAllSourceSnapshots
}

// WithCopyLatestSourceSnapshot adds the copyLatestSourceSnapshot to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithCopyLatestSourceSnapshot(copyLatestSourceSnapshot *bool) *SnapmirrorPoliciesGetParams {
	o.SetCopyLatestSourceSnapshot(copyLatestSourceSnapshot)
	return o
}

// SetCopyLatestSourceSnapshot adds the copyLatestSourceSnapshot to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetCopyLatestSourceSnapshot(copyLatestSourceSnapshot *bool) {
	o.CopyLatestSourceSnapshot = copyLatestSourceSnapshot
}

// WithCreateSnapshotOnSource adds the createSnapshotOnSource to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithCreateSnapshotOnSource(createSnapshotOnSource *bool) *SnapmirrorPoliciesGetParams {
	o.SetCreateSnapshotOnSource(createSnapshotOnSource)
	return o
}

// SetCreateSnapshotOnSource adds the createSnapshotOnSource to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetCreateSnapshotOnSource(createSnapshotOnSource *bool) {
	o.CreateSnapshotOnSource = createSnapshotOnSource
}

// WithFields adds the fields to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithFields(fields []string) *SnapmirrorPoliciesGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIdentityPreservation adds the identityPreservation to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithIdentityPreservation(identityPreservation *string) *SnapmirrorPoliciesGetParams {
	o.SetIdentityPreservation(identityPreservation)
	return o
}

// SetIdentityPreservation adds the identityPreservation to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetIdentityPreservation(identityPreservation *string) {
	o.IdentityPreservation = identityPreservation
}

// WithMaxRecords adds the maxRecords to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithMaxRecords(maxRecords *int64) *SnapmirrorPoliciesGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithName(name *string) *SnapmirrorPoliciesGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetName(name *string) {
	o.Name = name
}

// WithNetworkCompressionEnabled adds the networkCompressionEnabled to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithNetworkCompressionEnabled(networkCompressionEnabled *bool) *SnapmirrorPoliciesGetParams {
	o.SetNetworkCompressionEnabled(networkCompressionEnabled)
	return o
}

// SetNetworkCompressionEnabled adds the networkCompressionEnabled to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetNetworkCompressionEnabled(networkCompressionEnabled *bool) {
	o.NetworkCompressionEnabled = networkCompressionEnabled
}

// WithOrderBy adds the orderBy to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithOrderBy(orderBy []string) *SnapmirrorPoliciesGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithRetentionCount adds the retentionCount to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithRetentionCount(retentionCount *int64) *SnapmirrorPoliciesGetParams {
	o.SetRetentionCount(retentionCount)
	return o
}

// SetRetentionCount adds the retentionCount to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetRetentionCount(retentionCount *int64) {
	o.RetentionCount = retentionCount
}

// WithRetentionCreationScheduleName adds the retentionCreationScheduleName to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithRetentionCreationScheduleName(retentionCreationScheduleName *string) *SnapmirrorPoliciesGetParams {
	o.SetRetentionCreationScheduleName(retentionCreationScheduleName)
	return o
}

// SetRetentionCreationScheduleName adds the retentionCreationScheduleName to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetRetentionCreationScheduleName(retentionCreationScheduleName *string) {
	o.RetentionCreationScheduleName = retentionCreationScheduleName
}

// WithRetentionCreationScheduleUUID adds the retentionCreationScheduleUUID to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithRetentionCreationScheduleUUID(retentionCreationScheduleUUID *string) *SnapmirrorPoliciesGetParams {
	o.SetRetentionCreationScheduleUUID(retentionCreationScheduleUUID)
	return o
}

// SetRetentionCreationScheduleUUID adds the retentionCreationScheduleUuid to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetRetentionCreationScheduleUUID(retentionCreationScheduleUUID *string) {
	o.RetentionCreationScheduleUUID = retentionCreationScheduleUUID
}

// WithRetentionLabel adds the retentionLabel to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithRetentionLabel(retentionLabel *string) *SnapmirrorPoliciesGetParams {
	o.SetRetentionLabel(retentionLabel)
	return o
}

// SetRetentionLabel adds the retentionLabel to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetRetentionLabel(retentionLabel *string) {
	o.RetentionLabel = retentionLabel
}

// WithRetentionPeriod adds the retentionPeriod to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithRetentionPeriod(retentionPeriod *string) *SnapmirrorPoliciesGetParams {
	o.SetRetentionPeriod(retentionPeriod)
	return o
}

// SetRetentionPeriod adds the retentionPeriod to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetRetentionPeriod(retentionPeriod *string) {
	o.RetentionPeriod = retentionPeriod
}

// WithRetentionPrefix adds the retentionPrefix to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithRetentionPrefix(retentionPrefix *string) *SnapmirrorPoliciesGetParams {
	o.SetRetentionPrefix(retentionPrefix)
	return o
}

// SetRetentionPrefix adds the retentionPrefix to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetRetentionPrefix(retentionPrefix *string) {
	o.RetentionPrefix = retentionPrefix
}

// WithRetentionPreserve adds the retentionPreserve to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithRetentionPreserve(retentionPreserve *bool) *SnapmirrorPoliciesGetParams {
	o.SetRetentionPreserve(retentionPreserve)
	return o
}

// SetRetentionPreserve adds the retentionPreserve to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetRetentionPreserve(retentionPreserve *bool) {
	o.RetentionPreserve = retentionPreserve
}

// WithRetentionWarn adds the retentionWarn to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithRetentionWarn(retentionWarn *int64) *SnapmirrorPoliciesGetParams {
	o.SetRetentionWarn(retentionWarn)
	return o
}

// SetRetentionWarn adds the retentionWarn to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetRetentionWarn(retentionWarn *int64) {
	o.RetentionWarn = retentionWarn
}

// WithReturnRecords adds the returnRecords to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithReturnRecords(returnRecords *bool) *SnapmirrorPoliciesGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithReturnTimeout(returnTimeout *int64) *SnapmirrorPoliciesGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRpo adds the rpo to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithRpo(rpo *int64) *SnapmirrorPoliciesGetParams {
	o.SetRpo(rpo)
	return o
}

// SetRpo adds the rpo to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetRpo(rpo *int64) {
	o.Rpo = rpo
}

// WithScope adds the scope to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithScope(scope *string) *SnapmirrorPoliciesGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSvmName adds the svmName to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithSvmName(svmName *string) *SnapmirrorPoliciesGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithSvmUUID(svmUUID *string) *SnapmirrorPoliciesGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithSyncCommonSnapshotScheduleName adds the syncCommonSnapshotScheduleName to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithSyncCommonSnapshotScheduleName(syncCommonSnapshotScheduleName *string) *SnapmirrorPoliciesGetParams {
	o.SetSyncCommonSnapshotScheduleName(syncCommonSnapshotScheduleName)
	return o
}

// SetSyncCommonSnapshotScheduleName adds the syncCommonSnapshotScheduleName to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetSyncCommonSnapshotScheduleName(syncCommonSnapshotScheduleName *string) {
	o.SyncCommonSnapshotScheduleName = syncCommonSnapshotScheduleName
}

// WithSyncCommonSnapshotScheduleUUID adds the syncCommonSnapshotScheduleUUID to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithSyncCommonSnapshotScheduleUUID(syncCommonSnapshotScheduleUUID *string) *SnapmirrorPoliciesGetParams {
	o.SetSyncCommonSnapshotScheduleUUID(syncCommonSnapshotScheduleUUID)
	return o
}

// SetSyncCommonSnapshotScheduleUUID adds the syncCommonSnapshotScheduleUuid to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetSyncCommonSnapshotScheduleUUID(syncCommonSnapshotScheduleUUID *string) {
	o.SyncCommonSnapshotScheduleUUID = syncCommonSnapshotScheduleUUID
}

// WithSyncType adds the syncType to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithSyncType(syncType *string) *SnapmirrorPoliciesGetParams {
	o.SetSyncType(syncType)
	return o
}

// SetSyncType adds the syncType to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetSyncType(syncType *string) {
	o.SyncType = syncType
}

// WithThrottle adds the throttle to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithThrottle(throttle *int64) *SnapmirrorPoliciesGetParams {
	o.SetThrottle(throttle)
	return o
}

// SetThrottle adds the throttle to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetThrottle(throttle *int64) {
	o.Throttle = throttle
}

// WithTransferScheduleName adds the transferScheduleName to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithTransferScheduleName(transferScheduleName *string) *SnapmirrorPoliciesGetParams {
	o.SetTransferScheduleName(transferScheduleName)
	return o
}

// SetTransferScheduleName adds the transferScheduleName to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetTransferScheduleName(transferScheduleName *string) {
	o.TransferScheduleName = transferScheduleName
}

// WithTransferScheduleUUID adds the transferScheduleUUID to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithTransferScheduleUUID(transferScheduleUUID *string) *SnapmirrorPoliciesGetParams {
	o.SetTransferScheduleUUID(transferScheduleUUID)
	return o
}

// SetTransferScheduleUUID adds the transferScheduleUuid to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetTransferScheduleUUID(transferScheduleUUID *string) {
	o.TransferScheduleUUID = transferScheduleUUID
}

// WithType adds the typeVar to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithType(typeVar *string) *SnapmirrorPoliciesGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) WithUUID(uuid *string) *SnapmirrorPoliciesGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the snapmirror policies get params
func (o *SnapmirrorPoliciesGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SnapmirrorPoliciesGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.CopyAllSourceSnapshots != nil {

		// query param copy_all_source_snapshots
		var qrCopyAllSourceSnapshots bool

		if o.CopyAllSourceSnapshots != nil {
			qrCopyAllSourceSnapshots = *o.CopyAllSourceSnapshots
		}
		qCopyAllSourceSnapshots := swag.FormatBool(qrCopyAllSourceSnapshots)
		if qCopyAllSourceSnapshots != "" {

			if err := r.SetQueryParam("copy_all_source_snapshots", qCopyAllSourceSnapshots); err != nil {
				return err
			}
		}
	}

	if o.CopyLatestSourceSnapshot != nil {

		// query param copy_latest_source_snapshot
		var qrCopyLatestSourceSnapshot bool

		if o.CopyLatestSourceSnapshot != nil {
			qrCopyLatestSourceSnapshot = *o.CopyLatestSourceSnapshot
		}
		qCopyLatestSourceSnapshot := swag.FormatBool(qrCopyLatestSourceSnapshot)
		if qCopyLatestSourceSnapshot != "" {

			if err := r.SetQueryParam("copy_latest_source_snapshot", qCopyLatestSourceSnapshot); err != nil {
				return err
			}
		}
	}

	if o.CreateSnapshotOnSource != nil {

		// query param create_snapshot_on_source
		var qrCreateSnapshotOnSource bool

		if o.CreateSnapshotOnSource != nil {
			qrCreateSnapshotOnSource = *o.CreateSnapshotOnSource
		}
		qCreateSnapshotOnSource := swag.FormatBool(qrCreateSnapshotOnSource)
		if qCreateSnapshotOnSource != "" {

			if err := r.SetQueryParam("create_snapshot_on_source", qCreateSnapshotOnSource); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IdentityPreservation != nil {

		// query param identity_preservation
		var qrIdentityPreservation string

		if o.IdentityPreservation != nil {
			qrIdentityPreservation = *o.IdentityPreservation
		}
		qIdentityPreservation := qrIdentityPreservation
		if qIdentityPreservation != "" {

			if err := r.SetQueryParam("identity_preservation", qIdentityPreservation); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NetworkCompressionEnabled != nil {

		// query param network_compression_enabled
		var qrNetworkCompressionEnabled bool

		if o.NetworkCompressionEnabled != nil {
			qrNetworkCompressionEnabled = *o.NetworkCompressionEnabled
		}
		qNetworkCompressionEnabled := swag.FormatBool(qrNetworkCompressionEnabled)
		if qNetworkCompressionEnabled != "" {

			if err := r.SetQueryParam("network_compression_enabled", qNetworkCompressionEnabled); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.RetentionCount != nil {

		// query param retention.count
		var qrRetentionCount int64

		if o.RetentionCount != nil {
			qrRetentionCount = *o.RetentionCount
		}
		qRetentionCount := swag.FormatInt64(qrRetentionCount)
		if qRetentionCount != "" {

			if err := r.SetQueryParam("retention.count", qRetentionCount); err != nil {
				return err
			}
		}
	}

	if o.RetentionCreationScheduleName != nil {

		// query param retention.creation_schedule.name
		var qrRetentionCreationScheduleName string

		if o.RetentionCreationScheduleName != nil {
			qrRetentionCreationScheduleName = *o.RetentionCreationScheduleName
		}
		qRetentionCreationScheduleName := qrRetentionCreationScheduleName
		if qRetentionCreationScheduleName != "" {

			if err := r.SetQueryParam("retention.creation_schedule.name", qRetentionCreationScheduleName); err != nil {
				return err
			}
		}
	}

	if o.RetentionCreationScheduleUUID != nil {

		// query param retention.creation_schedule.uuid
		var qrRetentionCreationScheduleUUID string

		if o.RetentionCreationScheduleUUID != nil {
			qrRetentionCreationScheduleUUID = *o.RetentionCreationScheduleUUID
		}
		qRetentionCreationScheduleUUID := qrRetentionCreationScheduleUUID
		if qRetentionCreationScheduleUUID != "" {

			if err := r.SetQueryParam("retention.creation_schedule.uuid", qRetentionCreationScheduleUUID); err != nil {
				return err
			}
		}
	}

	if o.RetentionLabel != nil {

		// query param retention.label
		var qrRetentionLabel string

		if o.RetentionLabel != nil {
			qrRetentionLabel = *o.RetentionLabel
		}
		qRetentionLabel := qrRetentionLabel
		if qRetentionLabel != "" {

			if err := r.SetQueryParam("retention.label", qRetentionLabel); err != nil {
				return err
			}
		}
	}

	if o.RetentionPeriod != nil {

		// query param retention.period
		var qrRetentionPeriod string

		if o.RetentionPeriod != nil {
			qrRetentionPeriod = *o.RetentionPeriod
		}
		qRetentionPeriod := qrRetentionPeriod
		if qRetentionPeriod != "" {

			if err := r.SetQueryParam("retention.period", qRetentionPeriod); err != nil {
				return err
			}
		}
	}

	if o.RetentionPrefix != nil {

		// query param retention.prefix
		var qrRetentionPrefix string

		if o.RetentionPrefix != nil {
			qrRetentionPrefix = *o.RetentionPrefix
		}
		qRetentionPrefix := qrRetentionPrefix
		if qRetentionPrefix != "" {

			if err := r.SetQueryParam("retention.prefix", qRetentionPrefix); err != nil {
				return err
			}
		}
	}

	if o.RetentionPreserve != nil {

		// query param retention.preserve
		var qrRetentionPreserve bool

		if o.RetentionPreserve != nil {
			qrRetentionPreserve = *o.RetentionPreserve
		}
		qRetentionPreserve := swag.FormatBool(qrRetentionPreserve)
		if qRetentionPreserve != "" {

			if err := r.SetQueryParam("retention.preserve", qRetentionPreserve); err != nil {
				return err
			}
		}
	}

	if o.RetentionWarn != nil {

		// query param retention.warn
		var qrRetentionWarn int64

		if o.RetentionWarn != nil {
			qrRetentionWarn = *o.RetentionWarn
		}
		qRetentionWarn := swag.FormatInt64(qrRetentionWarn)
		if qRetentionWarn != "" {

			if err := r.SetQueryParam("retention.warn", qRetentionWarn); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Rpo != nil {

		// query param rpo
		var qrRpo int64

		if o.Rpo != nil {
			qrRpo = *o.Rpo
		}
		qRpo := swag.FormatInt64(qrRpo)
		if qRpo != "" {

			if err := r.SetQueryParam("rpo", qRpo); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.SyncCommonSnapshotScheduleName != nil {

		// query param sync_common_snapshot_schedule.name
		var qrSyncCommonSnapshotScheduleName string

		if o.SyncCommonSnapshotScheduleName != nil {
			qrSyncCommonSnapshotScheduleName = *o.SyncCommonSnapshotScheduleName
		}
		qSyncCommonSnapshotScheduleName := qrSyncCommonSnapshotScheduleName
		if qSyncCommonSnapshotScheduleName != "" {

			if err := r.SetQueryParam("sync_common_snapshot_schedule.name", qSyncCommonSnapshotScheduleName); err != nil {
				return err
			}
		}
	}

	if o.SyncCommonSnapshotScheduleUUID != nil {

		// query param sync_common_snapshot_schedule.uuid
		var qrSyncCommonSnapshotScheduleUUID string

		if o.SyncCommonSnapshotScheduleUUID != nil {
			qrSyncCommonSnapshotScheduleUUID = *o.SyncCommonSnapshotScheduleUUID
		}
		qSyncCommonSnapshotScheduleUUID := qrSyncCommonSnapshotScheduleUUID
		if qSyncCommonSnapshotScheduleUUID != "" {

			if err := r.SetQueryParam("sync_common_snapshot_schedule.uuid", qSyncCommonSnapshotScheduleUUID); err != nil {
				return err
			}
		}
	}

	if o.SyncType != nil {

		// query param sync_type
		var qrSyncType string

		if o.SyncType != nil {
			qrSyncType = *o.SyncType
		}
		qSyncType := qrSyncType
		if qSyncType != "" {

			if err := r.SetQueryParam("sync_type", qSyncType); err != nil {
				return err
			}
		}
	}

	if o.Throttle != nil {

		// query param throttle
		var qrThrottle int64

		if o.Throttle != nil {
			qrThrottle = *o.Throttle
		}
		qThrottle := swag.FormatInt64(qrThrottle)
		if qThrottle != "" {

			if err := r.SetQueryParam("throttle", qThrottle); err != nil {
				return err
			}
		}
	}

	if o.TransferScheduleName != nil {

		// query param transfer_schedule.name
		var qrTransferScheduleName string

		if o.TransferScheduleName != nil {
			qrTransferScheduleName = *o.TransferScheduleName
		}
		qTransferScheduleName := qrTransferScheduleName
		if qTransferScheduleName != "" {

			if err := r.SetQueryParam("transfer_schedule.name", qTransferScheduleName); err != nil {
				return err
			}
		}
	}

	if o.TransferScheduleUUID != nil {

		// query param transfer_schedule.uuid
		var qrTransferScheduleUUID string

		if o.TransferScheduleUUID != nil {
			qrTransferScheduleUUID = *o.TransferScheduleUUID
		}
		qTransferScheduleUUID := qrTransferScheduleUUID
		if qTransferScheduleUUID != "" {

			if err := r.SetQueryParam("transfer_schedule.uuid", qTransferScheduleUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSnapmirrorPoliciesGet binds the parameter fields
func (o *SnapmirrorPoliciesGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSnapmirrorPoliciesGet binds the parameter order_by
func (o *SnapmirrorPoliciesGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
