// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorPoliciesGetReader is a Reader for the SnapmirrorPoliciesGet structure.
type SnapmirrorPoliciesGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorPoliciesGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapmirrorPoliciesGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorPoliciesGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorPoliciesGetOK creates a SnapmirrorPoliciesGetOK with default headers values
func NewSnapmirrorPoliciesGetOK() *SnapmirrorPoliciesGetOK {
	return &SnapmirrorPoliciesGetOK{}
}

/*
SnapmirrorPoliciesGetOK describes a response with status code 200, with default header values.

OK
*/
type SnapmirrorPoliciesGetOK struct {
	Payload *models.SnapmirrorPolicyResponse
}

// IsSuccess returns true when this snapmirror policies get o k response has a 2xx status code
func (o *SnapmirrorPoliciesGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror policies get o k response has a 3xx status code
func (o *SnapmirrorPoliciesGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror policies get o k response has a 4xx status code
func (o *SnapmirrorPoliciesGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror policies get o k response has a 5xx status code
func (o *SnapmirrorPoliciesGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror policies get o k response a status code equal to that given
func (o *SnapmirrorPoliciesGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapmirror policies get o k response
func (o *SnapmirrorPoliciesGetOK) Code() int {
	return 200
}

func (o *SnapmirrorPoliciesGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/policies][%d] snapmirrorPoliciesGetOK %s", 200, payload)
}

func (o *SnapmirrorPoliciesGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/policies][%d] snapmirrorPoliciesGetOK %s", 200, payload)
}

func (o *SnapmirrorPoliciesGetOK) GetPayload() *models.SnapmirrorPolicyResponse {
	return o.Payload
}

func (o *SnapmirrorPoliciesGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorPolicyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorPoliciesGetDefault creates a SnapmirrorPoliciesGetDefault with default headers values
func NewSnapmirrorPoliciesGetDefault(code int) *SnapmirrorPoliciesGetDefault {
	return &SnapmirrorPoliciesGetDefault{
		_statusCode: code,
	}
}

/*
	SnapmirrorPoliciesGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13303842    | SnapMirror policy is not supported.|
*/
type SnapmirrorPoliciesGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror policies get default response has a 2xx status code
func (o *SnapmirrorPoliciesGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror policies get default response has a 3xx status code
func (o *SnapmirrorPoliciesGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror policies get default response has a 4xx status code
func (o *SnapmirrorPoliciesGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror policies get default response has a 5xx status code
func (o *SnapmirrorPoliciesGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror policies get default response a status code equal to that given
func (o *SnapmirrorPoliciesGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror policies get default response
func (o *SnapmirrorPoliciesGetDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorPoliciesGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/policies][%d] snapmirror_policies_get default %s", o._statusCode, payload)
}

func (o *SnapmirrorPoliciesGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/policies][%d] snapmirror_policies_get default %s", o._statusCode, payload)
}

func (o *SnapmirrorPoliciesGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorPoliciesGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
