// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorPolicyDeleteReader is a Reader for the SnapmirrorPolicyDelete structure.
type SnapmirrorPolicyDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorPolicyDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapmirrorPolicyDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSnapmirrorPolicyDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorPolicyDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorPolicyDeleteOK creates a SnapmirrorPolicyDeleteOK with default headers values
func NewSnapmirrorPolicyDeleteOK() *SnapmirrorPolicyDeleteOK {
	return &SnapmirrorPolicyDeleteOK{}
}

/*
SnapmirrorPolicyDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SnapmirrorPolicyDeleteOK struct {
	Payload *models.SnapmirrorPolicyJobLinkResponse
}

// IsSuccess returns true when this snapmirror policy delete o k response has a 2xx status code
func (o *SnapmirrorPolicyDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror policy delete o k response has a 3xx status code
func (o *SnapmirrorPolicyDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror policy delete o k response has a 4xx status code
func (o *SnapmirrorPolicyDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror policy delete o k response has a 5xx status code
func (o *SnapmirrorPolicyDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror policy delete o k response a status code equal to that given
func (o *SnapmirrorPolicyDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapmirror policy delete o k response
func (o *SnapmirrorPolicyDeleteOK) Code() int {
	return 200
}

func (o *SnapmirrorPolicyDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/policies/{uuid}][%d] snapmirrorPolicyDeleteOK %s", 200, payload)
}

func (o *SnapmirrorPolicyDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/policies/{uuid}][%d] snapmirrorPolicyDeleteOK %s", 200, payload)
}

func (o *SnapmirrorPolicyDeleteOK) GetPayload() *models.SnapmirrorPolicyJobLinkResponse {
	return o.Payload
}

func (o *SnapmirrorPolicyDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorPolicyJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorPolicyDeleteAccepted creates a SnapmirrorPolicyDeleteAccepted with default headers values
func NewSnapmirrorPolicyDeleteAccepted() *SnapmirrorPolicyDeleteAccepted {
	return &SnapmirrorPolicyDeleteAccepted{}
}

/*
SnapmirrorPolicyDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SnapmirrorPolicyDeleteAccepted struct {
	Payload *models.SnapmirrorPolicyJobLinkResponse
}

// IsSuccess returns true when this snapmirror policy delete accepted response has a 2xx status code
func (o *SnapmirrorPolicyDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror policy delete accepted response has a 3xx status code
func (o *SnapmirrorPolicyDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror policy delete accepted response has a 4xx status code
func (o *SnapmirrorPolicyDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror policy delete accepted response has a 5xx status code
func (o *SnapmirrorPolicyDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror policy delete accepted response a status code equal to that given
func (o *SnapmirrorPolicyDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the snapmirror policy delete accepted response
func (o *SnapmirrorPolicyDeleteAccepted) Code() int {
	return 202
}

func (o *SnapmirrorPolicyDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/policies/{uuid}][%d] snapmirrorPolicyDeleteAccepted %s", 202, payload)
}

func (o *SnapmirrorPolicyDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/policies/{uuid}][%d] snapmirrorPolicyDeleteAccepted %s", 202, payload)
}

func (o *SnapmirrorPolicyDeleteAccepted) GetPayload() *models.SnapmirrorPolicyJobLinkResponse {
	return o.Payload
}

func (o *SnapmirrorPolicyDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorPolicyJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorPolicyDeleteDefault creates a SnapmirrorPolicyDeleteDefault with default headers values
func NewSnapmirrorPolicyDeleteDefault(code int) *SnapmirrorPolicyDeleteDefault {
	return &SnapmirrorPolicyDeleteDefault{
		_statusCode: code,
	}
}

/*
SnapmirrorPolicyDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type SnapmirrorPolicyDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror policy delete default response has a 2xx status code
func (o *SnapmirrorPolicyDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror policy delete default response has a 3xx status code
func (o *SnapmirrorPolicyDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror policy delete default response has a 4xx status code
func (o *SnapmirrorPolicyDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror policy delete default response has a 5xx status code
func (o *SnapmirrorPolicyDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror policy delete default response a status code equal to that given
func (o *SnapmirrorPolicyDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror policy delete default response
func (o *SnapmirrorPolicyDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorPolicyDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/policies/{uuid}][%d] snapmirror_policy_delete default %s", o._statusCode, payload)
}

func (o *SnapmirrorPolicyDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/policies/{uuid}][%d] snapmirror_policy_delete default %s", o._statusCode, payload)
}

func (o *SnapmirrorPolicyDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorPolicyDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
