// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorPolicyModifyCollectionReader is a Reader for the SnapmirrorPolicyModifyCollection structure.
type SnapmirrorPolicyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorPolicyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapmirrorPolicyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSnapmirrorPolicyModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorPolicyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorPolicyModifyCollectionOK creates a SnapmirrorPolicyModifyCollectionOK with default headers values
func NewSnapmirrorPolicyModifyCollectionOK() *SnapmirrorPolicyModifyCollectionOK {
	return &SnapmirrorPolicyModifyCollectionOK{}
}

/*
SnapmirrorPolicyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnapmirrorPolicyModifyCollectionOK struct {
	Payload *models.SnapmirrorPolicyJobLinkResponse
}

// IsSuccess returns true when this snapmirror policy modify collection o k response has a 2xx status code
func (o *SnapmirrorPolicyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror policy modify collection o k response has a 3xx status code
func (o *SnapmirrorPolicyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror policy modify collection o k response has a 4xx status code
func (o *SnapmirrorPolicyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror policy modify collection o k response has a 5xx status code
func (o *SnapmirrorPolicyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror policy modify collection o k response a status code equal to that given
func (o *SnapmirrorPolicyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapmirror policy modify collection o k response
func (o *SnapmirrorPolicyModifyCollectionOK) Code() int {
	return 200
}

func (o *SnapmirrorPolicyModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/policies][%d] snapmirrorPolicyModifyCollectionOK %s", 200, payload)
}

func (o *SnapmirrorPolicyModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/policies][%d] snapmirrorPolicyModifyCollectionOK %s", 200, payload)
}

func (o *SnapmirrorPolicyModifyCollectionOK) GetPayload() *models.SnapmirrorPolicyJobLinkResponse {
	return o.Payload
}

func (o *SnapmirrorPolicyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorPolicyJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorPolicyModifyCollectionAccepted creates a SnapmirrorPolicyModifyCollectionAccepted with default headers values
func NewSnapmirrorPolicyModifyCollectionAccepted() *SnapmirrorPolicyModifyCollectionAccepted {
	return &SnapmirrorPolicyModifyCollectionAccepted{}
}

/*
SnapmirrorPolicyModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SnapmirrorPolicyModifyCollectionAccepted struct {
	Payload *models.SnapmirrorPolicyJobLinkResponse
}

// IsSuccess returns true when this snapmirror policy modify collection accepted response has a 2xx status code
func (o *SnapmirrorPolicyModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror policy modify collection accepted response has a 3xx status code
func (o *SnapmirrorPolicyModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror policy modify collection accepted response has a 4xx status code
func (o *SnapmirrorPolicyModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror policy modify collection accepted response has a 5xx status code
func (o *SnapmirrorPolicyModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror policy modify collection accepted response a status code equal to that given
func (o *SnapmirrorPolicyModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the snapmirror policy modify collection accepted response
func (o *SnapmirrorPolicyModifyCollectionAccepted) Code() int {
	return 202
}

func (o *SnapmirrorPolicyModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/policies][%d] snapmirrorPolicyModifyCollectionAccepted %s", 202, payload)
}

func (o *SnapmirrorPolicyModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/policies][%d] snapmirrorPolicyModifyCollectionAccepted %s", 202, payload)
}

func (o *SnapmirrorPolicyModifyCollectionAccepted) GetPayload() *models.SnapmirrorPolicyJobLinkResponse {
	return o.Payload
}

func (o *SnapmirrorPolicyModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorPolicyJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorPolicyModifyCollectionDefault creates a SnapmirrorPolicyModifyCollectionDefault with default headers values
func NewSnapmirrorPolicyModifyCollectionDefault(code int) *SnapmirrorPolicyModifyCollectionDefault {
	return &SnapmirrorPolicyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnapmirrorPolicyModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 6619714     | Schedule specified is an interval schedule. SnapMirror does not support interval schedules. |
| 13303842    | SnapMirror policy is not supported. |
| 13303843    | Conflicting values between SnapMirror policy and SnapMirror relationships for either 'transfer_schedule, throttle or identity_preservation' properties |
| 13303850    | Invalid input parameter |
| 13303887    | Failed to create SnapMirror policy. Reason: Maximum number of allowed retention rules reached |
| 13304050    | Retention cannot be empty for a SnapMirror policy with 'create_snapshot_on_source' set to false. |
| 13304092    | Input value of the retention period property is invalid. For relationships with FlexVol volume or FlexGroup volume destinations, the duration must be in ISO 6801 format or can be infinite. For relationships with object store destinations, only duration values with Y, M or D and supported and must be in the specified range. |

| 6621045     | The property retention.warn is not supported for a policy when the retention.preserve property is false. |
| 13304129    | The property retention.warn value must be less than the property retention.count value for a rule in a policy. |
| 13304126    | Enter a value for "count" in the range indicated in the error message. |
| 13304130    | The total retention.count value for all rules in a policy cannot exceed the value indicated in the error message." |
| 13304131    | Modifying property "retention.creation_schedule" for the policy is not supported because the policy is associated with a relationship with a FlexGroup volume endpoint. |
| 13304011    | Failed to create or modify the specified Snapmirror policy. Reason: The property retention.count cannot have a value greater than 1. |
| 6621091     | The specified Snapmirror policy cannot have a rule with a preserve value of true. |
| 6621088     | The specified Snapmirror policy must have at least one rule without a schedule. |
| 6621129     | Cannot add a snapshot creation schedule to the policy because it is associated with a Consistency Group relationship. |
*/
type SnapmirrorPolicyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror policy modify collection default response has a 2xx status code
func (o *SnapmirrorPolicyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror policy modify collection default response has a 3xx status code
func (o *SnapmirrorPolicyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror policy modify collection default response has a 4xx status code
func (o *SnapmirrorPolicyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror policy modify collection default response has a 5xx status code
func (o *SnapmirrorPolicyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror policy modify collection default response a status code equal to that given
func (o *SnapmirrorPolicyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror policy modify collection default response
func (o *SnapmirrorPolicyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorPolicyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/policies][%d] snapmirror_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *SnapmirrorPolicyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/policies][%d] snapmirror_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *SnapmirrorPolicyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorPolicyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnapmirrorPolicyModifyCollectionBody snapmirror policy modify collection body
swagger:model SnapmirrorPolicyModifyCollectionBody
*/
type SnapmirrorPolicyModifyCollectionBody struct {

	// links
	Links *models.SnapmirrorPolicyInlineLinks `json:"_links,omitempty"`

	// Comment associated with the policy.
	Comment *string `json:"comment,omitempty"`

	// Specifies that all the source snapshots (including the one created by SnapMirror before the transfer begins) should be copied to the destination on a transfer. "Retention" properties cannot be specified along with this property. This is applicable only to async policies. Property can only be set to 'true'.
	// Example: true
	CopyAllSourceSnapshots *bool `json:"copy_all_source_snapshots,omitempty"`

	// Specifies that the latest source snapshot (created by SnapMirror before the transfer begins) should be copied to the destination on a transfer. "Retention" properties cannot be specified along with this property. This is applicable only to async policies. Property can only be set to 'true'.
	// Example: true
	CopyLatestSourceSnapshot *bool `json:"copy_latest_source_snapshot,omitempty"`

	// Specifies whether a new snapshot should be created on the source at the beginning of an update or resync operation. This is applicable only to async policies. Property can only be set to 'false'.
	// Example: false
	CreateSnapshotOnSource *bool `json:"create_snapshot_on_source,omitempty"`

	// Specifies which configuration of the source SVM is replicated to the destination SVM. This property is applicable only for SVM data protection with "async" policy type.
	// Enum: ["full","exclude_network_config","exclude_network_and_protocol_config"]
	IdentityPreservation *string `json:"identity_preservation,omitempty"`

	// Name of the policy.
	// Example: Asynchronous
	Name *string `json:"name,omitempty"`

	// Specifies whether network compression is enabled for transfers. This is applicable only to the policies of type "async".
	NetworkCompressionEnabled *bool `json:"network_compression_enabled,omitempty"`

	// Specifies the duration of time for which a change to be propagated to a mirror should be delayed, in seconds. This is an intentional propagation delay between mirrors and is configurable down to zero, which means an immediate propagation. This is supported for policies of type 'continuous'.
	Rpo *int64 `json:"rpo,omitempty"`

	// Set to "svm" for policies owned by an SVM, otherwise set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// Rules for snapshot retention.
	SnapmirrorPolicyInlineRetention []*models.SnapmirrorPolicyRule `json:"retention,omitempty"`

	// snapmirror policy response inline records
	SnapmirrorPolicyResponseInlineRecords []*models.SnapmirrorPolicy `json:"records,omitempty"`

	// svm
	Svm *models.SnapmirrorPolicyInlineSvm `json:"svm,omitempty"`

	// sync common snapshot schedule
	SyncCommonSnapshotSchedule *models.SnapmirrorPolicyInlineSyncCommonSnapshotSchedule `json:"sync_common_snapshot_schedule,omitempty"`

	// sync type
	// Enum: ["sync","strict_sync","automated_failover","automated_failover_duplex"]
	SyncType *string `json:"sync_type,omitempty"`

	// Throttle in KB/s. Default to unlimited.
	Throttle *int64 `json:"throttle,omitempty"`

	// transfer schedule
	TransferSchedule *models.SnapmirrorPolicyInlineTransferSchedule `json:"transfer_schedule,omitempty"`

	// type
	// Enum: ["async","sync","continuous"]
	Type *string `json:"type,omitempty"`

	// Unique identifier of the SnapMirror policy.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror policy modify collection body
func (o *SnapmirrorPolicyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIdentityPreservation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirrorPolicyInlineRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirrorPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSyncCommonSnapshotSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSyncType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTransferSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var snapmirrorPolicyModifyCollectionBodyTypeIdentityPreservationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","exclude_network_config","exclude_network_and_protocol_config"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorPolicyModifyCollectionBodyTypeIdentityPreservationPropEnum = append(snapmirrorPolicyModifyCollectionBodyTypeIdentityPreservationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// identity_preservation
	// IdentityPreservation
	// full
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodyIdentityPreservationFull captures enum value "full"
	SnapmirrorPolicyModifyCollectionBodyIdentityPreservationFull string = "full"

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// identity_preservation
	// IdentityPreservation
	// exclude_network_config
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodyIdentityPreservationExcludeNetworkConfig captures enum value "exclude_network_config"
	SnapmirrorPolicyModifyCollectionBodyIdentityPreservationExcludeNetworkConfig string = "exclude_network_config"

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// identity_preservation
	// IdentityPreservation
	// exclude_network_and_protocol_config
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodyIdentityPreservationExcludeNetworkAndProtocolConfig captures enum value "exclude_network_and_protocol_config"
	SnapmirrorPolicyModifyCollectionBodyIdentityPreservationExcludeNetworkAndProtocolConfig string = "exclude_network_and_protocol_config"
)

// prop value enum
func (o *SnapmirrorPolicyModifyCollectionBody) validateIdentityPreservationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorPolicyModifyCollectionBodyTypeIdentityPreservationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateIdentityPreservation(formats strfmt.Registry) error {
	if swag.IsZero(o.IdentityPreservation) { // not required
		return nil
	}

	// value enum
	if err := o.validateIdentityPreservationEnum("info"+"."+"identity_preservation", "body", *o.IdentityPreservation); err != nil {
		return err
	}

	return nil
}

var snapmirrorPolicyModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorPolicyModifyCollectionBodyTypeScopePropEnum = append(snapmirrorPolicyModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodyScopeSvm captures enum value "svm"
	SnapmirrorPolicyModifyCollectionBodyScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodyScopeCluster captures enum value "cluster"
	SnapmirrorPolicyModifyCollectionBodyScopeCluster string = "cluster"
)

// prop value enum
func (o *SnapmirrorPolicyModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorPolicyModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateSnapmirrorPolicyInlineRetention(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapmirrorPolicyInlineRetention) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapmirrorPolicyInlineRetention); i++ {
		if swag.IsZero(o.SnapmirrorPolicyInlineRetention[i]) { // not required
			continue
		}

		if o.SnapmirrorPolicyInlineRetention[i] != nil {
			if err := o.SnapmirrorPolicyInlineRetention[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "retention" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateSnapmirrorPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapmirrorPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapmirrorPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.SnapmirrorPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnapmirrorPolicyResponseInlineRecords[i] != nil {
			if err := o.SnapmirrorPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateSyncCommonSnapshotSchedule(formats strfmt.Registry) error {
	if swag.IsZero(o.SyncCommonSnapshotSchedule) { // not required
		return nil
	}

	if o.SyncCommonSnapshotSchedule != nil {
		if err := o.SyncCommonSnapshotSchedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "sync_common_snapshot_schedule")
			}
			return err
		}
	}

	return nil
}

var snapmirrorPolicyModifyCollectionBodyTypeSyncTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sync","strict_sync","automated_failover","automated_failover_duplex"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorPolicyModifyCollectionBodyTypeSyncTypePropEnum = append(snapmirrorPolicyModifyCollectionBodyTypeSyncTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// sync_type
	// SyncType
	// sync
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodySyncTypeSync captures enum value "sync"
	SnapmirrorPolicyModifyCollectionBodySyncTypeSync string = "sync"

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// sync_type
	// SyncType
	// strict_sync
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodySyncTypeStrictSync captures enum value "strict_sync"
	SnapmirrorPolicyModifyCollectionBodySyncTypeStrictSync string = "strict_sync"

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// sync_type
	// SyncType
	// automated_failover
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodySyncTypeAutomatedFailover captures enum value "automated_failover"
	SnapmirrorPolicyModifyCollectionBodySyncTypeAutomatedFailover string = "automated_failover"

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// sync_type
	// SyncType
	// automated_failover_duplex
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodySyncTypeAutomatedFailoverDuplex captures enum value "automated_failover_duplex"
	SnapmirrorPolicyModifyCollectionBodySyncTypeAutomatedFailoverDuplex string = "automated_failover_duplex"
)

// prop value enum
func (o *SnapmirrorPolicyModifyCollectionBody) validateSyncTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorPolicyModifyCollectionBodyTypeSyncTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateSyncType(formats strfmt.Registry) error {
	if swag.IsZero(o.SyncType) { // not required
		return nil
	}

	// value enum
	if err := o.validateSyncTypeEnum("info"+"."+"sync_type", "body", *o.SyncType); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateTransferSchedule(formats strfmt.Registry) error {
	if swag.IsZero(o.TransferSchedule) { // not required
		return nil
	}

	if o.TransferSchedule != nil {
		if err := o.TransferSchedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule")
			}
			return err
		}
	}

	return nil
}

var snapmirrorPolicyModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["async","sync","continuous"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorPolicyModifyCollectionBodyTypeTypePropEnum = append(snapmirrorPolicyModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// type
	// Type
	// async
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodyTypeAsync captures enum value "async"
	SnapmirrorPolicyModifyCollectionBodyTypeAsync string = "async"

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// type
	// Type
	// sync
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodyTypeSync captures enum value "sync"
	SnapmirrorPolicyModifyCollectionBodyTypeSync string = "sync"

	// BEGIN DEBUGGING
	// SnapmirrorPolicyModifyCollectionBody
	// SnapmirrorPolicyModifyCollectionBody
	// type
	// Type
	// continuous
	// END DEBUGGING
	// SnapmirrorPolicyModifyCollectionBodyTypeContinuous captures enum value "continuous"
	SnapmirrorPolicyModifyCollectionBodyTypeContinuous string = "continuous"
)

// prop value enum
func (o *SnapmirrorPolicyModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorPolicyModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror policy modify collection body based on the context it is used
func (o *SnapmirrorPolicyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapmirrorPolicyInlineRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapmirrorPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSyncCommonSnapshotSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTransferSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) contextValidateSnapmirrorPolicyInlineRetention(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnapmirrorPolicyInlineRetention); i++ {

		if o.SnapmirrorPolicyInlineRetention[i] != nil {
			if err := o.SnapmirrorPolicyInlineRetention[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "retention" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) contextValidateSnapmirrorPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnapmirrorPolicyResponseInlineRecords); i++ {

		if o.SnapmirrorPolicyResponseInlineRecords[i] != nil {
			if err := o.SnapmirrorPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) contextValidateSyncCommonSnapshotSchedule(ctx context.Context, formats strfmt.Registry) error {

	if o.SyncCommonSnapshotSchedule != nil {
		if err := o.SyncCommonSnapshotSchedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "sync_common_snapshot_schedule")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) contextValidateTransferSchedule(ctx context.Context, formats strfmt.Registry) error {

	if o.TransferSchedule != nil {
		if err := o.TransferSchedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorPolicyModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorPolicyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorPolicyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorPolicyInlineLinks snapmirror policy inline links
swagger:model snapmirror_policy_inline__links
*/
type SnapmirrorPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapmirror policy inline links
func (o *SnapmirrorPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline links based on the context it is used
func (o *SnapmirrorPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorPolicyInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model snapmirror_policy_inline_svm
*/
type SnapmirrorPolicyInlineSvm struct {

	// links
	Links *models.SnapmirrorPolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapmirror policy inline svm
func (o *SnapmirrorPolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline svm based on the context it is used
func (o *SnapmirrorPolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorPolicyInlineSvmInlineLinks snapmirror policy inline svm inline links
swagger:model snapmirror_policy_inline_svm_inline__links
*/
type SnapmirrorPolicyInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapmirror policy inline svm inline links
func (o *SnapmirrorPolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline svm inline links based on the context it is used
func (o *SnapmirrorPolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorPolicyInlineSyncCommonSnapshotSchedule Schedule used to create common snapshots for synchronous relationships.
swagger:model snapmirror_policy_inline_sync_common_snapshot_schedule
*/
type SnapmirrorPolicyInlineSyncCommonSnapshotSchedule struct {

	// links
	Links *models.SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks `json:"_links,omitempty"`

	// Job schedule name
	// Example: weekly
	Name *string `json:"name,omitempty"`

	// Job schedule UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapmirror policy inline sync common snapshot schedule
func (o *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "sync_common_snapshot_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline sync common snapshot schedule based on the context it is used
func (o *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "sync_common_snapshot_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineSyncCommonSnapshotSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks snapmirror policy inline sync common snapshot schedule inline links
swagger:model snapmirror_policy_inline_sync_common_snapshot_schedule_inline__links
*/
type SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapmirror policy inline sync common snapshot schedule inline links
func (o *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "sync_common_snapshot_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline sync common snapshot schedule inline links based on the context it is used
func (o *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "sync_common_snapshot_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorPolicyInlineTransferSchedule The schedule used to update asynchronous relationships. Only cron schedules are supported for SnapMirror.
swagger:model snapmirror_policy_inline_transfer_schedule
*/
type SnapmirrorPolicyInlineTransferSchedule struct {

	// links
	Links *models.SnapmirrorPolicyInlineTransferScheduleInlineLinks `json:"_links,omitempty"`

	// Job schedule name
	// Example: weekly
	Name *string `json:"name,omitempty"`

	// Job schedule UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapmirror policy inline transfer schedule
func (o *SnapmirrorPolicyInlineTransferSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineTransferSchedule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline transfer schedule based on the context it is used
func (o *SnapmirrorPolicyInlineTransferSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineTransferSchedule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineTransferSchedule) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineTransferSchedule) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineTransferSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorPolicyInlineTransferScheduleInlineLinks snapmirror policy inline transfer schedule inline links
swagger:model snapmirror_policy_inline_transfer_schedule_inline__links
*/
type SnapmirrorPolicyInlineTransferScheduleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapmirror policy inline transfer schedule inline links
func (o *SnapmirrorPolicyInlineTransferScheduleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineTransferScheduleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline transfer schedule inline links based on the context it is used
func (o *SnapmirrorPolicyInlineTransferScheduleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorPolicyInlineTransferScheduleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineTransferScheduleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorPolicyInlineTransferScheduleInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineTransferScheduleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
