// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSnapmirrorRelationshipCreateParams creates a new SnapmirrorRelationshipCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapmirrorRelationshipCreateParams() *SnapmirrorRelationshipCreateParams {
	return &SnapmirrorRelationshipCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapmirrorRelationshipCreateParamsWithTimeout creates a new SnapmirrorRelationshipCreateParams object
// with the ability to set a timeout on a request.
func NewSnapmirrorRelationshipCreateParamsWithTimeout(timeout time.Duration) *SnapmirrorRelationshipCreateParams {
	return &SnapmirrorRelationshipCreateParams{
		timeout: timeout,
	}
}

// NewSnapmirrorRelationshipCreateParamsWithContext creates a new SnapmirrorRelationshipCreateParams object
// with the ability to set a context for a request.
func NewSnapmirrorRelationshipCreateParamsWithContext(ctx context.Context) *SnapmirrorRelationshipCreateParams {
	return &SnapmirrorRelationshipCreateParams{
		Context: ctx,
	}
}

// NewSnapmirrorRelationshipCreateParamsWithHTTPClient creates a new SnapmirrorRelationshipCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapmirrorRelationshipCreateParamsWithHTTPClient(client *http.Client) *SnapmirrorRelationshipCreateParams {
	return &SnapmirrorRelationshipCreateParams{
		HTTPClient: client,
	}
}

/*
SnapmirrorRelationshipCreateParams contains all the parameters to send to the API endpoint

	for the snapmirror relationship create operation.

	Typically these are written to a http.Request.
*/
type SnapmirrorRelationshipCreateParams struct {

	/* Info.

	   Information on the SnapMirror relationship
	*/
	Info *models.SnapmirrorRelationship

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* ValidateOnly.

	   Validate the operation and its parameters, without actually performing the operation.
	*/
	ValidateOnly *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapmirror relationship create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorRelationshipCreateParams) WithDefaults() *SnapmirrorRelationshipCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapmirror relationship create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorRelationshipCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := SnapmirrorRelationshipCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) WithTimeout(timeout time.Duration) *SnapmirrorRelationshipCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) WithContext(ctx context.Context) *SnapmirrorRelationshipCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) WithHTTPClient(client *http.Client) *SnapmirrorRelationshipCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) WithInfo(info *models.SnapmirrorRelationship) *SnapmirrorRelationshipCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) SetInfo(info *models.SnapmirrorRelationship) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) WithReturnRecords(returnRecords *bool) *SnapmirrorRelationshipCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) WithReturnTimeout(returnTimeout *int64) *SnapmirrorRelationshipCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithValidateOnly adds the validateOnly to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) WithValidateOnly(validateOnly *bool) *SnapmirrorRelationshipCreateParams {
	o.SetValidateOnly(validateOnly)
	return o
}

// SetValidateOnly adds the validateOnly to the snapmirror relationship create params
func (o *SnapmirrorRelationshipCreateParams) SetValidateOnly(validateOnly *bool) {
	o.ValidateOnly = validateOnly
}

// WriteToRequest writes these params to a swagger request
func (o *SnapmirrorRelationshipCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ValidateOnly != nil {

		// query param validate_only
		var qrValidateOnly bool

		if o.ValidateOnly != nil {
			qrValidateOnly = *o.ValidateOnly
		}
		qValidateOnly := swag.FormatBool(qrValidateOnly)
		if qValidateOnly != "" {

			if err := r.SetQueryParam("validate_only", qValidateOnly); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
