// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorRelationshipDeleteCollectionReader is a Reader for the SnapmirrorRelationshipDeleteCollection structure.
type SnapmirrorRelationshipDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorRelationshipDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapmirrorRelationshipDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSnapmirrorRelationshipDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorRelationshipDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorRelationshipDeleteCollectionOK creates a SnapmirrorRelationshipDeleteCollectionOK with default headers values
func NewSnapmirrorRelationshipDeleteCollectionOK() *SnapmirrorRelationshipDeleteCollectionOK {
	return &SnapmirrorRelationshipDeleteCollectionOK{}
}

/*
SnapmirrorRelationshipDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnapmirrorRelationshipDeleteCollectionOK struct {
	Payload *models.SnapmirrorRelationshipJobLinkResponse
}

// IsSuccess returns true when this snapmirror relationship delete collection o k response has a 2xx status code
func (o *SnapmirrorRelationshipDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror relationship delete collection o k response has a 3xx status code
func (o *SnapmirrorRelationshipDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror relationship delete collection o k response has a 4xx status code
func (o *SnapmirrorRelationshipDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror relationship delete collection o k response has a 5xx status code
func (o *SnapmirrorRelationshipDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror relationship delete collection o k response a status code equal to that given
func (o *SnapmirrorRelationshipDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapmirror relationship delete collection o k response
func (o *SnapmirrorRelationshipDeleteCollectionOK) Code() int {
	return 200
}

func (o *SnapmirrorRelationshipDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/relationships][%d] snapmirrorRelationshipDeleteCollectionOK %s", 200, payload)
}

func (o *SnapmirrorRelationshipDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/relationships][%d] snapmirrorRelationshipDeleteCollectionOK %s", 200, payload)
}

func (o *SnapmirrorRelationshipDeleteCollectionOK) GetPayload() *models.SnapmirrorRelationshipJobLinkResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorRelationshipJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorRelationshipDeleteCollectionAccepted creates a SnapmirrorRelationshipDeleteCollectionAccepted with default headers values
func NewSnapmirrorRelationshipDeleteCollectionAccepted() *SnapmirrorRelationshipDeleteCollectionAccepted {
	return &SnapmirrorRelationshipDeleteCollectionAccepted{}
}

/*
SnapmirrorRelationshipDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SnapmirrorRelationshipDeleteCollectionAccepted struct {
	Payload *models.SnapmirrorRelationshipJobLinkResponse
}

// IsSuccess returns true when this snapmirror relationship delete collection accepted response has a 2xx status code
func (o *SnapmirrorRelationshipDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror relationship delete collection accepted response has a 3xx status code
func (o *SnapmirrorRelationshipDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror relationship delete collection accepted response has a 4xx status code
func (o *SnapmirrorRelationshipDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror relationship delete collection accepted response has a 5xx status code
func (o *SnapmirrorRelationshipDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror relationship delete collection accepted response a status code equal to that given
func (o *SnapmirrorRelationshipDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the snapmirror relationship delete collection accepted response
func (o *SnapmirrorRelationshipDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *SnapmirrorRelationshipDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/relationships][%d] snapmirrorRelationshipDeleteCollectionAccepted %s", 202, payload)
}

func (o *SnapmirrorRelationshipDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/relationships][%d] snapmirrorRelationshipDeleteCollectionAccepted %s", 202, payload)
}

func (o *SnapmirrorRelationshipDeleteCollectionAccepted) GetPayload() *models.SnapmirrorRelationshipJobLinkResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorRelationshipJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorRelationshipDeleteCollectionDefault creates a SnapmirrorRelationshipDeleteCollectionDefault with default headers values
func NewSnapmirrorRelationshipDeleteCollectionDefault(code int) *SnapmirrorRelationshipDeleteCollectionDefault {
	return &SnapmirrorRelationshipDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnapmirrorRelationshipDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13303825    | Could not retrieve information for the SnapMirror policy type |
| 13303814    | Could not retrieve the source or destination SVM UUID |
| 13303815    | Could not retrieve information for the peer cluster |
| 13303822    | SnapMirror release has failed |
| 13303813    | SnapMirror release was successful but delete has failed |
| 13303854    | Cleanup of restore relationship failed |
| 13303855    | DELETE call on a restore relationship does not support the given flags |
| 13303865    | Deleting the specified SnapMirror policy is not supported. |
| 6619715     | Modification of relationship is in progress. Retry the command after a few minutes. |
| 6621470     | SnapMirror delete failed on the relationship because \"unmap-namespace\" is not set. Set the \"unmap-namespace\" to true for NVMe SnapMirror active sync relationships. |
*/
type SnapmirrorRelationshipDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror relationship delete collection default response has a 2xx status code
func (o *SnapmirrorRelationshipDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror relationship delete collection default response has a 3xx status code
func (o *SnapmirrorRelationshipDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror relationship delete collection default response has a 4xx status code
func (o *SnapmirrorRelationshipDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror relationship delete collection default response has a 5xx status code
func (o *SnapmirrorRelationshipDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror relationship delete collection default response a status code equal to that given
func (o *SnapmirrorRelationshipDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror relationship delete collection default response
func (o *SnapmirrorRelationshipDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorRelationshipDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/relationships][%d] snapmirror_relationship_delete_collection default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /snapmirror/relationships][%d] snapmirror_relationship_delete_collection default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnapmirrorRelationshipDeleteCollectionBody snapmirror relationship delete collection body
swagger:model SnapmirrorRelationshipDeleteCollectionBody
*/
type SnapmirrorRelationshipDeleteCollectionBody struct {

	// snapmirror relationship response inline records
	SnapmirrorRelationshipResponseInlineRecords []*models.SnapmirrorRelationship `json:"records,omitempty"`
}

// Validate validates this snapmirror relationship delete collection body
func (o *SnapmirrorRelationshipDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnapmirrorRelationshipResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipDeleteCollectionBody) validateSnapmirrorRelationshipResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapmirrorRelationshipResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapmirrorRelationshipResponseInlineRecords); i++ {
		if swag.IsZero(o.SnapmirrorRelationshipResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnapmirrorRelationshipResponseInlineRecords[i] != nil {
			if err := o.SnapmirrorRelationshipResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this snapmirror relationship delete collection body based on the context it is used
func (o *SnapmirrorRelationshipDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnapmirrorRelationshipResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipDeleteCollectionBody) contextValidateSnapmirrorRelationshipResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnapmirrorRelationshipResponseInlineRecords); i++ {

		if o.SnapmirrorRelationshipResponseInlineRecords[i] != nil {
			if err := o.SnapmirrorRelationshipResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
