// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnapmirrorRelationshipDeleteParams creates a new SnapmirrorRelationshipDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapmirrorRelationshipDeleteParams() *SnapmirrorRelationshipDeleteParams {
	return &SnapmirrorRelationshipDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapmirrorRelationshipDeleteParamsWithTimeout creates a new SnapmirrorRelationshipDeleteParams object
// with the ability to set a timeout on a request.
func NewSnapmirrorRelationshipDeleteParamsWithTimeout(timeout time.Duration) *SnapmirrorRelationshipDeleteParams {
	return &SnapmirrorRelationshipDeleteParams{
		timeout: timeout,
	}
}

// NewSnapmirrorRelationshipDeleteParamsWithContext creates a new SnapmirrorRelationshipDeleteParams object
// with the ability to set a context for a request.
func NewSnapmirrorRelationshipDeleteParamsWithContext(ctx context.Context) *SnapmirrorRelationshipDeleteParams {
	return &SnapmirrorRelationshipDeleteParams{
		Context: ctx,
	}
}

// NewSnapmirrorRelationshipDeleteParamsWithHTTPClient creates a new SnapmirrorRelationshipDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapmirrorRelationshipDeleteParamsWithHTTPClient(client *http.Client) *SnapmirrorRelationshipDeleteParams {
	return &SnapmirrorRelationshipDeleteParams{
		HTTPClient: client,
	}
}

/*
SnapmirrorRelationshipDeleteParams contains all the parameters to send to the API endpoint

	for the snapmirror relationship delete operation.

	Typically these are written to a http.Request.
*/
type SnapmirrorRelationshipDeleteParams struct {

	/* DeleteLunMapsInDestination.

	   Deletes LUN mapping for the volumes of the CG in destination.
	*/
	DeleteLunMapsInDestination *bool

	/* DestinationOnly.

	   Deletes a relationship on the destination only. This parameter is applicable only when the call is executed on the cluster that contains the destination endpoint.
	*/
	DestinationOnly *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* SourceInfoOnly.

	   Deletes relationship information on the source only. This parameter is applicable only when the call is executed on the cluster that contains the source endpoint.
	*/
	SourceInfoOnly *bool

	/* SourceOnly.

	   Deletes a relationship on the source only. This parameter is applicable only when the call is executed on the cluster that contains the source endpoint. In the case of a relationship that uses SnapMirror policy of type 'continuous', this parameter is used to delete the source end of the relationship while ignoring errors when the destination endpoint is not reachable.
	*/
	SourceOnly *bool

	/* UnmapNamespace.

	   Deletes namespace mapping and then deletes the subsystems.
	*/
	UnmapNamespace *bool

	/* UUID.

	   SnapMirror relationship UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapmirror relationship delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorRelationshipDeleteParams) WithDefaults() *SnapmirrorRelationshipDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapmirror relationship delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorRelationshipDeleteParams) SetDefaults() {
	var (
		deleteLunMapsInDestinationDefault = bool(false)

		returnTimeoutDefault = int64(0)

		unmapNamespaceDefault = bool(false)
	)

	val := SnapmirrorRelationshipDeleteParams{
		DeleteLunMapsInDestination: &deleteLunMapsInDestinationDefault,
		ReturnTimeout:              &returnTimeoutDefault,
		UnmapNamespace:             &unmapNamespaceDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) WithTimeout(timeout time.Duration) *SnapmirrorRelationshipDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) WithContext(ctx context.Context) *SnapmirrorRelationshipDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) WithHTTPClient(client *http.Client) *SnapmirrorRelationshipDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDeleteLunMapsInDestination adds the deleteLunMapsInDestination to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) WithDeleteLunMapsInDestination(deleteLunMapsInDestination *bool) *SnapmirrorRelationshipDeleteParams {
	o.SetDeleteLunMapsInDestination(deleteLunMapsInDestination)
	return o
}

// SetDeleteLunMapsInDestination adds the deleteLunMapsInDestination to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) SetDeleteLunMapsInDestination(deleteLunMapsInDestination *bool) {
	o.DeleteLunMapsInDestination = deleteLunMapsInDestination
}

// WithDestinationOnly adds the destinationOnly to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) WithDestinationOnly(destinationOnly *bool) *SnapmirrorRelationshipDeleteParams {
	o.SetDestinationOnly(destinationOnly)
	return o
}

// SetDestinationOnly adds the destinationOnly to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) SetDestinationOnly(destinationOnly *bool) {
	o.DestinationOnly = destinationOnly
}

// WithReturnTimeout adds the returnTimeout to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) WithReturnTimeout(returnTimeout *int64) *SnapmirrorRelationshipDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSourceInfoOnly adds the sourceInfoOnly to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) WithSourceInfoOnly(sourceInfoOnly *bool) *SnapmirrorRelationshipDeleteParams {
	o.SetSourceInfoOnly(sourceInfoOnly)
	return o
}

// SetSourceInfoOnly adds the sourceInfoOnly to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) SetSourceInfoOnly(sourceInfoOnly *bool) {
	o.SourceInfoOnly = sourceInfoOnly
}

// WithSourceOnly adds the sourceOnly to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) WithSourceOnly(sourceOnly *bool) *SnapmirrorRelationshipDeleteParams {
	o.SetSourceOnly(sourceOnly)
	return o
}

// SetSourceOnly adds the sourceOnly to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) SetSourceOnly(sourceOnly *bool) {
	o.SourceOnly = sourceOnly
}

// WithUnmapNamespace adds the unmapNamespace to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) WithUnmapNamespace(unmapNamespace *bool) *SnapmirrorRelationshipDeleteParams {
	o.SetUnmapNamespace(unmapNamespace)
	return o
}

// SetUnmapNamespace adds the unmapNamespace to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) SetUnmapNamespace(unmapNamespace *bool) {
	o.UnmapNamespace = unmapNamespace
}

// WithUUID adds the uuid to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) WithUUID(uuid string) *SnapmirrorRelationshipDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the snapmirror relationship delete params
func (o *SnapmirrorRelationshipDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SnapmirrorRelationshipDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DeleteLunMapsInDestination != nil {

		// query param delete_lun_maps_in_destination
		var qrDeleteLunMapsInDestination bool

		if o.DeleteLunMapsInDestination != nil {
			qrDeleteLunMapsInDestination = *o.DeleteLunMapsInDestination
		}
		qDeleteLunMapsInDestination := swag.FormatBool(qrDeleteLunMapsInDestination)
		if qDeleteLunMapsInDestination != "" {

			if err := r.SetQueryParam("delete_lun_maps_in_destination", qDeleteLunMapsInDestination); err != nil {
				return err
			}
		}
	}

	if o.DestinationOnly != nil {

		// query param destination_only
		var qrDestinationOnly bool

		if o.DestinationOnly != nil {
			qrDestinationOnly = *o.DestinationOnly
		}
		qDestinationOnly := swag.FormatBool(qrDestinationOnly)
		if qDestinationOnly != "" {

			if err := r.SetQueryParam("destination_only", qDestinationOnly); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SourceInfoOnly != nil {

		// query param source_info_only
		var qrSourceInfoOnly bool

		if o.SourceInfoOnly != nil {
			qrSourceInfoOnly = *o.SourceInfoOnly
		}
		qSourceInfoOnly := swag.FormatBool(qrSourceInfoOnly)
		if qSourceInfoOnly != "" {

			if err := r.SetQueryParam("source_info_only", qSourceInfoOnly); err != nil {
				return err
			}
		}
	}

	if o.SourceOnly != nil {

		// query param source_only
		var qrSourceOnly bool

		if o.SourceOnly != nil {
			qrSourceOnly = *o.SourceOnly
		}
		qSourceOnly := swag.FormatBool(qrSourceOnly)
		if qSourceOnly != "" {

			if err := r.SetQueryParam("source_only", qSourceOnly); err != nil {
				return err
			}
		}
	}

	if o.UnmapNamespace != nil {

		// query param unmap_namespace
		var qrUnmapNamespace bool

		if o.UnmapNamespace != nil {
			qrUnmapNamespace = *o.UnmapNamespace
		}
		qUnmapNamespace := swag.FormatBool(qrUnmapNamespace)
		if qUnmapNamespace != "" {

			if err := r.SetQueryParam("unmap_namespace", qUnmapNamespace); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
