// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnapmirrorRelationshipModifyCollectionParams creates a new SnapmirrorRelationshipModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapmirrorRelationshipModifyCollectionParams() *SnapmirrorRelationshipModifyCollectionParams {
	return &SnapmirrorRelationshipModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapmirrorRelationshipModifyCollectionParamsWithTimeout creates a new SnapmirrorRelationshipModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewSnapmirrorRelationshipModifyCollectionParamsWithTimeout(timeout time.Duration) *SnapmirrorRelationshipModifyCollectionParams {
	return &SnapmirrorRelationshipModifyCollectionParams{
		timeout: timeout,
	}
}

// NewSnapmirrorRelationshipModifyCollectionParamsWithContext creates a new SnapmirrorRelationshipModifyCollectionParams object
// with the ability to set a context for a request.
func NewSnapmirrorRelationshipModifyCollectionParamsWithContext(ctx context.Context) *SnapmirrorRelationshipModifyCollectionParams {
	return &SnapmirrorRelationshipModifyCollectionParams{
		Context: ctx,
	}
}

// NewSnapmirrorRelationshipModifyCollectionParamsWithHTTPClient creates a new SnapmirrorRelationshipModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapmirrorRelationshipModifyCollectionParamsWithHTTPClient(client *http.Client) *SnapmirrorRelationshipModifyCollectionParams {
	return &SnapmirrorRelationshipModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
SnapmirrorRelationshipModifyCollectionParams contains all the parameters to send to the API endpoint

	for the snapmirror relationship modify collection operation.

	Typically these are written to a http.Request.
*/
type SnapmirrorRelationshipModifyCollectionParams struct {

	/* BackoffLevel.

	   Filter by backoff_level
	*/
	BackoffLevel *string

	/* ConsistencyGroupFailoverErrorArgumentsCode.

	   Filter by consistency_group_failover.error.arguments.code
	*/
	ConsistencyGroupFailoverErrorArgumentsCode *string

	/* ConsistencyGroupFailoverErrorArgumentsMessage.

	   Filter by consistency_group_failover.error.arguments.message
	*/
	ConsistencyGroupFailoverErrorArgumentsMessage *string

	/* ConsistencyGroupFailoverErrorCode.

	   Filter by consistency_group_failover.error.code
	*/
	ConsistencyGroupFailoverErrorCode *string

	/* ConsistencyGroupFailoverErrorMessage.

	   Filter by consistency_group_failover.error.message
	*/
	ConsistencyGroupFailoverErrorMessage *string

	/* ConsistencyGroupFailoverState.

	   Filter by consistency_group_failover.state
	*/
	ConsistencyGroupFailoverState *string

	/* ConsistencyGroupFailoverStatusCode.

	   Filter by consistency_group_failover.status.code
	*/
	ConsistencyGroupFailoverStatusCode *string

	/* ConsistencyGroupFailoverStatusMessage.

	   Filter by consistency_group_failover.status.message
	*/
	ConsistencyGroupFailoverStatusMessage *string

	/* ConsistencyGroupFailoverType.

	   Filter by consistency_group_failover.type
	*/
	ConsistencyGroupFailoverType *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DestinationClusterName.

	   Filter by destination.cluster.name
	*/
	DestinationClusterName *string

	/* DestinationClusterUUID.

	   Filter by destination.cluster.uuid
	*/
	DestinationClusterUUID *string

	/* DestinationConsistencyGroupVolumesName.

	   Filter by destination.consistency_group_volumes.name
	*/
	DestinationConsistencyGroupVolumesName *string

	/* DestinationLunsName.

	   Filter by destination.luns.name
	*/
	DestinationLunsName *string

	/* DestinationLunsUUID.

	   Filter by destination.luns.uuid
	*/
	DestinationLunsUUID *string

	/* DestinationPath.

	   Filter by destination.path
	*/
	DestinationPath *string

	/* DestinationSvmName.

	   Filter by destination.svm.name
	*/
	DestinationSvmName *string

	/* DestinationSvmUUID.

	   Filter by destination.svm.uuid
	*/
	DestinationSvmUUID *string

	/* ExportedSnapshot.

	   Filter by exported_snapshot
	*/
	ExportedSnapshot *string

	/* Failback.

	   If this parameter is set while specifying the state as "snapmirrored", indicates recovery of the failed over SnapMirror relationship by preserving the data written on the destination endpoint when the SnapMirror relationship was in failed over state. This flag is only applicable to SVM-DR SnapMirror relationships.
	*/
	Failback *bool

	/* Failover.

	   If this parameter is set, validation and failover will occur to the SVM-DR SnapMirror relationship destination endpoint. Any other fields specified with this parameter will be ignored. This parameter is supported only for SVM-DR SnapMirror relationships.
	*/
	Failover *bool

	/* Force.

	   If this parameter is set while specifying the state as "broken_off", indicates a forced failover overriding the validation errors.
	*/
	Force *bool

	/* ForceFailover.

	   If this parameter is set, failover will occur to the SVM-DR SnapMirror relationship destination endpoint, overriding the validation errors. Any other fields specified with this parameter will be ignored. This parameter is supported only for SVM-DR SnapMirror relationships.
	*/
	ForceFailover *bool

	/* GroupType.

	   Filter by group_type
	*/
	GroupType *string

	/* Healthy.

	   Filter by healthy
	*/
	Healthy *bool

	/* IdentityPreservation.

	   Filter by identity_preservation
	*/
	IdentityPreservation *string

	/* Info.

	   Info specification
	*/
	Info SnapmirrorRelationshipModifyCollectionBody

	/* IoServingCopy.

	   Filter by io_serving_copy
	*/
	IoServingCopy *string

	/* LagTime.

	   Filter by lag_time
	*/
	LagTime *string

	/* LastTransferNetworkCompressionRatio.

	   Filter by last_transfer_network_compression_ratio
	*/
	LastTransferNetworkCompressionRatio *string

	/* LastTransferType.

	   Filter by last_transfer_type
	*/
	LastTransferType *string

	/* ListDestinationsOnly.

	   Set to true to show relationships from the source only.
	*/
	ListDestinationsOnly *bool

	/* MasterBiasActivatedSite.

	   Filter by master_bias_activated_site
	*/
	MasterBiasActivatedSite *string

	/* PolicyName.

	   Filter by policy.name
	*/
	PolicyName *string

	/* PolicyType.

	   Filter by policy.type
	*/
	PolicyType *string

	/* PolicyUUID.

	   Filter by policy.uuid
	*/
	PolicyUUID *string

	/* PreferredSite.

	   Filter by preferred_site
	*/
	PreferredSite *string

	/* Restore.

	   Filter by restore
	*/
	Restore *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SourceClusterName.

	   Filter by source.cluster.name
	*/
	SourceClusterName *string

	/* SourceClusterUUID.

	   Filter by source.cluster.uuid
	*/
	SourceClusterUUID *string

	/* SourceConsistencyGroupVolumesName.

	   Filter by source.consistency_group_volumes.name
	*/
	SourceConsistencyGroupVolumesName *string

	/* SourceLunsName.

	   Filter by source.luns.name
	*/
	SourceLunsName *string

	/* SourceLunsUUID.

	   Filter by source.luns.uuid
	*/
	SourceLunsUUID *string

	/* SourcePath.

	   Filter by source.path
	*/
	SourcePath *string

	/* SourceSvmName.

	   Filter by source.svm.name
	*/
	SourceSvmName *string

	/* SourceSvmUUID.

	   Filter by source.svm.uuid
	*/
	SourceSvmUUID *string

	/* State.

	   Filter by state
	*/
	State *string

	/* SvmdrVolumesName.

	   Filter by svmdr_volumes.name
	*/
	SvmdrVolumesName *string

	/* Throttle.

	   Filter by throttle
	*/
	Throttle *int64

	/* TotalTransferBytes.

	   Filter by total_transfer_bytes
	*/
	TotalTransferBytes *int64

	/* TotalTransferDuration.

	   Filter by total_transfer_duration
	*/
	TotalTransferDuration *string

	/* TransferBytesTransferred.

	   Filter by transfer.bytes_transferred
	*/
	TransferBytesTransferred *int64

	/* TransferEndTime.

	   Filter by transfer.end_time
	*/
	TransferEndTime *string

	/* TransferLastUpdatedTime.

	   Filter by transfer.last_updated_time
	*/
	TransferLastUpdatedTime *string

	/* TransferState.

	   Filter by transfer.state
	*/
	TransferState *string

	/* TransferTotalDuration.

	   Filter by transfer.total_duration
	*/
	TransferTotalDuration *string

	/* TransferType.

	   Filter by transfer.type
	*/
	TransferType *string

	/* TransferUUID.

	   Filter by transfer.uuid
	*/
	TransferUUID *string

	/* TransferScheduleName.

	   Filter by transfer_schedule.name
	*/
	TransferScheduleName *string

	/* TransferScheduleUUID.

	   Filter by transfer_schedule.uuid
	*/
	TransferScheduleUUID *string

	/* UnhealthyReasonArguments.

	   Filter by unhealthy_reason.arguments
	*/
	UnhealthyReasonArguments *string

	/* UnhealthyReasonCode.

	   Filter by unhealthy_reason.code
	*/
	UnhealthyReasonCode *string

	/* UnhealthyReasonMessage.

	   Filter by unhealthy_reason.message
	*/
	UnhealthyReasonMessage *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* ValidateOnly.

	   Validate the operation and its parameters, without actually performing the operation.
	*/
	ValidateOnly *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapmirror relationship modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorRelationshipModifyCollectionParams) WithDefaults() *SnapmirrorRelationshipModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapmirror relationship modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorRelationshipModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		failbackDefault = bool(false)

		failoverDefault = bool(false)

		forceDefault = bool(false)

		forceFailoverDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SnapmirrorRelationshipModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		Failback:          &failbackDefault,
		Failover:          &failoverDefault,
		Force:             &forceDefault,
		ForceFailover:     &forceFailoverDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTimeout(timeout time.Duration) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithContext(ctx context.Context) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithHTTPClient(client *http.Client) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBackoffLevel adds the backoffLevel to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithBackoffLevel(backoffLevel *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetBackoffLevel(backoffLevel)
	return o
}

// SetBackoffLevel adds the backoffLevel to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetBackoffLevel(backoffLevel *string) {
	o.BackoffLevel = backoffLevel
}

// WithConsistencyGroupFailoverErrorArgumentsCode adds the consistencyGroupFailoverErrorArgumentsCode to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithConsistencyGroupFailoverErrorArgumentsCode(consistencyGroupFailoverErrorArgumentsCode *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetConsistencyGroupFailoverErrorArgumentsCode(consistencyGroupFailoverErrorArgumentsCode)
	return o
}

// SetConsistencyGroupFailoverErrorArgumentsCode adds the consistencyGroupFailoverErrorArgumentsCode to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetConsistencyGroupFailoverErrorArgumentsCode(consistencyGroupFailoverErrorArgumentsCode *string) {
	o.ConsistencyGroupFailoverErrorArgumentsCode = consistencyGroupFailoverErrorArgumentsCode
}

// WithConsistencyGroupFailoverErrorArgumentsMessage adds the consistencyGroupFailoverErrorArgumentsMessage to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithConsistencyGroupFailoverErrorArgumentsMessage(consistencyGroupFailoverErrorArgumentsMessage *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetConsistencyGroupFailoverErrorArgumentsMessage(consistencyGroupFailoverErrorArgumentsMessage)
	return o
}

// SetConsistencyGroupFailoverErrorArgumentsMessage adds the consistencyGroupFailoverErrorArgumentsMessage to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetConsistencyGroupFailoverErrorArgumentsMessage(consistencyGroupFailoverErrorArgumentsMessage *string) {
	o.ConsistencyGroupFailoverErrorArgumentsMessage = consistencyGroupFailoverErrorArgumentsMessage
}

// WithConsistencyGroupFailoverErrorCode adds the consistencyGroupFailoverErrorCode to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithConsistencyGroupFailoverErrorCode(consistencyGroupFailoverErrorCode *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetConsistencyGroupFailoverErrorCode(consistencyGroupFailoverErrorCode)
	return o
}

// SetConsistencyGroupFailoverErrorCode adds the consistencyGroupFailoverErrorCode to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetConsistencyGroupFailoverErrorCode(consistencyGroupFailoverErrorCode *string) {
	o.ConsistencyGroupFailoverErrorCode = consistencyGroupFailoverErrorCode
}

// WithConsistencyGroupFailoverErrorMessage adds the consistencyGroupFailoverErrorMessage to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithConsistencyGroupFailoverErrorMessage(consistencyGroupFailoverErrorMessage *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetConsistencyGroupFailoverErrorMessage(consistencyGroupFailoverErrorMessage)
	return o
}

// SetConsistencyGroupFailoverErrorMessage adds the consistencyGroupFailoverErrorMessage to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetConsistencyGroupFailoverErrorMessage(consistencyGroupFailoverErrorMessage *string) {
	o.ConsistencyGroupFailoverErrorMessage = consistencyGroupFailoverErrorMessage
}

// WithConsistencyGroupFailoverState adds the consistencyGroupFailoverState to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithConsistencyGroupFailoverState(consistencyGroupFailoverState *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetConsistencyGroupFailoverState(consistencyGroupFailoverState)
	return o
}

// SetConsistencyGroupFailoverState adds the consistencyGroupFailoverState to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetConsistencyGroupFailoverState(consistencyGroupFailoverState *string) {
	o.ConsistencyGroupFailoverState = consistencyGroupFailoverState
}

// WithConsistencyGroupFailoverStatusCode adds the consistencyGroupFailoverStatusCode to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithConsistencyGroupFailoverStatusCode(consistencyGroupFailoverStatusCode *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetConsistencyGroupFailoverStatusCode(consistencyGroupFailoverStatusCode)
	return o
}

// SetConsistencyGroupFailoverStatusCode adds the consistencyGroupFailoverStatusCode to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetConsistencyGroupFailoverStatusCode(consistencyGroupFailoverStatusCode *string) {
	o.ConsistencyGroupFailoverStatusCode = consistencyGroupFailoverStatusCode
}

// WithConsistencyGroupFailoverStatusMessage adds the consistencyGroupFailoverStatusMessage to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithConsistencyGroupFailoverStatusMessage(consistencyGroupFailoverStatusMessage *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetConsistencyGroupFailoverStatusMessage(consistencyGroupFailoverStatusMessage)
	return o
}

// SetConsistencyGroupFailoverStatusMessage adds the consistencyGroupFailoverStatusMessage to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetConsistencyGroupFailoverStatusMessage(consistencyGroupFailoverStatusMessage *string) {
	o.ConsistencyGroupFailoverStatusMessage = consistencyGroupFailoverStatusMessage
}

// WithConsistencyGroupFailoverType adds the consistencyGroupFailoverType to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithConsistencyGroupFailoverType(consistencyGroupFailoverType *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetConsistencyGroupFailoverType(consistencyGroupFailoverType)
	return o
}

// SetConsistencyGroupFailoverType adds the consistencyGroupFailoverType to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetConsistencyGroupFailoverType(consistencyGroupFailoverType *string) {
	o.ConsistencyGroupFailoverType = consistencyGroupFailoverType
}

// WithContinueOnFailure adds the continueOnFailure to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDestinationClusterName adds the destinationClusterName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithDestinationClusterName(destinationClusterName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetDestinationClusterName(destinationClusterName)
	return o
}

// SetDestinationClusterName adds the destinationClusterName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetDestinationClusterName(destinationClusterName *string) {
	o.DestinationClusterName = destinationClusterName
}

// WithDestinationClusterUUID adds the destinationClusterUUID to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithDestinationClusterUUID(destinationClusterUUID *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetDestinationClusterUUID(destinationClusterUUID)
	return o
}

// SetDestinationClusterUUID adds the destinationClusterUuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetDestinationClusterUUID(destinationClusterUUID *string) {
	o.DestinationClusterUUID = destinationClusterUUID
}

// WithDestinationConsistencyGroupVolumesName adds the destinationConsistencyGroupVolumesName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithDestinationConsistencyGroupVolumesName(destinationConsistencyGroupVolumesName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetDestinationConsistencyGroupVolumesName(destinationConsistencyGroupVolumesName)
	return o
}

// SetDestinationConsistencyGroupVolumesName adds the destinationConsistencyGroupVolumesName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetDestinationConsistencyGroupVolumesName(destinationConsistencyGroupVolumesName *string) {
	o.DestinationConsistencyGroupVolumesName = destinationConsistencyGroupVolumesName
}

// WithDestinationLunsName adds the destinationLunsName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithDestinationLunsName(destinationLunsName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetDestinationLunsName(destinationLunsName)
	return o
}

// SetDestinationLunsName adds the destinationLunsName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetDestinationLunsName(destinationLunsName *string) {
	o.DestinationLunsName = destinationLunsName
}

// WithDestinationLunsUUID adds the destinationLunsUUID to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithDestinationLunsUUID(destinationLunsUUID *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetDestinationLunsUUID(destinationLunsUUID)
	return o
}

// SetDestinationLunsUUID adds the destinationLunsUuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetDestinationLunsUUID(destinationLunsUUID *string) {
	o.DestinationLunsUUID = destinationLunsUUID
}

// WithDestinationPath adds the destinationPath to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithDestinationPath(destinationPath *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetDestinationPath(destinationPath)
	return o
}

// SetDestinationPath adds the destinationPath to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetDestinationPath(destinationPath *string) {
	o.DestinationPath = destinationPath
}

// WithDestinationSvmName adds the destinationSvmName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithDestinationSvmName(destinationSvmName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetDestinationSvmName(destinationSvmName)
	return o
}

// SetDestinationSvmName adds the destinationSvmName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetDestinationSvmName(destinationSvmName *string) {
	o.DestinationSvmName = destinationSvmName
}

// WithDestinationSvmUUID adds the destinationSvmUUID to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithDestinationSvmUUID(destinationSvmUUID *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetDestinationSvmUUID(destinationSvmUUID)
	return o
}

// SetDestinationSvmUUID adds the destinationSvmUuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetDestinationSvmUUID(destinationSvmUUID *string) {
	o.DestinationSvmUUID = destinationSvmUUID
}

// WithExportedSnapshot adds the exportedSnapshot to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithExportedSnapshot(exportedSnapshot *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetExportedSnapshot(exportedSnapshot)
	return o
}

// SetExportedSnapshot adds the exportedSnapshot to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetExportedSnapshot(exportedSnapshot *string) {
	o.ExportedSnapshot = exportedSnapshot
}

// WithFailback adds the failback to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithFailback(failback *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetFailback(failback)
	return o
}

// SetFailback adds the failback to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetFailback(failback *bool) {
	o.Failback = failback
}

// WithFailover adds the failover to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithFailover(failover *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetFailover(failover)
	return o
}

// SetFailover adds the failover to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetFailover(failover *bool) {
	o.Failover = failover
}

// WithForce adds the force to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithForce(force *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetForce(force *bool) {
	o.Force = force
}

// WithForceFailover adds the forceFailover to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithForceFailover(forceFailover *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetForceFailover(forceFailover)
	return o
}

// SetForceFailover adds the forceFailover to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetForceFailover(forceFailover *bool) {
	o.ForceFailover = forceFailover
}

// WithGroupType adds the groupType to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithGroupType(groupType *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetGroupType(groupType)
	return o
}

// SetGroupType adds the groupType to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetGroupType(groupType *string) {
	o.GroupType = groupType
}

// WithHealthy adds the healthy to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithHealthy(healthy *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetHealthy(healthy)
	return o
}

// SetHealthy adds the healthy to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetHealthy(healthy *bool) {
	o.Healthy = healthy
}

// WithIdentityPreservation adds the identityPreservation to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithIdentityPreservation(identityPreservation *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetIdentityPreservation(identityPreservation)
	return o
}

// SetIdentityPreservation adds the identityPreservation to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetIdentityPreservation(identityPreservation *string) {
	o.IdentityPreservation = identityPreservation
}

// WithInfo adds the info to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithInfo(info SnapmirrorRelationshipModifyCollectionBody) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetInfo(info SnapmirrorRelationshipModifyCollectionBody) {
	o.Info = info
}

// WithIoServingCopy adds the ioServingCopy to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithIoServingCopy(ioServingCopy *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetIoServingCopy(ioServingCopy)
	return o
}

// SetIoServingCopy adds the ioServingCopy to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetIoServingCopy(ioServingCopy *string) {
	o.IoServingCopy = ioServingCopy
}

// WithLagTime adds the lagTime to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithLagTime(lagTime *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetLagTime(lagTime)
	return o
}

// SetLagTime adds the lagTime to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetLagTime(lagTime *string) {
	o.LagTime = lagTime
}

// WithLastTransferNetworkCompressionRatio adds the lastTransferNetworkCompressionRatio to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithLastTransferNetworkCompressionRatio(lastTransferNetworkCompressionRatio *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetLastTransferNetworkCompressionRatio(lastTransferNetworkCompressionRatio)
	return o
}

// SetLastTransferNetworkCompressionRatio adds the lastTransferNetworkCompressionRatio to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetLastTransferNetworkCompressionRatio(lastTransferNetworkCompressionRatio *string) {
	o.LastTransferNetworkCompressionRatio = lastTransferNetworkCompressionRatio
}

// WithLastTransferType adds the lastTransferType to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithLastTransferType(lastTransferType *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetLastTransferType(lastTransferType)
	return o
}

// SetLastTransferType adds the lastTransferType to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetLastTransferType(lastTransferType *string) {
	o.LastTransferType = lastTransferType
}

// WithListDestinationsOnly adds the listDestinationsOnly to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithListDestinationsOnly(listDestinationsOnly *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetListDestinationsOnly(listDestinationsOnly)
	return o
}

// SetListDestinationsOnly adds the listDestinationsOnly to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetListDestinationsOnly(listDestinationsOnly *bool) {
	o.ListDestinationsOnly = listDestinationsOnly
}

// WithMasterBiasActivatedSite adds the masterBiasActivatedSite to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithMasterBiasActivatedSite(masterBiasActivatedSite *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetMasterBiasActivatedSite(masterBiasActivatedSite)
	return o
}

// SetMasterBiasActivatedSite adds the masterBiasActivatedSite to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetMasterBiasActivatedSite(masterBiasActivatedSite *string) {
	o.MasterBiasActivatedSite = masterBiasActivatedSite
}

// WithPolicyName adds the policyName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithPolicyName(policyName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetPolicyName(policyName)
	return o
}

// SetPolicyName adds the policyName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetPolicyName(policyName *string) {
	o.PolicyName = policyName
}

// WithPolicyType adds the policyType to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithPolicyType(policyType *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetPolicyType(policyType)
	return o
}

// SetPolicyType adds the policyType to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetPolicyType(policyType *string) {
	o.PolicyType = policyType
}

// WithPolicyUUID adds the policyUUID to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithPolicyUUID(policyUUID *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetPolicyUUID(policyUUID)
	return o
}

// SetPolicyUUID adds the policyUuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetPolicyUUID(policyUUID *string) {
	o.PolicyUUID = policyUUID
}

// WithPreferredSite adds the preferredSite to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithPreferredSite(preferredSite *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetPreferredSite(preferredSite)
	return o
}

// SetPreferredSite adds the preferredSite to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetPreferredSite(preferredSite *string) {
	o.PreferredSite = preferredSite
}

// WithRestore adds the restore to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithRestore(restore *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetRestore(restore)
	return o
}

// SetRestore adds the restore to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetRestore(restore *bool) {
	o.Restore = restore
}

// WithReturnRecords adds the returnRecords to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithReturnRecords(returnRecords *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithSerialRecords(serialRecords *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSourceClusterName adds the sourceClusterName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithSourceClusterName(sourceClusterName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetSourceClusterName(sourceClusterName)
	return o
}

// SetSourceClusterName adds the sourceClusterName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetSourceClusterName(sourceClusterName *string) {
	o.SourceClusterName = sourceClusterName
}

// WithSourceClusterUUID adds the sourceClusterUUID to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithSourceClusterUUID(sourceClusterUUID *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetSourceClusterUUID(sourceClusterUUID)
	return o
}

// SetSourceClusterUUID adds the sourceClusterUuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetSourceClusterUUID(sourceClusterUUID *string) {
	o.SourceClusterUUID = sourceClusterUUID
}

// WithSourceConsistencyGroupVolumesName adds the sourceConsistencyGroupVolumesName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithSourceConsistencyGroupVolumesName(sourceConsistencyGroupVolumesName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetSourceConsistencyGroupVolumesName(sourceConsistencyGroupVolumesName)
	return o
}

// SetSourceConsistencyGroupVolumesName adds the sourceConsistencyGroupVolumesName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetSourceConsistencyGroupVolumesName(sourceConsistencyGroupVolumesName *string) {
	o.SourceConsistencyGroupVolumesName = sourceConsistencyGroupVolumesName
}

// WithSourceLunsName adds the sourceLunsName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithSourceLunsName(sourceLunsName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetSourceLunsName(sourceLunsName)
	return o
}

// SetSourceLunsName adds the sourceLunsName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetSourceLunsName(sourceLunsName *string) {
	o.SourceLunsName = sourceLunsName
}

// WithSourceLunsUUID adds the sourceLunsUUID to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithSourceLunsUUID(sourceLunsUUID *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetSourceLunsUUID(sourceLunsUUID)
	return o
}

// SetSourceLunsUUID adds the sourceLunsUuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetSourceLunsUUID(sourceLunsUUID *string) {
	o.SourceLunsUUID = sourceLunsUUID
}

// WithSourcePath adds the sourcePath to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithSourcePath(sourcePath *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetSourcePath(sourcePath)
	return o
}

// SetSourcePath adds the sourcePath to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetSourcePath(sourcePath *string) {
	o.SourcePath = sourcePath
}

// WithSourceSvmName adds the sourceSvmName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithSourceSvmName(sourceSvmName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetSourceSvmName(sourceSvmName)
	return o
}

// SetSourceSvmName adds the sourceSvmName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetSourceSvmName(sourceSvmName *string) {
	o.SourceSvmName = sourceSvmName
}

// WithSourceSvmUUID adds the sourceSvmUUID to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithSourceSvmUUID(sourceSvmUUID *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetSourceSvmUUID(sourceSvmUUID)
	return o
}

// SetSourceSvmUUID adds the sourceSvmUuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetSourceSvmUUID(sourceSvmUUID *string) {
	o.SourceSvmUUID = sourceSvmUUID
}

// WithState adds the state to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithState(state *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithSvmdrVolumesName adds the svmdrVolumesName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithSvmdrVolumesName(svmdrVolumesName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetSvmdrVolumesName(svmdrVolumesName)
	return o
}

// SetSvmdrVolumesName adds the svmdrVolumesName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetSvmdrVolumesName(svmdrVolumesName *string) {
	o.SvmdrVolumesName = svmdrVolumesName
}

// WithThrottle adds the throttle to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithThrottle(throttle *int64) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetThrottle(throttle)
	return o
}

// SetThrottle adds the throttle to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetThrottle(throttle *int64) {
	o.Throttle = throttle
}

// WithTotalTransferBytes adds the totalTransferBytes to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTotalTransferBytes(totalTransferBytes *int64) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTotalTransferBytes(totalTransferBytes)
	return o
}

// SetTotalTransferBytes adds the totalTransferBytes to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTotalTransferBytes(totalTransferBytes *int64) {
	o.TotalTransferBytes = totalTransferBytes
}

// WithTotalTransferDuration adds the totalTransferDuration to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTotalTransferDuration(totalTransferDuration *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTotalTransferDuration(totalTransferDuration)
	return o
}

// SetTotalTransferDuration adds the totalTransferDuration to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTotalTransferDuration(totalTransferDuration *string) {
	o.TotalTransferDuration = totalTransferDuration
}

// WithTransferBytesTransferred adds the transferBytesTransferred to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTransferBytesTransferred(transferBytesTransferred *int64) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTransferBytesTransferred(transferBytesTransferred)
	return o
}

// SetTransferBytesTransferred adds the transferBytesTransferred to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTransferBytesTransferred(transferBytesTransferred *int64) {
	o.TransferBytesTransferred = transferBytesTransferred
}

// WithTransferEndTime adds the transferEndTime to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTransferEndTime(transferEndTime *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTransferEndTime(transferEndTime)
	return o
}

// SetTransferEndTime adds the transferEndTime to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTransferEndTime(transferEndTime *string) {
	o.TransferEndTime = transferEndTime
}

// WithTransferLastUpdatedTime adds the transferLastUpdatedTime to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTransferLastUpdatedTime(transferLastUpdatedTime *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTransferLastUpdatedTime(transferLastUpdatedTime)
	return o
}

// SetTransferLastUpdatedTime adds the transferLastUpdatedTime to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTransferLastUpdatedTime(transferLastUpdatedTime *string) {
	o.TransferLastUpdatedTime = transferLastUpdatedTime
}

// WithTransferState adds the transferState to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTransferState(transferState *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTransferState(transferState)
	return o
}

// SetTransferState adds the transferState to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTransferState(transferState *string) {
	o.TransferState = transferState
}

// WithTransferTotalDuration adds the transferTotalDuration to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTransferTotalDuration(transferTotalDuration *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTransferTotalDuration(transferTotalDuration)
	return o
}

// SetTransferTotalDuration adds the transferTotalDuration to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTransferTotalDuration(transferTotalDuration *string) {
	o.TransferTotalDuration = transferTotalDuration
}

// WithTransferType adds the transferType to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTransferType(transferType *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTransferType(transferType)
	return o
}

// SetTransferType adds the transferType to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTransferType(transferType *string) {
	o.TransferType = transferType
}

// WithTransferUUID adds the transferUUID to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTransferUUID(transferUUID *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTransferUUID(transferUUID)
	return o
}

// SetTransferUUID adds the transferUuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTransferUUID(transferUUID *string) {
	o.TransferUUID = transferUUID
}

// WithTransferScheduleName adds the transferScheduleName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTransferScheduleName(transferScheduleName *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTransferScheduleName(transferScheduleName)
	return o
}

// SetTransferScheduleName adds the transferScheduleName to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTransferScheduleName(transferScheduleName *string) {
	o.TransferScheduleName = transferScheduleName
}

// WithTransferScheduleUUID adds the transferScheduleUUID to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithTransferScheduleUUID(transferScheduleUUID *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetTransferScheduleUUID(transferScheduleUUID)
	return o
}

// SetTransferScheduleUUID adds the transferScheduleUuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetTransferScheduleUUID(transferScheduleUUID *string) {
	o.TransferScheduleUUID = transferScheduleUUID
}

// WithUnhealthyReasonArguments adds the unhealthyReasonArguments to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithUnhealthyReasonArguments(unhealthyReasonArguments *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetUnhealthyReasonArguments(unhealthyReasonArguments)
	return o
}

// SetUnhealthyReasonArguments adds the unhealthyReasonArguments to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetUnhealthyReasonArguments(unhealthyReasonArguments *string) {
	o.UnhealthyReasonArguments = unhealthyReasonArguments
}

// WithUnhealthyReasonCode adds the unhealthyReasonCode to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithUnhealthyReasonCode(unhealthyReasonCode *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetUnhealthyReasonCode(unhealthyReasonCode)
	return o
}

// SetUnhealthyReasonCode adds the unhealthyReasonCode to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetUnhealthyReasonCode(unhealthyReasonCode *string) {
	o.UnhealthyReasonCode = unhealthyReasonCode
}

// WithUnhealthyReasonMessage adds the unhealthyReasonMessage to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithUnhealthyReasonMessage(unhealthyReasonMessage *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetUnhealthyReasonMessage(unhealthyReasonMessage)
	return o
}

// SetUnhealthyReasonMessage adds the unhealthyReasonMessage to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetUnhealthyReasonMessage(unhealthyReasonMessage *string) {
	o.UnhealthyReasonMessage = unhealthyReasonMessage
}

// WithUUID adds the uuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithUUID(uuid *string) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithValidateOnly adds the validateOnly to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) WithValidateOnly(validateOnly *bool) *SnapmirrorRelationshipModifyCollectionParams {
	o.SetValidateOnly(validateOnly)
	return o
}

// SetValidateOnly adds the validateOnly to the snapmirror relationship modify collection params
func (o *SnapmirrorRelationshipModifyCollectionParams) SetValidateOnly(validateOnly *bool) {
	o.ValidateOnly = validateOnly
}

// WriteToRequest writes these params to a swagger request
func (o *SnapmirrorRelationshipModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BackoffLevel != nil {

		// query param backoff_level
		var qrBackoffLevel string

		if o.BackoffLevel != nil {
			qrBackoffLevel = *o.BackoffLevel
		}
		qBackoffLevel := qrBackoffLevel
		if qBackoffLevel != "" {

			if err := r.SetQueryParam("backoff_level", qBackoffLevel); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupFailoverErrorArgumentsCode != nil {

		// query param consistency_group_failover.error.arguments.code
		var qrConsistencyGroupFailoverErrorArgumentsCode string

		if o.ConsistencyGroupFailoverErrorArgumentsCode != nil {
			qrConsistencyGroupFailoverErrorArgumentsCode = *o.ConsistencyGroupFailoverErrorArgumentsCode
		}
		qConsistencyGroupFailoverErrorArgumentsCode := qrConsistencyGroupFailoverErrorArgumentsCode
		if qConsistencyGroupFailoverErrorArgumentsCode != "" {

			if err := r.SetQueryParam("consistency_group_failover.error.arguments.code", qConsistencyGroupFailoverErrorArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupFailoverErrorArgumentsMessage != nil {

		// query param consistency_group_failover.error.arguments.message
		var qrConsistencyGroupFailoverErrorArgumentsMessage string

		if o.ConsistencyGroupFailoverErrorArgumentsMessage != nil {
			qrConsistencyGroupFailoverErrorArgumentsMessage = *o.ConsistencyGroupFailoverErrorArgumentsMessage
		}
		qConsistencyGroupFailoverErrorArgumentsMessage := qrConsistencyGroupFailoverErrorArgumentsMessage
		if qConsistencyGroupFailoverErrorArgumentsMessage != "" {

			if err := r.SetQueryParam("consistency_group_failover.error.arguments.message", qConsistencyGroupFailoverErrorArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupFailoverErrorCode != nil {

		// query param consistency_group_failover.error.code
		var qrConsistencyGroupFailoverErrorCode string

		if o.ConsistencyGroupFailoverErrorCode != nil {
			qrConsistencyGroupFailoverErrorCode = *o.ConsistencyGroupFailoverErrorCode
		}
		qConsistencyGroupFailoverErrorCode := qrConsistencyGroupFailoverErrorCode
		if qConsistencyGroupFailoverErrorCode != "" {

			if err := r.SetQueryParam("consistency_group_failover.error.code", qConsistencyGroupFailoverErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupFailoverErrorMessage != nil {

		// query param consistency_group_failover.error.message
		var qrConsistencyGroupFailoverErrorMessage string

		if o.ConsistencyGroupFailoverErrorMessage != nil {
			qrConsistencyGroupFailoverErrorMessage = *o.ConsistencyGroupFailoverErrorMessage
		}
		qConsistencyGroupFailoverErrorMessage := qrConsistencyGroupFailoverErrorMessage
		if qConsistencyGroupFailoverErrorMessage != "" {

			if err := r.SetQueryParam("consistency_group_failover.error.message", qConsistencyGroupFailoverErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupFailoverState != nil {

		// query param consistency_group_failover.state
		var qrConsistencyGroupFailoverState string

		if o.ConsistencyGroupFailoverState != nil {
			qrConsistencyGroupFailoverState = *o.ConsistencyGroupFailoverState
		}
		qConsistencyGroupFailoverState := qrConsistencyGroupFailoverState
		if qConsistencyGroupFailoverState != "" {

			if err := r.SetQueryParam("consistency_group_failover.state", qConsistencyGroupFailoverState); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupFailoverStatusCode != nil {

		// query param consistency_group_failover.status.code
		var qrConsistencyGroupFailoverStatusCode string

		if o.ConsistencyGroupFailoverStatusCode != nil {
			qrConsistencyGroupFailoverStatusCode = *o.ConsistencyGroupFailoverStatusCode
		}
		qConsistencyGroupFailoverStatusCode := qrConsistencyGroupFailoverStatusCode
		if qConsistencyGroupFailoverStatusCode != "" {

			if err := r.SetQueryParam("consistency_group_failover.status.code", qConsistencyGroupFailoverStatusCode); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupFailoverStatusMessage != nil {

		// query param consistency_group_failover.status.message
		var qrConsistencyGroupFailoverStatusMessage string

		if o.ConsistencyGroupFailoverStatusMessage != nil {
			qrConsistencyGroupFailoverStatusMessage = *o.ConsistencyGroupFailoverStatusMessage
		}
		qConsistencyGroupFailoverStatusMessage := qrConsistencyGroupFailoverStatusMessage
		if qConsistencyGroupFailoverStatusMessage != "" {

			if err := r.SetQueryParam("consistency_group_failover.status.message", qConsistencyGroupFailoverStatusMessage); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupFailoverType != nil {

		// query param consistency_group_failover.type
		var qrConsistencyGroupFailoverType string

		if o.ConsistencyGroupFailoverType != nil {
			qrConsistencyGroupFailoverType = *o.ConsistencyGroupFailoverType
		}
		qConsistencyGroupFailoverType := qrConsistencyGroupFailoverType
		if qConsistencyGroupFailoverType != "" {

			if err := r.SetQueryParam("consistency_group_failover.type", qConsistencyGroupFailoverType); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DestinationClusterName != nil {

		// query param destination.cluster.name
		var qrDestinationClusterName string

		if o.DestinationClusterName != nil {
			qrDestinationClusterName = *o.DestinationClusterName
		}
		qDestinationClusterName := qrDestinationClusterName
		if qDestinationClusterName != "" {

			if err := r.SetQueryParam("destination.cluster.name", qDestinationClusterName); err != nil {
				return err
			}
		}
	}

	if o.DestinationClusterUUID != nil {

		// query param destination.cluster.uuid
		var qrDestinationClusterUUID string

		if o.DestinationClusterUUID != nil {
			qrDestinationClusterUUID = *o.DestinationClusterUUID
		}
		qDestinationClusterUUID := qrDestinationClusterUUID
		if qDestinationClusterUUID != "" {

			if err := r.SetQueryParam("destination.cluster.uuid", qDestinationClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.DestinationConsistencyGroupVolumesName != nil {

		// query param destination.consistency_group_volumes.name
		var qrDestinationConsistencyGroupVolumesName string

		if o.DestinationConsistencyGroupVolumesName != nil {
			qrDestinationConsistencyGroupVolumesName = *o.DestinationConsistencyGroupVolumesName
		}
		qDestinationConsistencyGroupVolumesName := qrDestinationConsistencyGroupVolumesName
		if qDestinationConsistencyGroupVolumesName != "" {

			if err := r.SetQueryParam("destination.consistency_group_volumes.name", qDestinationConsistencyGroupVolumesName); err != nil {
				return err
			}
		}
	}

	if o.DestinationLunsName != nil {

		// query param destination.luns.name
		var qrDestinationLunsName string

		if o.DestinationLunsName != nil {
			qrDestinationLunsName = *o.DestinationLunsName
		}
		qDestinationLunsName := qrDestinationLunsName
		if qDestinationLunsName != "" {

			if err := r.SetQueryParam("destination.luns.name", qDestinationLunsName); err != nil {
				return err
			}
		}
	}

	if o.DestinationLunsUUID != nil {

		// query param destination.luns.uuid
		var qrDestinationLunsUUID string

		if o.DestinationLunsUUID != nil {
			qrDestinationLunsUUID = *o.DestinationLunsUUID
		}
		qDestinationLunsUUID := qrDestinationLunsUUID
		if qDestinationLunsUUID != "" {

			if err := r.SetQueryParam("destination.luns.uuid", qDestinationLunsUUID); err != nil {
				return err
			}
		}
	}

	if o.DestinationPath != nil {

		// query param destination.path
		var qrDestinationPath string

		if o.DestinationPath != nil {
			qrDestinationPath = *o.DestinationPath
		}
		qDestinationPath := qrDestinationPath
		if qDestinationPath != "" {

			if err := r.SetQueryParam("destination.path", qDestinationPath); err != nil {
				return err
			}
		}
	}

	if o.DestinationSvmName != nil {

		// query param destination.svm.name
		var qrDestinationSvmName string

		if o.DestinationSvmName != nil {
			qrDestinationSvmName = *o.DestinationSvmName
		}
		qDestinationSvmName := qrDestinationSvmName
		if qDestinationSvmName != "" {

			if err := r.SetQueryParam("destination.svm.name", qDestinationSvmName); err != nil {
				return err
			}
		}
	}

	if o.DestinationSvmUUID != nil {

		// query param destination.svm.uuid
		var qrDestinationSvmUUID string

		if o.DestinationSvmUUID != nil {
			qrDestinationSvmUUID = *o.DestinationSvmUUID
		}
		qDestinationSvmUUID := qrDestinationSvmUUID
		if qDestinationSvmUUID != "" {

			if err := r.SetQueryParam("destination.svm.uuid", qDestinationSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.ExportedSnapshot != nil {

		// query param exported_snapshot
		var qrExportedSnapshot string

		if o.ExportedSnapshot != nil {
			qrExportedSnapshot = *o.ExportedSnapshot
		}
		qExportedSnapshot := qrExportedSnapshot
		if qExportedSnapshot != "" {

			if err := r.SetQueryParam("exported_snapshot", qExportedSnapshot); err != nil {
				return err
			}
		}
	}

	if o.Failback != nil {

		// query param failback
		var qrFailback bool

		if o.Failback != nil {
			qrFailback = *o.Failback
		}
		qFailback := swag.FormatBool(qrFailback)
		if qFailback != "" {

			if err := r.SetQueryParam("failback", qFailback); err != nil {
				return err
			}
		}
	}

	if o.Failover != nil {

		// query param failover
		var qrFailover bool

		if o.Failover != nil {
			qrFailover = *o.Failover
		}
		qFailover := swag.FormatBool(qrFailover)
		if qFailover != "" {

			if err := r.SetQueryParam("failover", qFailover); err != nil {
				return err
			}
		}
	}

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	if o.ForceFailover != nil {

		// query param force-failover
		var qrForceFailover bool

		if o.ForceFailover != nil {
			qrForceFailover = *o.ForceFailover
		}
		qForceFailover := swag.FormatBool(qrForceFailover)
		if qForceFailover != "" {

			if err := r.SetQueryParam("force-failover", qForceFailover); err != nil {
				return err
			}
		}
	}

	if o.GroupType != nil {

		// query param group_type
		var qrGroupType string

		if o.GroupType != nil {
			qrGroupType = *o.GroupType
		}
		qGroupType := qrGroupType
		if qGroupType != "" {

			if err := r.SetQueryParam("group_type", qGroupType); err != nil {
				return err
			}
		}
	}

	if o.Healthy != nil {

		// query param healthy
		var qrHealthy bool

		if o.Healthy != nil {
			qrHealthy = *o.Healthy
		}
		qHealthy := swag.FormatBool(qrHealthy)
		if qHealthy != "" {

			if err := r.SetQueryParam("healthy", qHealthy); err != nil {
				return err
			}
		}
	}

	if o.IdentityPreservation != nil {

		// query param identity_preservation
		var qrIdentityPreservation string

		if o.IdentityPreservation != nil {
			qrIdentityPreservation = *o.IdentityPreservation
		}
		qIdentityPreservation := qrIdentityPreservation
		if qIdentityPreservation != "" {

			if err := r.SetQueryParam("identity_preservation", qIdentityPreservation); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IoServingCopy != nil {

		// query param io_serving_copy
		var qrIoServingCopy string

		if o.IoServingCopy != nil {
			qrIoServingCopy = *o.IoServingCopy
		}
		qIoServingCopy := qrIoServingCopy
		if qIoServingCopy != "" {

			if err := r.SetQueryParam("io_serving_copy", qIoServingCopy); err != nil {
				return err
			}
		}
	}

	if o.LagTime != nil {

		// query param lag_time
		var qrLagTime string

		if o.LagTime != nil {
			qrLagTime = *o.LagTime
		}
		qLagTime := qrLagTime
		if qLagTime != "" {

			if err := r.SetQueryParam("lag_time", qLagTime); err != nil {
				return err
			}
		}
	}

	if o.LastTransferNetworkCompressionRatio != nil {

		// query param last_transfer_network_compression_ratio
		var qrLastTransferNetworkCompressionRatio string

		if o.LastTransferNetworkCompressionRatio != nil {
			qrLastTransferNetworkCompressionRatio = *o.LastTransferNetworkCompressionRatio
		}
		qLastTransferNetworkCompressionRatio := qrLastTransferNetworkCompressionRatio
		if qLastTransferNetworkCompressionRatio != "" {

			if err := r.SetQueryParam("last_transfer_network_compression_ratio", qLastTransferNetworkCompressionRatio); err != nil {
				return err
			}
		}
	}

	if o.LastTransferType != nil {

		// query param last_transfer_type
		var qrLastTransferType string

		if o.LastTransferType != nil {
			qrLastTransferType = *o.LastTransferType
		}
		qLastTransferType := qrLastTransferType
		if qLastTransferType != "" {

			if err := r.SetQueryParam("last_transfer_type", qLastTransferType); err != nil {
				return err
			}
		}
	}

	if o.ListDestinationsOnly != nil {

		// query param list_destinations_only
		var qrListDestinationsOnly bool

		if o.ListDestinationsOnly != nil {
			qrListDestinationsOnly = *o.ListDestinationsOnly
		}
		qListDestinationsOnly := swag.FormatBool(qrListDestinationsOnly)
		if qListDestinationsOnly != "" {

			if err := r.SetQueryParam("list_destinations_only", qListDestinationsOnly); err != nil {
				return err
			}
		}
	}

	if o.MasterBiasActivatedSite != nil {

		// query param master_bias_activated_site
		var qrMasterBiasActivatedSite string

		if o.MasterBiasActivatedSite != nil {
			qrMasterBiasActivatedSite = *o.MasterBiasActivatedSite
		}
		qMasterBiasActivatedSite := qrMasterBiasActivatedSite
		if qMasterBiasActivatedSite != "" {

			if err := r.SetQueryParam("master_bias_activated_site", qMasterBiasActivatedSite); err != nil {
				return err
			}
		}
	}

	if o.PolicyName != nil {

		// query param policy.name
		var qrPolicyName string

		if o.PolicyName != nil {
			qrPolicyName = *o.PolicyName
		}
		qPolicyName := qrPolicyName
		if qPolicyName != "" {

			if err := r.SetQueryParam("policy.name", qPolicyName); err != nil {
				return err
			}
		}
	}

	if o.PolicyType != nil {

		// query param policy.type
		var qrPolicyType string

		if o.PolicyType != nil {
			qrPolicyType = *o.PolicyType
		}
		qPolicyType := qrPolicyType
		if qPolicyType != "" {

			if err := r.SetQueryParam("policy.type", qPolicyType); err != nil {
				return err
			}
		}
	}

	if o.PolicyUUID != nil {

		// query param policy.uuid
		var qrPolicyUUID string

		if o.PolicyUUID != nil {
			qrPolicyUUID = *o.PolicyUUID
		}
		qPolicyUUID := qrPolicyUUID
		if qPolicyUUID != "" {

			if err := r.SetQueryParam("policy.uuid", qPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.PreferredSite != nil {

		// query param preferred_site
		var qrPreferredSite string

		if o.PreferredSite != nil {
			qrPreferredSite = *o.PreferredSite
		}
		qPreferredSite := qrPreferredSite
		if qPreferredSite != "" {

			if err := r.SetQueryParam("preferred_site", qPreferredSite); err != nil {
				return err
			}
		}
	}

	if o.Restore != nil {

		// query param restore
		var qrRestore bool

		if o.Restore != nil {
			qrRestore = *o.Restore
		}
		qRestore := swag.FormatBool(qrRestore)
		if qRestore != "" {

			if err := r.SetQueryParam("restore", qRestore); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SourceClusterName != nil {

		// query param source.cluster.name
		var qrSourceClusterName string

		if o.SourceClusterName != nil {
			qrSourceClusterName = *o.SourceClusterName
		}
		qSourceClusterName := qrSourceClusterName
		if qSourceClusterName != "" {

			if err := r.SetQueryParam("source.cluster.name", qSourceClusterName); err != nil {
				return err
			}
		}
	}

	if o.SourceClusterUUID != nil {

		// query param source.cluster.uuid
		var qrSourceClusterUUID string

		if o.SourceClusterUUID != nil {
			qrSourceClusterUUID = *o.SourceClusterUUID
		}
		qSourceClusterUUID := qrSourceClusterUUID
		if qSourceClusterUUID != "" {

			if err := r.SetQueryParam("source.cluster.uuid", qSourceClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.SourceConsistencyGroupVolumesName != nil {

		// query param source.consistency_group_volumes.name
		var qrSourceConsistencyGroupVolumesName string

		if o.SourceConsistencyGroupVolumesName != nil {
			qrSourceConsistencyGroupVolumesName = *o.SourceConsistencyGroupVolumesName
		}
		qSourceConsistencyGroupVolumesName := qrSourceConsistencyGroupVolumesName
		if qSourceConsistencyGroupVolumesName != "" {

			if err := r.SetQueryParam("source.consistency_group_volumes.name", qSourceConsistencyGroupVolumesName); err != nil {
				return err
			}
		}
	}

	if o.SourceLunsName != nil {

		// query param source.luns.name
		var qrSourceLunsName string

		if o.SourceLunsName != nil {
			qrSourceLunsName = *o.SourceLunsName
		}
		qSourceLunsName := qrSourceLunsName
		if qSourceLunsName != "" {

			if err := r.SetQueryParam("source.luns.name", qSourceLunsName); err != nil {
				return err
			}
		}
	}

	if o.SourceLunsUUID != nil {

		// query param source.luns.uuid
		var qrSourceLunsUUID string

		if o.SourceLunsUUID != nil {
			qrSourceLunsUUID = *o.SourceLunsUUID
		}
		qSourceLunsUUID := qrSourceLunsUUID
		if qSourceLunsUUID != "" {

			if err := r.SetQueryParam("source.luns.uuid", qSourceLunsUUID); err != nil {
				return err
			}
		}
	}

	if o.SourcePath != nil {

		// query param source.path
		var qrSourcePath string

		if o.SourcePath != nil {
			qrSourcePath = *o.SourcePath
		}
		qSourcePath := qrSourcePath
		if qSourcePath != "" {

			if err := r.SetQueryParam("source.path", qSourcePath); err != nil {
				return err
			}
		}
	}

	if o.SourceSvmName != nil {

		// query param source.svm.name
		var qrSourceSvmName string

		if o.SourceSvmName != nil {
			qrSourceSvmName = *o.SourceSvmName
		}
		qSourceSvmName := qrSourceSvmName
		if qSourceSvmName != "" {

			if err := r.SetQueryParam("source.svm.name", qSourceSvmName); err != nil {
				return err
			}
		}
	}

	if o.SourceSvmUUID != nil {

		// query param source.svm.uuid
		var qrSourceSvmUUID string

		if o.SourceSvmUUID != nil {
			qrSourceSvmUUID = *o.SourceSvmUUID
		}
		qSourceSvmUUID := qrSourceSvmUUID
		if qSourceSvmUUID != "" {

			if err := r.SetQueryParam("source.svm.uuid", qSourceSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.SvmdrVolumesName != nil {

		// query param svmdr_volumes.name
		var qrSvmdrVolumesName string

		if o.SvmdrVolumesName != nil {
			qrSvmdrVolumesName = *o.SvmdrVolumesName
		}
		qSvmdrVolumesName := qrSvmdrVolumesName
		if qSvmdrVolumesName != "" {

			if err := r.SetQueryParam("svmdr_volumes.name", qSvmdrVolumesName); err != nil {
				return err
			}
		}
	}

	if o.Throttle != nil {

		// query param throttle
		var qrThrottle int64

		if o.Throttle != nil {
			qrThrottle = *o.Throttle
		}
		qThrottle := swag.FormatInt64(qrThrottle)
		if qThrottle != "" {

			if err := r.SetQueryParam("throttle", qThrottle); err != nil {
				return err
			}
		}
	}

	if o.TotalTransferBytes != nil {

		// query param total_transfer_bytes
		var qrTotalTransferBytes int64

		if o.TotalTransferBytes != nil {
			qrTotalTransferBytes = *o.TotalTransferBytes
		}
		qTotalTransferBytes := swag.FormatInt64(qrTotalTransferBytes)
		if qTotalTransferBytes != "" {

			if err := r.SetQueryParam("total_transfer_bytes", qTotalTransferBytes); err != nil {
				return err
			}
		}
	}

	if o.TotalTransferDuration != nil {

		// query param total_transfer_duration
		var qrTotalTransferDuration string

		if o.TotalTransferDuration != nil {
			qrTotalTransferDuration = *o.TotalTransferDuration
		}
		qTotalTransferDuration := qrTotalTransferDuration
		if qTotalTransferDuration != "" {

			if err := r.SetQueryParam("total_transfer_duration", qTotalTransferDuration); err != nil {
				return err
			}
		}
	}

	if o.TransferBytesTransferred != nil {

		// query param transfer.bytes_transferred
		var qrTransferBytesTransferred int64

		if o.TransferBytesTransferred != nil {
			qrTransferBytesTransferred = *o.TransferBytesTransferred
		}
		qTransferBytesTransferred := swag.FormatInt64(qrTransferBytesTransferred)
		if qTransferBytesTransferred != "" {

			if err := r.SetQueryParam("transfer.bytes_transferred", qTransferBytesTransferred); err != nil {
				return err
			}
		}
	}

	if o.TransferEndTime != nil {

		// query param transfer.end_time
		var qrTransferEndTime string

		if o.TransferEndTime != nil {
			qrTransferEndTime = *o.TransferEndTime
		}
		qTransferEndTime := qrTransferEndTime
		if qTransferEndTime != "" {

			if err := r.SetQueryParam("transfer.end_time", qTransferEndTime); err != nil {
				return err
			}
		}
	}

	if o.TransferLastUpdatedTime != nil {

		// query param transfer.last_updated_time
		var qrTransferLastUpdatedTime string

		if o.TransferLastUpdatedTime != nil {
			qrTransferLastUpdatedTime = *o.TransferLastUpdatedTime
		}
		qTransferLastUpdatedTime := qrTransferLastUpdatedTime
		if qTransferLastUpdatedTime != "" {

			if err := r.SetQueryParam("transfer.last_updated_time", qTransferLastUpdatedTime); err != nil {
				return err
			}
		}
	}

	if o.TransferState != nil {

		// query param transfer.state
		var qrTransferState string

		if o.TransferState != nil {
			qrTransferState = *o.TransferState
		}
		qTransferState := qrTransferState
		if qTransferState != "" {

			if err := r.SetQueryParam("transfer.state", qTransferState); err != nil {
				return err
			}
		}
	}

	if o.TransferTotalDuration != nil {

		// query param transfer.total_duration
		var qrTransferTotalDuration string

		if o.TransferTotalDuration != nil {
			qrTransferTotalDuration = *o.TransferTotalDuration
		}
		qTransferTotalDuration := qrTransferTotalDuration
		if qTransferTotalDuration != "" {

			if err := r.SetQueryParam("transfer.total_duration", qTransferTotalDuration); err != nil {
				return err
			}
		}
	}

	if o.TransferType != nil {

		// query param transfer.type
		var qrTransferType string

		if o.TransferType != nil {
			qrTransferType = *o.TransferType
		}
		qTransferType := qrTransferType
		if qTransferType != "" {

			if err := r.SetQueryParam("transfer.type", qTransferType); err != nil {
				return err
			}
		}
	}

	if o.TransferUUID != nil {

		// query param transfer.uuid
		var qrTransferUUID string

		if o.TransferUUID != nil {
			qrTransferUUID = *o.TransferUUID
		}
		qTransferUUID := qrTransferUUID
		if qTransferUUID != "" {

			if err := r.SetQueryParam("transfer.uuid", qTransferUUID); err != nil {
				return err
			}
		}
	}

	if o.TransferScheduleName != nil {

		// query param transfer_schedule.name
		var qrTransferScheduleName string

		if o.TransferScheduleName != nil {
			qrTransferScheduleName = *o.TransferScheduleName
		}
		qTransferScheduleName := qrTransferScheduleName
		if qTransferScheduleName != "" {

			if err := r.SetQueryParam("transfer_schedule.name", qTransferScheduleName); err != nil {
				return err
			}
		}
	}

	if o.TransferScheduleUUID != nil {

		// query param transfer_schedule.uuid
		var qrTransferScheduleUUID string

		if o.TransferScheduleUUID != nil {
			qrTransferScheduleUUID = *o.TransferScheduleUUID
		}
		qTransferScheduleUUID := qrTransferScheduleUUID
		if qTransferScheduleUUID != "" {

			if err := r.SetQueryParam("transfer_schedule.uuid", qTransferScheduleUUID); err != nil {
				return err
			}
		}
	}

	if o.UnhealthyReasonArguments != nil {

		// query param unhealthy_reason.arguments
		var qrUnhealthyReasonArguments string

		if o.UnhealthyReasonArguments != nil {
			qrUnhealthyReasonArguments = *o.UnhealthyReasonArguments
		}
		qUnhealthyReasonArguments := qrUnhealthyReasonArguments
		if qUnhealthyReasonArguments != "" {

			if err := r.SetQueryParam("unhealthy_reason.arguments", qUnhealthyReasonArguments); err != nil {
				return err
			}
		}
	}

	if o.UnhealthyReasonCode != nil {

		// query param unhealthy_reason.code
		var qrUnhealthyReasonCode string

		if o.UnhealthyReasonCode != nil {
			qrUnhealthyReasonCode = *o.UnhealthyReasonCode
		}
		qUnhealthyReasonCode := qrUnhealthyReasonCode
		if qUnhealthyReasonCode != "" {

			if err := r.SetQueryParam("unhealthy_reason.code", qUnhealthyReasonCode); err != nil {
				return err
			}
		}
	}

	if o.UnhealthyReasonMessage != nil {

		// query param unhealthy_reason.message
		var qrUnhealthyReasonMessage string

		if o.UnhealthyReasonMessage != nil {
			qrUnhealthyReasonMessage = *o.UnhealthyReasonMessage
		}
		qUnhealthyReasonMessage := qrUnhealthyReasonMessage
		if qUnhealthyReasonMessage != "" {

			if err := r.SetQueryParam("unhealthy_reason.message", qUnhealthyReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.ValidateOnly != nil {

		// query param validate_only
		var qrValidateOnly bool

		if o.ValidateOnly != nil {
			qrValidateOnly = *o.ValidateOnly
		}
		qValidateOnly := swag.FormatBool(qrValidateOnly)
		if qValidateOnly != "" {

			if err := r.SetQueryParam("validate_only", qValidateOnly); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
