// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorRelationshipModifyCollectionReader is a Reader for the SnapmirrorRelationshipModifyCollection structure.
type SnapmirrorRelationshipModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorRelationshipModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapmirrorRelationshipModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSnapmirrorRelationshipModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorRelationshipModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorRelationshipModifyCollectionOK creates a SnapmirrorRelationshipModifyCollectionOK with default headers values
func NewSnapmirrorRelationshipModifyCollectionOK() *SnapmirrorRelationshipModifyCollectionOK {
	return &SnapmirrorRelationshipModifyCollectionOK{}
}

/*
SnapmirrorRelationshipModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnapmirrorRelationshipModifyCollectionOK struct {
	Payload *models.SnapmirrorRelationshipJobLinkResponse
}

// IsSuccess returns true when this snapmirror relationship modify collection o k response has a 2xx status code
func (o *SnapmirrorRelationshipModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror relationship modify collection o k response has a 3xx status code
func (o *SnapmirrorRelationshipModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror relationship modify collection o k response has a 4xx status code
func (o *SnapmirrorRelationshipModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror relationship modify collection o k response has a 5xx status code
func (o *SnapmirrorRelationshipModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror relationship modify collection o k response a status code equal to that given
func (o *SnapmirrorRelationshipModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapmirror relationship modify collection o k response
func (o *SnapmirrorRelationshipModifyCollectionOK) Code() int {
	return 200
}

func (o *SnapmirrorRelationshipModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/relationships][%d] snapmirrorRelationshipModifyCollectionOK %s", 200, payload)
}

func (o *SnapmirrorRelationshipModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/relationships][%d] snapmirrorRelationshipModifyCollectionOK %s", 200, payload)
}

func (o *SnapmirrorRelationshipModifyCollectionOK) GetPayload() *models.SnapmirrorRelationshipJobLinkResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorRelationshipJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorRelationshipModifyCollectionAccepted creates a SnapmirrorRelationshipModifyCollectionAccepted with default headers values
func NewSnapmirrorRelationshipModifyCollectionAccepted() *SnapmirrorRelationshipModifyCollectionAccepted {
	return &SnapmirrorRelationshipModifyCollectionAccepted{}
}

/*
SnapmirrorRelationshipModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SnapmirrorRelationshipModifyCollectionAccepted struct {
	Payload *models.SnapmirrorRelationshipJobLinkResponse
}

// IsSuccess returns true when this snapmirror relationship modify collection accepted response has a 2xx status code
func (o *SnapmirrorRelationshipModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror relationship modify collection accepted response has a 3xx status code
func (o *SnapmirrorRelationshipModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror relationship modify collection accepted response has a 4xx status code
func (o *SnapmirrorRelationshipModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror relationship modify collection accepted response has a 5xx status code
func (o *SnapmirrorRelationshipModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror relationship modify collection accepted response a status code equal to that given
func (o *SnapmirrorRelationshipModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the snapmirror relationship modify collection accepted response
func (o *SnapmirrorRelationshipModifyCollectionAccepted) Code() int {
	return 202
}

func (o *SnapmirrorRelationshipModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/relationships][%d] snapmirrorRelationshipModifyCollectionAccepted %s", 202, payload)
}

func (o *SnapmirrorRelationshipModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/relationships][%d] snapmirrorRelationshipModifyCollectionAccepted %s", 202, payload)
}

func (o *SnapmirrorRelationshipModifyCollectionAccepted) GetPayload() *models.SnapmirrorRelationshipJobLinkResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorRelationshipJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorRelationshipModifyCollectionDefault creates a SnapmirrorRelationshipModifyCollectionDefault with default headers values
func NewSnapmirrorRelationshipModifyCollectionDefault(code int) *SnapmirrorRelationshipModifyCollectionDefault {
	return &SnapmirrorRelationshipModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnapmirrorRelationshipModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13303825    | Could not retrieve information for the SnapMirror policy type |
| 13303817    | Unknown value for the SnapMirror state |
| 13303829    | Invalid state |
| 13303830    | Transient state |
| 13303831    | Invalid state for async SnapMirror relationship |
| 13303834    | Given input valid only for FlexGroup SnapMirror relationship |
| 13303835    | Given flag is valid only when PATCH state is broken_off |
| 13303836    | Given flag is valid only when PATCH state is snapmirrored or in_sync |
| 13303818    | Invalid state transition requested |
| 13303828    | Given state change is not possible for SVM SnapMirror relationship |
| 13303833    | Requested state change is not possible |
| 13303832    | SnapMirror relationship is already initialized |
| 13303824    | Quiescing the SnapMirror relationship has failed |
| 13303826    | Required environment variables are not set |
| 13303827    | Internal Error |
| 13303823    | Quiesce operation timed out |
| 13303821    | Invalid SnapMirror policy name/UUID |
| 13303819    | Could not retrieve SnapMirror policy information |
| 13303851    | Cannot modify attributes of SnapMirror restore relationship |
| 13303816    | Could not retrieve the state or status values for the relationship. Wait a few minutes and try the operation again |
| 13303837    | Given flags are valid only if SnapMirror state change is requested |
| 6619546     | Destination must be a dp volume |
| 13303808    | Transition to broken_off state failed |
| 13303809    | Transition to paused state failed |
| 13303810    | Transition to snapmirrored state failed |
| 13303811    | Transition from paused state failed |
| 13303820    | SnapMirror policy, transfer_schedule, and throttle, if specified were successfully updated, state transition failed |
| 13303856    | SVM is not configured with any data protocol |
| 13303857    | SVM is not configured with any network interface |
| 13303858    | Internal error. Failed to check LIF and protocols details for SVM |
| 13303859    | Internal error. SVM Failover operation failed. SVM operational state is unavailable. |
| 13303865    | Modifying the specified SnapMirror policy is not supported. |
| 13303866    | Cannot use the specified policy to modify the policy of the relationship. |
| 13303867    | Modifying the policy of an async-mirror or a vault relationship is not supported. |
| 13303884    | LIF and protocols details are configured incorrectly for SVM. |
| 13303996    | The source and destination clusters both have a policy with the same name, but they have different properties. |
| 13304062    | Cannot reverse the direction of a SnapMirror DP relationship when the source cluster version is earlier than the destination cluster version. |
| 13304070    | Remote peer cluster requires the dp_rest_support capability to support reversing the direction of a DP relationship. |
| 13304071    | Failed to access capabilities on remote cluster. |
| 13304080    | Specified uuid and name do not match. |
| 13304081    | Modifying a property during the operation is not supported. |
| 13304082    | The specified properties are mutually exclusive. |
| 13304083    | The specified property is not supported because all nodes in the cluster are not capable of supporting the property. |
| 13304086    | Reversing the direction of a SnapMirror relationship associated with a policy containing the property create_snapshot_on_source set to false is not supported. |
| 6619715     | Modification of relationship is in progress. Retry the command after a few minutes. |
| 6619699     | Schedule not found. |
| 13304108    | Schedule not found in the Administrative SVM or the SVM for the relationship. |
| 13304111    | The SnapMirror active sync relationship consistency groups are nested. Expanding an SnapMirror active sync relationship with a pre-existing DP volume is only supported for flat consistency groups. |
| 6621458     | The destination Consistency Group is the source of a SnapMirror Synchronous (SM-S) relationship. Sources of SM-S relationships cannot be the destination of any other SnapMirror relationship. |
| 6621782     | A property of the policy is not valid for relationships between these endpoints. |
| 13304120    | Values specified for the source.path and destination.path properties do not match the relationship's source.path or destination.path properties.

| 13304003    | IntraCluster flip operation is not supported. |
| 6621125     | The policy is not valid for relationships with FlexGroup volume endpoints. Only policies without snapshot creation schedules are supported for these relationships. |
| 13304093    | The property specified is not supported for the specified relationships. |
| 6622077     | The expand operation has failed on the SnapMirror active sync relationship with specified destination path. |
| 6619720     | Relationship information has been updated and is being propagated. Wait a few minutes and try the operation again. |
| 13304156    | Either use state as broken-off or failover as true for SVM-DR fail-over operation. |
| 13304159    | Could not retrieve the state or status values for the relationship. Wait a few minutes and try the operation again. If the error persists, address the error condition shown. |
*/
type SnapmirrorRelationshipModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror relationship modify collection default response has a 2xx status code
func (o *SnapmirrorRelationshipModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror relationship modify collection default response has a 3xx status code
func (o *SnapmirrorRelationshipModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror relationship modify collection default response has a 4xx status code
func (o *SnapmirrorRelationshipModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror relationship modify collection default response has a 5xx status code
func (o *SnapmirrorRelationshipModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror relationship modify collection default response a status code equal to that given
func (o *SnapmirrorRelationshipModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror relationship modify collection default response
func (o *SnapmirrorRelationshipModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorRelationshipModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/relationships][%d] snapmirror_relationship_modify_collection default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/relationships][%d] snapmirror_relationship_modify_collection default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnapmirrorRelationshipModifyCollectionBody snapmirror relationship modify collection body
swagger:model SnapmirrorRelationshipModifyCollectionBody
*/
type SnapmirrorRelationshipModifyCollectionBody struct {

	// links
	Links *models.SnapmirrorRelationshipInlineLinks `json:"_links,omitempty"`

	// Specifies the SnapMirror backoff level due to Client Ops for FlexVol SnapMirror relationships.
	// Example: medium
	// Enum: ["high","medium","none"]
	BackoffLevel *string `json:"backoff_level,omitempty"`

	// consistency group failover
	ConsistencyGroupFailover *models.SnapmirrorConsistencyGroupFailover `json:"consistency_group_failover,omitempty"`

	// create destination
	CreateDestination *models.SnapmirrorDestinationCreation `json:"create_destination,omitempty"`

	// This property is the destination endpoint of the relationship. The destination endpoint can be a FlexVol volume, FlexGroup volume, Consistency Group, or SVM. For the POST request, the destination endpoint must be of type "DP" when the endpoint is a FlexVol volume or a FlexGroup volume. When specifying a Consistency Group as the destination endpoint, the "destination.consistency_group_volumes" or "destination.luns" property must be specified with the FlexVol volumes or LUNs of type "DP". The POST request for SVM must have a destination endpoint of type "dp-destination". The destination endpoint path name must be specified in the "destination.path" property. For relationships of type "async", the destination endpoint for FlexVol volume and FlexGroup volume will change to type "RW" when the relationship status is "broken_off" and will revert to type "DP" when the relationship status is "snapmirrored" or "in_sync" using the PATCH request. The destination endpoint for SVM will change from "dp-destination" to type "default" when the relationship status is "broken_off" and will revert to type "dp-destination" when the relationship status is "snapmirrored" using the PATCH request. When the destination endpoint is a Consistency Group, the Consistency Group FlexVol volumes will change to type "RW" when the relationship status is "broken_off" and will revert to type "DP" when the relationship status is "in_sync" using the PATCH request.
	Destination *models.SnapmirrorEndpoint `json:"destination,omitempty"`

	// Snapshot exported to clients on destination.
	// Read Only: true
	ExportedSnapshot *string `json:"exported_snapshot,omitempty"`

	// Specifies the group type of the top level SnapMirror relationship. The volume relationships are shown as _none_, the SVMDR relationships are shown as _svm_dr_, the Consistency Group relationships are shown as _consistency_group_, and the FlexGroup volume relationships are shown as _flexgroup_.
	// Example: consistency_group
	// Read Only: true
	// Enum: ["none","svm_dr","consistency_group","flexgroup"]
	GroupType *string `json:"group_type,omitempty"`

	// Is the relationship healthy?
	// Read Only: true
	Healthy *bool `json:"healthy,omitempty"`

	// Specifies which configuration of the source SVM is replicated to the destination SVM. This property is applicable only for SVM data protection with "async" policy type. This "identity_preservation" overrides the "identity_preservation" set on the SnapMirror relationship's policy.
	// Enum: ["full","exclude_network_config","exclude_network_and_protocol_config"]
	IdentityPreservation *string `json:"identity_preservation,omitempty"`

	// Specifies the sites serving I/O for the SnapMirror active sync relationship.
	// Example: C1_sti85-vsim-ucs209a_cluster, C1_sti85-vsim-ucs209c_cluster
	IoServingCopy *string `json:"io_serving_copy,omitempty"`

	// Time since the exported snapshot was created.
	// Example: PT8H35M42S
	// Read Only: true
	LagTime *string `json:"lag_time,omitempty"`

	// Specifies the compression ratio achieved for the data sent over the wire with network compression enabled for the last successful transfer.
	// Example: 61
	// Read Only: true
	LastTransferNetworkCompressionRatio *string `json:"last_transfer_network_compression_ratio,omitempty"`

	// Specifies the operation type of the last transfer that occurred on the relationship. The _initialize_ transfer occurs when the relationship state changes from uninitialized to snapmirrored or in_sync. The _update_ transfer occurs when the snapshots are transferred from the source endpoint to the destination endpoint as part of scheduled or manual update. The _resync_ transfer occurs when the relationship state changes from broken_off to snapmirrored or in_sync. The _restore_ transfer occurs when the snapshot is restored from a destination endpoint to another endpoint.
	// Example: initialize
	// Read Only: true
	// Enum: ["initialize","update","resync","restore"]
	LastTransferType *string `json:"last_transfer_type,omitempty"`

	// Specifies the Master Bias Activated Site for the SnapMirror active sync relationship.
	// Example: C1_sti85-vsim-ucs209a_cluster
	MasterBiasActivatedSite *string `json:"master_bias_activated_site,omitempty"`

	// policy
	Policy *models.SnapmirrorRelationshipInlinePolicy `json:"policy,omitempty"`

	// Specifies the Primary Site of the SnapMirror active sync relationship.
	// Example: C1_sti85-vsim-ucs209a_cluster
	PreferredSite *string `json:"preferred_site,omitempty"`

	// Set to true on resync to preserve snapshots on the destination that are newer than the latest common snapshot. This property is applicable only for relationships with FlexVol volume or FlexGroup volume endpoints and when the PATCH state is being changed to "snapmirrored".
	Preserve *bool `json:"preserve,omitempty"`

	// Set to true to reduce resync time by not preserving storage efficiency. This property is applicable only for relationships with FlexVol volume endpoints and SVMDR relationships when the PATCH state is being changed to "snapmirrored".
	QuickResync *bool `json:"quick_resync,omitempty"`

	// Set to true to recover from a failed SnapMirror break operation on a FlexGroup volume relationship. This restores all destination FlexGroup constituent volumes to the latest snapshot, and any writes to the read-write constituents are lost. This property is applicable only for SnapMirror relationships with FlexGroup volume endpoints and when the PATCH state is being changed to "broken_off".
	RecoverAfterBreak *bool `json:"recover_after_break,omitempty"`

	// Set to true to create a relationship for restore. To trigger restore-transfer, use transfers POST on the restore relationship. SnapMirror relationships with the policy type "async" can be restored. SnapMirror relationships with the policy type "sync" cannot be restored.
	Restore *bool `json:"restore,omitempty"`

	// Specifies the snapshot to restore to on the destination during the break operation. This property is applicable only for SnapMirror relationships with FlexVol volume endpoints and when the PATCH state is being changed to "broken_off".
	RestoreToSnapshot *string `json:"restore_to_snapshot,omitempty"`

	// Specifies the list of constituent FlexVol volumes and FlexGroup volumes for an SVM DR SnapMirror relationship. FlexGroup constituents are not considered.
	SnapmirrorRelationshipInlineSvmdrVolumes []*models.SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem `json:"svmdr_volumes,omitempty"`

	// Reason the relationship is not healthy. It is a concatenation of up to four levels of error messages.
	// Example: [{"arguments":[],"code":"6621444","message":"Failed to complete update operation on one or more item relationships."},{"arguments":[],"code":"6621445","message":"Group Update failed"}]
	// Read Only: true
	SnapmirrorRelationshipInlineUnhealthyReason []*models.SnapmirrorError `json:"unhealthy_reason,omitempty"`

	// snapmirror relationship response inline records
	SnapmirrorRelationshipResponseInlineRecords []*models.SnapmirrorRelationship `json:"records,omitempty"`

	// This property is the source endpoint of the relationship. The source endpoint can be a FlexVol volume, FlexGroup volume, Consistency Group, or SVM. To establish a SnapMirror relationship with SVM as source endpoint, the SVM must have only FlexVol volumes. For a Consistency Group this property identifies the source Consistency Group name. When specifying a Consistency Group as the source endpoint, the "source.consistency_group_volumes" property must be specified with the FlexVol volumes of type "RW". FlexVol volumes of type "DP" cannot be specified in the "source.consistency_group_volumes" list. Optionally, "source.luns" property of source endpoint can be specified with source LUN names during SnapMirror Consistency Group LUN Restore Operation.
	Source *models.SnapmirrorSourceEndpoint `json:"source,omitempty"`

	// State of the relationship.<br>To initialize the relationship, PATCH the state to "snapmirrored" for relationships with a policy of type "async" or to state "in_sync" for relationships with a policy of type "sync".<br>To break the relationship, PATCH the state to "broken_off" for relationships with a policy of type "async" or "sync". SnapMirror relationships with the policy type as "sync" and "sync_type" as "automated_failover" cannot be "broken_off".<br>To resync the relationship, PATCH the state to "snapmirrored" for relationships with a policy of type "async" or to state "in_sync" for relationships with a policy of type "sync". SnapMirror relationships with the policy type as "sync" and "sync_type" as "automated_failover" can be in "broken_off" state due to a failed attempt of SnapMirror failover.<br>To pause the relationship, suspending further transfers, PATCH the state to "paused" for relationships with a policy of type "async" or "sync". SnapMirror relationships with the policy type as "sync" and "sync_type" as "automated_failover" cannot be "paused".<br>To resume transfers for a paused relationship, PATCH the state to "snapmirrored" for relationships with a policy of type "async" or to state "in_sync" for relationships with a policy of type "sync".<br>The entries "in_sync", "out_of_sync", "synchronizing", "expanding", and "shrinking" are only applicable to relationships with a policy of type "sync". A PATCH call on the state change only triggers the transition to the specified state. You must poll on the "state", "healthy" and "unhealthy_reason" properties using a GET request to determine if the transition is successful. To automatically initialize the relationship when specifying "create_destination" property, set the state to "snapmirrored" for relationships with a policy of type "async" or to state "in_sync" for relationships with a policy of type "sync".
	// Example: snapmirrored
	// Enum: ["broken_off","paused","snapmirrored","uninitialized","in_sync","out_of_sync","synchronizing","expanding","shrinking"]
	State *string `json:"state,omitempty"`

	// Throttle, in KBs per second. This "throttle" overrides the "throttle" set on the SnapMirror relationship's policy. If neither of these are set, defaults to 0, which is interpreted as unlimited.
	Throttle *int64 `json:"throttle,omitempty"`

	// Cumulative bytes transferred for the relationship.
	// Example: 1098210312
	// Read Only: true
	TotalTransferBytes *int64 `json:"total_transfer_bytes,omitempty"`

	// Indicates the cumulative duration of all transfers since the last aggregate relocation, takeover/giveback, or metrocluster switchover/switchback involving the node that hosts the relationship.
	// Example: PT3M21S
	// Read Only: true
	TotalTransferDuration *string `json:"total_transfer_duration,omitempty"`

	// transfer
	Transfer *models.SnapmirrorRelationshipInlineTransfer `json:"transfer,omitempty"`

	// transfer schedule
	TransferSchedule *models.SnapmirrorRelationshipInlineTransferSchedule `json:"transfer_schedule,omitempty"`

	// Unique identifier of the SnapMirror relationship.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror relationship modify collection body
func (o *SnapmirrorRelationshipModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBackoffLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyGroupFailover(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGroupType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIdentityPreservation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastTransferType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirrorRelationshipInlineSvmdrVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirrorRelationshipInlineUnhealthyReason(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirrorRelationshipResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTransfer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTransferSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var snapmirrorRelationshipModifyCollectionBodyTypeBackoffLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["high","medium","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipModifyCollectionBodyTypeBackoffLevelPropEnum = append(snapmirrorRelationshipModifyCollectionBodyTypeBackoffLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// backoff_level
	// BackoffLevel
	// high
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyBackoffLevelHigh captures enum value "high"
	SnapmirrorRelationshipModifyCollectionBodyBackoffLevelHigh string = "high"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// backoff_level
	// BackoffLevel
	// medium
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyBackoffLevelMedium captures enum value "medium"
	SnapmirrorRelationshipModifyCollectionBodyBackoffLevelMedium string = "medium"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// backoff_level
	// BackoffLevel
	// none
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyBackoffLevelNone captures enum value "none"
	SnapmirrorRelationshipModifyCollectionBodyBackoffLevelNone string = "none"
)

// prop value enum
func (o *SnapmirrorRelationshipModifyCollectionBody) validateBackoffLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipModifyCollectionBodyTypeBackoffLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateBackoffLevel(formats strfmt.Registry) error {
	if swag.IsZero(o.BackoffLevel) { // not required
		return nil
	}

	// value enum
	if err := o.validateBackoffLevelEnum("info"+"."+"backoff_level", "body", *o.BackoffLevel); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateConsistencyGroupFailover(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroupFailover) { // not required
		return nil
	}

	if o.ConsistencyGroupFailover != nil {
		if err := o.ConsistencyGroupFailover.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group_failover")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateCreateDestination(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateDestination) { // not required
		return nil
	}

	if o.CreateDestination != nil {
		if err := o.CreateDestination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "create_destination")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(o.Destination) { // not required
		return nil
	}

	if o.Destination != nil {
		if err := o.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

var snapmirrorRelationshipModifyCollectionBodyTypeGroupTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","svm_dr","consistency_group","flexgroup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipModifyCollectionBodyTypeGroupTypePropEnum = append(snapmirrorRelationshipModifyCollectionBodyTypeGroupTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// group_type
	// GroupType
	// none
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyGroupTypeNone captures enum value "none"
	SnapmirrorRelationshipModifyCollectionBodyGroupTypeNone string = "none"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// group_type
	// GroupType
	// svm_dr
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyGroupTypeSvmDr captures enum value "svm_dr"
	SnapmirrorRelationshipModifyCollectionBodyGroupTypeSvmDr string = "svm_dr"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// group_type
	// GroupType
	// consistency_group
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyGroupTypeConsistencyGroup captures enum value "consistency_group"
	SnapmirrorRelationshipModifyCollectionBodyGroupTypeConsistencyGroup string = "consistency_group"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// group_type
	// GroupType
	// flexgroup
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyGroupTypeFlexgroup captures enum value "flexgroup"
	SnapmirrorRelationshipModifyCollectionBodyGroupTypeFlexgroup string = "flexgroup"
)

// prop value enum
func (o *SnapmirrorRelationshipModifyCollectionBody) validateGroupTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipModifyCollectionBodyTypeGroupTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateGroupType(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupType) { // not required
		return nil
	}

	// value enum
	if err := o.validateGroupTypeEnum("info"+"."+"group_type", "body", *o.GroupType); err != nil {
		return err
	}

	return nil
}

var snapmirrorRelationshipModifyCollectionBodyTypeIdentityPreservationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","exclude_network_config","exclude_network_and_protocol_config"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipModifyCollectionBodyTypeIdentityPreservationPropEnum = append(snapmirrorRelationshipModifyCollectionBodyTypeIdentityPreservationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// identity_preservation
	// IdentityPreservation
	// full
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyIdentityPreservationFull captures enum value "full"
	SnapmirrorRelationshipModifyCollectionBodyIdentityPreservationFull string = "full"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// identity_preservation
	// IdentityPreservation
	// exclude_network_config
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyIdentityPreservationExcludeNetworkConfig captures enum value "exclude_network_config"
	SnapmirrorRelationshipModifyCollectionBodyIdentityPreservationExcludeNetworkConfig string = "exclude_network_config"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// identity_preservation
	// IdentityPreservation
	// exclude_network_and_protocol_config
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyIdentityPreservationExcludeNetworkAndProtocolConfig captures enum value "exclude_network_and_protocol_config"
	SnapmirrorRelationshipModifyCollectionBodyIdentityPreservationExcludeNetworkAndProtocolConfig string = "exclude_network_and_protocol_config"
)

// prop value enum
func (o *SnapmirrorRelationshipModifyCollectionBody) validateIdentityPreservationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipModifyCollectionBodyTypeIdentityPreservationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateIdentityPreservation(formats strfmt.Registry) error {
	if swag.IsZero(o.IdentityPreservation) { // not required
		return nil
	}

	// value enum
	if err := o.validateIdentityPreservationEnum("info"+"."+"identity_preservation", "body", *o.IdentityPreservation); err != nil {
		return err
	}

	return nil
}

var snapmirrorRelationshipModifyCollectionBodyTypeLastTransferTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["initialize","update","resync","restore"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipModifyCollectionBodyTypeLastTransferTypePropEnum = append(snapmirrorRelationshipModifyCollectionBodyTypeLastTransferTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// last_transfer_type
	// LastTransferType
	// initialize
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyLastTransferTypeInitialize captures enum value "initialize"
	SnapmirrorRelationshipModifyCollectionBodyLastTransferTypeInitialize string = "initialize"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// last_transfer_type
	// LastTransferType
	// update
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyLastTransferTypeUpdate captures enum value "update"
	SnapmirrorRelationshipModifyCollectionBodyLastTransferTypeUpdate string = "update"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// last_transfer_type
	// LastTransferType
	// resync
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyLastTransferTypeResync captures enum value "resync"
	SnapmirrorRelationshipModifyCollectionBodyLastTransferTypeResync string = "resync"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// last_transfer_type
	// LastTransferType
	// restore
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyLastTransferTypeRestore captures enum value "restore"
	SnapmirrorRelationshipModifyCollectionBodyLastTransferTypeRestore string = "restore"
)

// prop value enum
func (o *SnapmirrorRelationshipModifyCollectionBody) validateLastTransferTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipModifyCollectionBodyTypeLastTransferTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateLastTransferType(formats strfmt.Registry) error {
	if swag.IsZero(o.LastTransferType) { // not required
		return nil
	}

	// value enum
	if err := o.validateLastTransferTypeEnum("info"+"."+"last_transfer_type", "body", *o.LastTransferType); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateSnapmirrorRelationshipInlineSvmdrVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapmirrorRelationshipInlineSvmdrVolumes) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapmirrorRelationshipInlineSvmdrVolumes); i++ {
		if swag.IsZero(o.SnapmirrorRelationshipInlineSvmdrVolumes[i]) { // not required
			continue
		}

		if o.SnapmirrorRelationshipInlineSvmdrVolumes[i] != nil {
			if err := o.SnapmirrorRelationshipInlineSvmdrVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "svmdr_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateSnapmirrorRelationshipInlineUnhealthyReason(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapmirrorRelationshipInlineUnhealthyReason) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapmirrorRelationshipInlineUnhealthyReason); i++ {
		if swag.IsZero(o.SnapmirrorRelationshipInlineUnhealthyReason[i]) { // not required
			continue
		}

		if o.SnapmirrorRelationshipInlineUnhealthyReason[i] != nil {
			if err := o.SnapmirrorRelationshipInlineUnhealthyReason[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "unhealthy_reason" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateSnapmirrorRelationshipResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapmirrorRelationshipResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapmirrorRelationshipResponseInlineRecords); i++ {
		if swag.IsZero(o.SnapmirrorRelationshipResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnapmirrorRelationshipResponseInlineRecords[i] != nil {
			if err := o.SnapmirrorRelationshipResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source")
			}
			return err
		}
	}

	return nil
}

var snapmirrorRelationshipModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["broken_off","paused","snapmirrored","uninitialized","in_sync","out_of_sync","synchronizing","expanding","shrinking"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipModifyCollectionBodyTypeStatePropEnum = append(snapmirrorRelationshipModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// state
	// State
	// broken_off
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyStateBrokenOff captures enum value "broken_off"
	SnapmirrorRelationshipModifyCollectionBodyStateBrokenOff string = "broken_off"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// state
	// State
	// paused
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyStatePaused captures enum value "paused"
	SnapmirrorRelationshipModifyCollectionBodyStatePaused string = "paused"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// state
	// State
	// snapmirrored
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyStateSnapmirrored captures enum value "snapmirrored"
	SnapmirrorRelationshipModifyCollectionBodyStateSnapmirrored string = "snapmirrored"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// state
	// State
	// uninitialized
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyStateUninitialized captures enum value "uninitialized"
	SnapmirrorRelationshipModifyCollectionBodyStateUninitialized string = "uninitialized"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// state
	// State
	// in_sync
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyStateInSync captures enum value "in_sync"
	SnapmirrorRelationshipModifyCollectionBodyStateInSync string = "in_sync"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// state
	// State
	// out_of_sync
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyStateOutOfSync captures enum value "out_of_sync"
	SnapmirrorRelationshipModifyCollectionBodyStateOutOfSync string = "out_of_sync"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// state
	// State
	// synchronizing
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyStateSynchronizing captures enum value "synchronizing"
	SnapmirrorRelationshipModifyCollectionBodyStateSynchronizing string = "synchronizing"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// state
	// State
	// expanding
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyStateExpanding captures enum value "expanding"
	SnapmirrorRelationshipModifyCollectionBodyStateExpanding string = "expanding"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBody
	// SnapmirrorRelationshipModifyCollectionBody
	// state
	// State
	// shrinking
	// END DEBUGGING
	// SnapmirrorRelationshipModifyCollectionBodyStateShrinking captures enum value "shrinking"
	SnapmirrorRelationshipModifyCollectionBodyStateShrinking string = "shrinking"
)

// prop value enum
func (o *SnapmirrorRelationshipModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateTransfer(formats strfmt.Registry) error {
	if swag.IsZero(o.Transfer) { // not required
		return nil
	}

	if o.Transfer != nil {
		if err := o.Transfer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateTransferSchedule(formats strfmt.Registry) error {
	if swag.IsZero(o.TransferSchedule) { // not required
		return nil
	}

	if o.TransferSchedule != nil {
		if err := o.TransferSchedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror relationship modify collection body based on the context it is used
func (o *SnapmirrorRelationshipModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConsistencyGroupFailover(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportedSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGroupType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHealthy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLagTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastTransferNetworkCompressionRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastTransferType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapmirrorRelationshipInlineSvmdrVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapmirrorRelationshipInlineUnhealthyReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapmirrorRelationshipResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalTransferBytes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalTransferDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTransfer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTransferSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateConsistencyGroupFailover(ctx context.Context, formats strfmt.Registry) error {

	if o.ConsistencyGroupFailover != nil {
		if err := o.ConsistencyGroupFailover.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group_failover")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateCreateDestination(ctx context.Context, formats strfmt.Registry) error {

	if o.CreateDestination != nil {
		if err := o.CreateDestination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "create_destination")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if o.Destination != nil {
		if err := o.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateExportedSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"exported_snapshot", "body", o.ExportedSnapshot); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateGroupType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"group_type", "body", o.GroupType); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateHealthy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"healthy", "body", o.Healthy); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateLagTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"lag_time", "body", o.LagTime); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateLastTransferNetworkCompressionRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"last_transfer_network_compression_ratio", "body", o.LastTransferNetworkCompressionRatio); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateLastTransferType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"last_transfer_type", "body", o.LastTransferType); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateSnapmirrorRelationshipInlineSvmdrVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnapmirrorRelationshipInlineSvmdrVolumes); i++ {

		if o.SnapmirrorRelationshipInlineSvmdrVolumes[i] != nil {
			if err := o.SnapmirrorRelationshipInlineSvmdrVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "svmdr_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateSnapmirrorRelationshipInlineUnhealthyReason(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"unhealthy_reason", "body", []*models.SnapmirrorError(o.SnapmirrorRelationshipInlineUnhealthyReason)); err != nil {
		return err
	}

	for i := 0; i < len(o.SnapmirrorRelationshipInlineUnhealthyReason); i++ {

		if o.SnapmirrorRelationshipInlineUnhealthyReason[i] != nil {
			if err := o.SnapmirrorRelationshipInlineUnhealthyReason[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "unhealthy_reason" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateSnapmirrorRelationshipResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnapmirrorRelationshipResponseInlineRecords); i++ {

		if o.SnapmirrorRelationshipResponseInlineRecords[i] != nil {
			if err := o.SnapmirrorRelationshipResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {
		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateTotalTransferBytes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_transfer_bytes", "body", o.TotalTransferBytes); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateTotalTransferDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_transfer_duration", "body", o.TotalTransferDuration); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateTransfer(ctx context.Context, formats strfmt.Registry) error {

	if o.Transfer != nil {
		if err := o.Transfer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateTransferSchedule(ctx context.Context, formats strfmt.Registry) error {

	if o.TransferSchedule != nil {
		if err := o.TransferSchedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorRelationshipInlineLinks snapmirror relationship inline links
swagger:model snapmirror_relationship_inline__links
*/
type SnapmirrorRelationshipInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapmirror relationship inline links
func (o *SnapmirrorRelationshipInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline links based on the context it is used
func (o *SnapmirrorRelationshipInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorRelationshipInlinePolicy Basic policy information of the relationship.
swagger:model snapmirror_relationship_inline_policy
*/
type SnapmirrorRelationshipInlinePolicy struct {

	// links
	Links *models.SnapmirrorRelationshipInlinePolicyInlineLinks `json:"_links,omitempty"`

	// Name of the SnapMirror policy.
	// Example: Asynchronous
	Name *string `json:"name,omitempty"`

	// type
	// Read Only: true
	// Enum: ["async","sync","continuous"]
	Type *string `json:"type,omitempty"`

	// Unique identifier of the SnapMirror policy.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror relationship inline policy
func (o *SnapmirrorRelationshipInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var snapmirrorRelationshipInlinePolicyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["async","sync","continuous"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipInlinePolicyTypeTypePropEnum = append(snapmirrorRelationshipInlinePolicyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_policy
	// SnapmirrorRelationshipInlinePolicy
	// type
	// Type
	// async
	// END DEBUGGING
	// SnapmirrorRelationshipInlinePolicyTypeAsync captures enum value "async"
	SnapmirrorRelationshipInlinePolicyTypeAsync string = "async"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_policy
	// SnapmirrorRelationshipInlinePolicy
	// type
	// Type
	// sync
	// END DEBUGGING
	// SnapmirrorRelationshipInlinePolicyTypeSync captures enum value "sync"
	SnapmirrorRelationshipInlinePolicyTypeSync string = "sync"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_policy
	// SnapmirrorRelationshipInlinePolicy
	// type
	// Type
	// continuous
	// END DEBUGGING
	// SnapmirrorRelationshipInlinePolicyTypeContinuous captures enum value "continuous"
	SnapmirrorRelationshipInlinePolicyTypeContinuous string = "continuous"
)

// prop value enum
func (o *SnapmirrorRelationshipInlinePolicy) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipInlinePolicyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorRelationshipInlinePolicy) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"policy"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipInlinePolicy) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"policy"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline policy based on the context it is used
func (o *SnapmirrorRelationshipInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipInlinePolicy) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"policy"+"."+"type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlinePolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlinePolicy) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorRelationshipInlinePolicyInlineLinks snapmirror relationship inline policy inline links
swagger:model snapmirror_relationship_inline_policy_inline__links
*/
type SnapmirrorRelationshipInlinePolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapmirror relationship inline policy inline links
func (o *SnapmirrorRelationshipInlinePolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlinePolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline policy inline links based on the context it is used
func (o *SnapmirrorRelationshipInlinePolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlinePolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlinePolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlinePolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlinePolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem snapmirror relationship inline svmdr volumes inline array item
swagger:model snapmirror_relationship_inline_svmdr_volumes_inline_array_item
*/
type SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem struct {

	// The name of the volume.
	// Example: volume1
	Name *string `json:"name,omitempty"`
}

// Validate validates this snapmirror relationship inline svmdr volumes inline array item
func (o *SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this snapmirror relationship inline svmdr volumes inline array item based on context it is used
func (o *SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorRelationshipInlineTransfer Basic information on the current transfer or the last transfer if there is no active transfer at the time of the request.
swagger:model snapmirror_relationship_inline_transfer
*/
type SnapmirrorRelationshipInlineTransfer struct {

	// links
	Links *models.SnapmirrorRelationshipInlineTransferInlineLinks `json:"_links,omitempty"`

	// Total bytes transferred in the current or last successful transfer.
	BytesTransferred *int64 `json:"bytes_transferred,omitempty"`

	// End time of the last transfer.
	// Example: 2020-12-02 18:36:19-08:00
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// Last updated time of the bytes transferred in the current transfer.
	// Example: 2023-09-14 15:39:19-07:00
	// Format: date-time
	LastUpdatedTime *strfmt.DateTime `json:"last_updated_time,omitempty"`

	// state
	// Enum: ["aborted","failed","hard_aborted","queued","success","transferring"]
	State *string `json:"state,omitempty"`

	// Elapsed time to transfer all snapshots for the last successful transfer.
	// Example: PT28M41S
	TotalDuration *string `json:"total_duration,omitempty"`

	// Specifies the operation type of the current transfer on the relationship. The _initialize_ transfer occurs when the relationship state changes from "uninitialized" to "snapmirrored" or "in_sync". The _update_ transfer occurs when snapshots are being transferred from the source endpoint to the destination endpoint as part of a scheduled or manual update. The _resync_ transfer occurs when the relationship state changes from "broken_off" to "snapmirrored" or "in_sync". The _restore_ transfer occurs when a snapshot is being restored from a destination endpoint to another endpoint.
	// Example: initialize
	// Enum: ["initialize","update","resync","restore"]
	Type *string `json:"type,omitempty"`

	// Transfer UUID. This property is applicable only for active transfers.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror relationship inline transfer
func (o *SnapmirrorRelationshipInlineTransfer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastUpdatedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineTransfer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipInlineTransfer) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(o.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"transfer"+"."+"end_time", "body", "date-time", o.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipInlineTransfer) validateLastUpdatedTime(formats strfmt.Registry) error {
	if swag.IsZero(o.LastUpdatedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"transfer"+"."+"last_updated_time", "body", "date-time", o.LastUpdatedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var snapmirrorRelationshipInlineTransferTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aborted","failed","hard_aborted","queued","success","transferring"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipInlineTransferTypeStatePropEnum = append(snapmirrorRelationshipInlineTransferTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// aborted
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateAborted captures enum value "aborted"
	SnapmirrorRelationshipInlineTransferStateAborted string = "aborted"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// failed
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateFailed captures enum value "failed"
	SnapmirrorRelationshipInlineTransferStateFailed string = "failed"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// hard_aborted
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateHardAborted captures enum value "hard_aborted"
	SnapmirrorRelationshipInlineTransferStateHardAborted string = "hard_aborted"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// queued
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateQueued captures enum value "queued"
	SnapmirrorRelationshipInlineTransferStateQueued string = "queued"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// success
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateSuccess captures enum value "success"
	SnapmirrorRelationshipInlineTransferStateSuccess string = "success"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// transferring
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateTransferring captures enum value "transferring"
	SnapmirrorRelationshipInlineTransferStateTransferring string = "transferring"
)

// prop value enum
func (o *SnapmirrorRelationshipInlineTransfer) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipInlineTransferTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineTransfer) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"transfer"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var snapmirrorRelationshipInlineTransferTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["initialize","update","resync","restore"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipInlineTransferTypeTypePropEnum = append(snapmirrorRelationshipInlineTransferTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// type
	// Type
	// initialize
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferTypeInitialize captures enum value "initialize"
	SnapmirrorRelationshipInlineTransferTypeInitialize string = "initialize"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// type
	// Type
	// update
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferTypeUpdate captures enum value "update"
	SnapmirrorRelationshipInlineTransferTypeUpdate string = "update"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// type
	// Type
	// resync
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferTypeResync captures enum value "resync"
	SnapmirrorRelationshipInlineTransferTypeResync string = "resync"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// type
	// Type
	// restore
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferTypeRestore captures enum value "restore"
	SnapmirrorRelationshipInlineTransferTypeRestore string = "restore"
)

// prop value enum
func (o *SnapmirrorRelationshipInlineTransfer) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipInlineTransferTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineTransfer) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"transfer"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipInlineTransfer) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"transfer"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline transfer based on the context it is used
func (o *SnapmirrorRelationshipInlineTransfer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineTransfer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineTransfer) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineTransfer) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineTransfer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorRelationshipInlineTransferInlineLinks snapmirror relationship inline transfer inline links
swagger:model snapmirror_relationship_inline_transfer_inline__links
*/
type SnapmirrorRelationshipInlineTransferInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapmirror relationship inline transfer inline links
func (o *SnapmirrorRelationshipInlineTransferInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineTransferInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline transfer inline links based on the context it is used
func (o *SnapmirrorRelationshipInlineTransferInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineTransferInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineTransferInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineTransferInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineTransferInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorRelationshipInlineTransferSchedule Schedule used to update asynchronous relationships. This "transfer_schedule" overrides the "transfer_schedule" set on the SnapMirror relationship's policy. To remove the "transfer_schedule", set its value to null (no-quotes). Only cron schedules are supported for SnapMirror.
swagger:model snapmirror_relationship_inline_transfer_schedule
*/
type SnapmirrorRelationshipInlineTransferSchedule struct {

	// links
	Links *models.SnapmirrorRelationshipInlineTransferScheduleInlineLinks `json:"_links,omitempty"`

	// Job schedule name
	// Example: weekly
	Name *string `json:"name,omitempty"`

	// Job schedule UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapmirror relationship inline transfer schedule
func (o *SnapmirrorRelationshipInlineTransferSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineTransferSchedule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline transfer schedule based on the context it is used
func (o *SnapmirrorRelationshipInlineTransferSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineTransferSchedule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineTransferSchedule) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineTransferSchedule) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineTransferSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorRelationshipInlineTransferScheduleInlineLinks snapmirror relationship inline transfer schedule inline links
swagger:model snapmirror_relationship_inline_transfer_schedule_inline__links
*/
type SnapmirrorRelationshipInlineTransferScheduleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapmirror relationship inline transfer schedule inline links
func (o *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline transfer schedule inline links based on the context it is used
func (o *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transfer_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineTransferScheduleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
