// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSnapmirrorRelationshipModifyParams creates a new SnapmirrorRelationshipModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapmirrorRelationshipModifyParams() *SnapmirrorRelationshipModifyParams {
	return &SnapmirrorRelationshipModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapmirrorRelationshipModifyParamsWithTimeout creates a new SnapmirrorRelationshipModifyParams object
// with the ability to set a timeout on a request.
func NewSnapmirrorRelationshipModifyParamsWithTimeout(timeout time.Duration) *SnapmirrorRelationshipModifyParams {
	return &SnapmirrorRelationshipModifyParams{
		timeout: timeout,
	}
}

// NewSnapmirrorRelationshipModifyParamsWithContext creates a new SnapmirrorRelationshipModifyParams object
// with the ability to set a context for a request.
func NewSnapmirrorRelationshipModifyParamsWithContext(ctx context.Context) *SnapmirrorRelationshipModifyParams {
	return &SnapmirrorRelationshipModifyParams{
		Context: ctx,
	}
}

// NewSnapmirrorRelationshipModifyParamsWithHTTPClient creates a new SnapmirrorRelationshipModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapmirrorRelationshipModifyParamsWithHTTPClient(client *http.Client) *SnapmirrorRelationshipModifyParams {
	return &SnapmirrorRelationshipModifyParams{
		HTTPClient: client,
	}
}

/*
SnapmirrorRelationshipModifyParams contains all the parameters to send to the API endpoint

	for the snapmirror relationship modify operation.

	Typically these are written to a http.Request.
*/
type SnapmirrorRelationshipModifyParams struct {

	/* Failback.

	   If this parameter is set while specifying the state as "snapmirrored", indicates recovery of the failed over SnapMirror relationship by preserving the data written on the destination endpoint when the SnapMirror relationship was in failed over state. This flag is only applicable to SVM-DR SnapMirror relationships.
	*/
	Failback *bool

	/* Failover.

	   If this parameter is set, validation and failover will occur to the SVM-DR SnapMirror relationship destination endpoint. Any other fields specified with this parameter will be ignored. This parameter is supported only for SVM-DR SnapMirror relationships.
	*/
	Failover *bool

	/* Force.

	   If this parameter is set while specifying the state as "broken_off", indicates a forced failover overriding the validation errors.
	*/
	Force *bool

	/* ForceFailover.

	   If this parameter is set, failover will occur to the SVM-DR SnapMirror relationship destination endpoint, overriding the validation errors. Any other fields specified with this parameter will be ignored. This parameter is supported only for SVM-DR SnapMirror relationships.
	*/
	ForceFailover *bool

	/* Info.

	   Information on the SnapMirror relationship.
	*/
	Info *models.SnapmirrorRelationship

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   SnapMirror relationship UUID
	*/
	UUID string

	/* ValidateOnly.

	   Validate the operation and its parameters, without actually performing the operation.
	*/
	ValidateOnly *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapmirror relationship modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorRelationshipModifyParams) WithDefaults() *SnapmirrorRelationshipModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapmirror relationship modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorRelationshipModifyParams) SetDefaults() {
	var (
		failbackDefault = bool(false)

		failoverDefault = bool(false)

		forceDefault = bool(false)

		forceFailoverDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := SnapmirrorRelationshipModifyParams{
		Failback:      &failbackDefault,
		Failover:      &failoverDefault,
		Force:         &forceDefault,
		ForceFailover: &forceFailoverDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithTimeout(timeout time.Duration) *SnapmirrorRelationshipModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithContext(ctx context.Context) *SnapmirrorRelationshipModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithHTTPClient(client *http.Client) *SnapmirrorRelationshipModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFailback adds the failback to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithFailback(failback *bool) *SnapmirrorRelationshipModifyParams {
	o.SetFailback(failback)
	return o
}

// SetFailback adds the failback to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetFailback(failback *bool) {
	o.Failback = failback
}

// WithFailover adds the failover to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithFailover(failover *bool) *SnapmirrorRelationshipModifyParams {
	o.SetFailover(failover)
	return o
}

// SetFailover adds the failover to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetFailover(failover *bool) {
	o.Failover = failover
}

// WithForce adds the force to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithForce(force *bool) *SnapmirrorRelationshipModifyParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetForce(force *bool) {
	o.Force = force
}

// WithForceFailover adds the forceFailover to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithForceFailover(forceFailover *bool) *SnapmirrorRelationshipModifyParams {
	o.SetForceFailover(forceFailover)
	return o
}

// SetForceFailover adds the forceFailover to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetForceFailover(forceFailover *bool) {
	o.ForceFailover = forceFailover
}

// WithInfo adds the info to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithInfo(info *models.SnapmirrorRelationship) *SnapmirrorRelationshipModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetInfo(info *models.SnapmirrorRelationship) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithReturnTimeout(returnTimeout *int64) *SnapmirrorRelationshipModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithUUID(uuid string) *SnapmirrorRelationshipModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithValidateOnly adds the validateOnly to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) WithValidateOnly(validateOnly *bool) *SnapmirrorRelationshipModifyParams {
	o.SetValidateOnly(validateOnly)
	return o
}

// SetValidateOnly adds the validateOnly to the snapmirror relationship modify params
func (o *SnapmirrorRelationshipModifyParams) SetValidateOnly(validateOnly *bool) {
	o.ValidateOnly = validateOnly
}

// WriteToRequest writes these params to a swagger request
func (o *SnapmirrorRelationshipModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Failback != nil {

		// query param failback
		var qrFailback bool

		if o.Failback != nil {
			qrFailback = *o.Failback
		}
		qFailback := swag.FormatBool(qrFailback)
		if qFailback != "" {

			if err := r.SetQueryParam("failback", qFailback); err != nil {
				return err
			}
		}
	}

	if o.Failover != nil {

		// query param failover
		var qrFailover bool

		if o.Failover != nil {
			qrFailover = *o.Failover
		}
		qFailover := swag.FormatBool(qrFailover)
		if qFailover != "" {

			if err := r.SetQueryParam("failover", qFailover); err != nil {
				return err
			}
		}
	}

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	if o.ForceFailover != nil {

		// query param force-failover
		var qrForceFailover bool

		if o.ForceFailover != nil {
			qrForceFailover = *o.ForceFailover
		}
		qForceFailover := swag.FormatBool(qrForceFailover)
		if qForceFailover != "" {

			if err := r.SetQueryParam("force-failover", qForceFailover); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if o.ValidateOnly != nil {

		// query param validate_only
		var qrValidateOnly bool

		if o.ValidateOnly != nil {
			qrValidateOnly = *o.ValidateOnly
		}
		qValidateOnly := swag.FormatBool(qrValidateOnly)
		if qValidateOnly != "" {

			if err := r.SetQueryParam("validate_only", qValidateOnly); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
