// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSnapmirrorRelationshipTransferCreateParams creates a new SnapmirrorRelationshipTransferCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnapmirrorRelationshipTransferCreateParams() *SnapmirrorRelationshipTransferCreateParams {
	return &SnapmirrorRelationshipTransferCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnapmirrorRelationshipTransferCreateParamsWithTimeout creates a new SnapmirrorRelationshipTransferCreateParams object
// with the ability to set a timeout on a request.
func NewSnapmirrorRelationshipTransferCreateParamsWithTimeout(timeout time.Duration) *SnapmirrorRelationshipTransferCreateParams {
	return &SnapmirrorRelationshipTransferCreateParams{
		timeout: timeout,
	}
}

// NewSnapmirrorRelationshipTransferCreateParamsWithContext creates a new SnapmirrorRelationshipTransferCreateParams object
// with the ability to set a context for a request.
func NewSnapmirrorRelationshipTransferCreateParamsWithContext(ctx context.Context) *SnapmirrorRelationshipTransferCreateParams {
	return &SnapmirrorRelationshipTransferCreateParams{
		Context: ctx,
	}
}

// NewSnapmirrorRelationshipTransferCreateParamsWithHTTPClient creates a new SnapmirrorRelationshipTransferCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnapmirrorRelationshipTransferCreateParamsWithHTTPClient(client *http.Client) *SnapmirrorRelationshipTransferCreateParams {
	return &SnapmirrorRelationshipTransferCreateParams{
		HTTPClient: client,
	}
}

/*
SnapmirrorRelationshipTransferCreateParams contains all the parameters to send to the API endpoint

	for the snapmirror relationship transfer create operation.

	Typically these are written to a http.Request.
*/
type SnapmirrorRelationshipTransferCreateParams struct {

	/* Info.

	   Information on the SnapMirror transfer
	*/
	Info *models.SnapmirrorTransfer

	/* RelationshipUUID.

	   SnapMirror relationship UUID
	*/
	RelationshipUUID string

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snapmirror relationship transfer create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorRelationshipTransferCreateParams) WithDefaults() *SnapmirrorRelationshipTransferCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snapmirror relationship transfer create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnapmirrorRelationshipTransferCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := SnapmirrorRelationshipTransferCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) WithTimeout(timeout time.Duration) *SnapmirrorRelationshipTransferCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) WithContext(ctx context.Context) *SnapmirrorRelationshipTransferCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) WithHTTPClient(client *http.Client) *SnapmirrorRelationshipTransferCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) WithInfo(info *models.SnapmirrorTransfer) *SnapmirrorRelationshipTransferCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) SetInfo(info *models.SnapmirrorTransfer) {
	o.Info = info
}

// WithRelationshipUUID adds the relationshipUUID to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) WithRelationshipUUID(relationshipUUID string) *SnapmirrorRelationshipTransferCreateParams {
	o.SetRelationshipUUID(relationshipUUID)
	return o
}

// SetRelationshipUUID adds the relationshipUuid to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) SetRelationshipUUID(relationshipUUID string) {
	o.RelationshipUUID = relationshipUUID
}

// WithReturnRecords adds the returnRecords to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) WithReturnRecords(returnRecords *bool) *SnapmirrorRelationshipTransferCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) WithReturnTimeout(returnTimeout *int64) *SnapmirrorRelationshipTransferCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snapmirror relationship transfer create params
func (o *SnapmirrorRelationshipTransferCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SnapmirrorRelationshipTransferCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param relationship.uuid
	if err := r.SetPathParam("relationship.uuid", o.RelationshipUUID); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
