// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorRelationshipTransferCreateReader is a Reader for the SnapmirrorRelationshipTransferCreate structure.
type SnapmirrorRelationshipTransferCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorRelationshipTransferCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSnapmirrorRelationshipTransferCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorRelationshipTransferCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorRelationshipTransferCreateCreated creates a SnapmirrorRelationshipTransferCreateCreated with default headers values
func NewSnapmirrorRelationshipTransferCreateCreated() *SnapmirrorRelationshipTransferCreateCreated {
	return &SnapmirrorRelationshipTransferCreateCreated{}
}

/*
SnapmirrorRelationshipTransferCreateCreated describes a response with status code 201, with default header values.

Created
*/
type SnapmirrorRelationshipTransferCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this snapmirror relationship transfer create created response has a 2xx status code
func (o *SnapmirrorRelationshipTransferCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror relationship transfer create created response has a 3xx status code
func (o *SnapmirrorRelationshipTransferCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror relationship transfer create created response has a 4xx status code
func (o *SnapmirrorRelationshipTransferCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror relationship transfer create created response has a 5xx status code
func (o *SnapmirrorRelationshipTransferCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror relationship transfer create created response a status code equal to that given
func (o *SnapmirrorRelationshipTransferCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the snapmirror relationship transfer create created response
func (o *SnapmirrorRelationshipTransferCreateCreated) Code() int {
	return 201
}

func (o *SnapmirrorRelationshipTransferCreateCreated) Error() string {
	return fmt.Sprintf("[POST /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirrorRelationshipTransferCreateCreated", 201)
}

func (o *SnapmirrorRelationshipTransferCreateCreated) String() string {
	return fmt.Sprintf("[POST /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirrorRelationshipTransferCreateCreated", 201)
}

func (o *SnapmirrorRelationshipTransferCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewSnapmirrorRelationshipTransferCreateDefault creates a SnapmirrorRelationshipTransferCreateDefault with default headers values
func NewSnapmirrorRelationshipTransferCreateDefault(code int) *SnapmirrorRelationshipTransferCreateDefault {
	return &SnapmirrorRelationshipTransferCreateDefault{
		_statusCode: code,
	}
}

/*
	SnapmirrorRelationshipTransferCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13303845    | Restore operation failed |
| 13303812    | Initialize operation failed |
| 13303844    | Update operation failed |
| 13303846    | Empty source path file list |
| 13303847    | Invalid property |
| 13304040    | Throttle not supported for update of Synchronous SnapMirror relationships |
| 6620237     | SnapMirror relationship database write failed |
| 6620238     | SnapMirror relationship database read failed |
| 13304134    | The overwrite property specified does not match the value specified in the previous request. ||
| 6619720     | Relationship information has been updated and is being propagated. Wait a few minutes and try the operation again. |
| 13303816    | Could not retrieve the state or status values for the relationship. Wait a few minutes and try the operation again. |
| 13304159    | Could not retrieve the state or status values for the relationship. Wait a few minutes and try the operation again. If the error persists, address the error condition shown. |
*/
type SnapmirrorRelationshipTransferCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror relationship transfer create default response has a 2xx status code
func (o *SnapmirrorRelationshipTransferCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror relationship transfer create default response has a 3xx status code
func (o *SnapmirrorRelationshipTransferCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror relationship transfer create default response has a 4xx status code
func (o *SnapmirrorRelationshipTransferCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror relationship transfer create default response has a 5xx status code
func (o *SnapmirrorRelationshipTransferCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror relationship transfer create default response a status code equal to that given
func (o *SnapmirrorRelationshipTransferCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror relationship transfer create default response
func (o *SnapmirrorRelationshipTransferCreateDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorRelationshipTransferCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirror_relationship_transfer_create default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipTransferCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirror_relationship_transfer_create default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipTransferCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipTransferCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
