// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorRelationshipTransferGetReader is a Reader for the SnapmirrorRelationshipTransferGet structure.
type SnapmirrorRelationshipTransferGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorRelationshipTransferGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapmirrorRelationshipTransferGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorRelationshipTransferGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorRelationshipTransferGetOK creates a SnapmirrorRelationshipTransferGetOK with default headers values
func NewSnapmirrorRelationshipTransferGetOK() *SnapmirrorRelationshipTransferGetOK {
	return &SnapmirrorRelationshipTransferGetOK{}
}

/*
SnapmirrorRelationshipTransferGetOK describes a response with status code 200, with default header values.

OK
*/
type SnapmirrorRelationshipTransferGetOK struct {
	Payload *models.SnapmirrorTransfer
}

// IsSuccess returns true when this snapmirror relationship transfer get o k response has a 2xx status code
func (o *SnapmirrorRelationshipTransferGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror relationship transfer get o k response has a 3xx status code
func (o *SnapmirrorRelationshipTransferGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror relationship transfer get o k response has a 4xx status code
func (o *SnapmirrorRelationshipTransferGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror relationship transfer get o k response has a 5xx status code
func (o *SnapmirrorRelationshipTransferGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror relationship transfer get o k response a status code equal to that given
func (o *SnapmirrorRelationshipTransferGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapmirror relationship transfer get o k response
func (o *SnapmirrorRelationshipTransferGetOK) Code() int {
	return 200
}

func (o *SnapmirrorRelationshipTransferGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships/{relationship.uuid}/transfers/{uuid}][%d] snapmirrorRelationshipTransferGetOK %s", 200, payload)
}

func (o *SnapmirrorRelationshipTransferGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships/{relationship.uuid}/transfers/{uuid}][%d] snapmirrorRelationshipTransferGetOK %s", 200, payload)
}

func (o *SnapmirrorRelationshipTransferGetOK) GetPayload() *models.SnapmirrorTransfer {
	return o.Payload
}

func (o *SnapmirrorRelationshipTransferGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorTransfer)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorRelationshipTransferGetDefault creates a SnapmirrorRelationshipTransferGetDefault with default headers values
func NewSnapmirrorRelationshipTransferGetDefault(code int) *SnapmirrorRelationshipTransferGetDefault {
	return &SnapmirrorRelationshipTransferGetDefault{
		_statusCode: code,
	}
}

/*
SnapmirrorRelationshipTransferGetDefault describes a response with status code -1, with default header values.

Error
*/
type SnapmirrorRelationshipTransferGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror relationship transfer get default response has a 2xx status code
func (o *SnapmirrorRelationshipTransferGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror relationship transfer get default response has a 3xx status code
func (o *SnapmirrorRelationshipTransferGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror relationship transfer get default response has a 4xx status code
func (o *SnapmirrorRelationshipTransferGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror relationship transfer get default response has a 5xx status code
func (o *SnapmirrorRelationshipTransferGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror relationship transfer get default response a status code equal to that given
func (o *SnapmirrorRelationshipTransferGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror relationship transfer get default response
func (o *SnapmirrorRelationshipTransferGetDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorRelationshipTransferGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships/{relationship.uuid}/transfers/{uuid}][%d] snapmirror_relationship_transfer_get default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipTransferGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships/{relationship.uuid}/transfers/{uuid}][%d] snapmirror_relationship_transfer_get default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipTransferGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipTransferGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
