// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorRelationshipTransferModifyCollectionReader is a Reader for the SnapmirrorRelationshipTransferModifyCollection structure.
type SnapmirrorRelationshipTransferModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorRelationshipTransferModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapmirrorRelationshipTransferModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorRelationshipTransferModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorRelationshipTransferModifyCollectionOK creates a SnapmirrorRelationshipTransferModifyCollectionOK with default headers values
func NewSnapmirrorRelationshipTransferModifyCollectionOK() *SnapmirrorRelationshipTransferModifyCollectionOK {
	return &SnapmirrorRelationshipTransferModifyCollectionOK{}
}

/*
SnapmirrorRelationshipTransferModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnapmirrorRelationshipTransferModifyCollectionOK struct {
}

// IsSuccess returns true when this snapmirror relationship transfer modify collection o k response has a 2xx status code
func (o *SnapmirrorRelationshipTransferModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror relationship transfer modify collection o k response has a 3xx status code
func (o *SnapmirrorRelationshipTransferModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror relationship transfer modify collection o k response has a 4xx status code
func (o *SnapmirrorRelationshipTransferModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror relationship transfer modify collection o k response has a 5xx status code
func (o *SnapmirrorRelationshipTransferModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror relationship transfer modify collection o k response a status code equal to that given
func (o *SnapmirrorRelationshipTransferModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapmirror relationship transfer modify collection o k response
func (o *SnapmirrorRelationshipTransferModifyCollectionOK) Code() int {
	return 200
}

func (o *SnapmirrorRelationshipTransferModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirrorRelationshipTransferModifyCollectionOK", 200)
}

func (o *SnapmirrorRelationshipTransferModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirrorRelationshipTransferModifyCollectionOK", 200)
}

func (o *SnapmirrorRelationshipTransferModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnapmirrorRelationshipTransferModifyCollectionDefault creates a SnapmirrorRelationshipTransferModifyCollectionDefault with default headers values
func NewSnapmirrorRelationshipTransferModifyCollectionDefault(code int) *SnapmirrorRelationshipTransferModifyCollectionDefault {
	return &SnapmirrorRelationshipTransferModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnapmirrorRelationshipTransferModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13303848    | Abort of sync SnapMirror is not allowed |
| 13303849    | SnapMirror transfer state is invalid |
*/
type SnapmirrorRelationshipTransferModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror relationship transfer modify collection default response has a 2xx status code
func (o *SnapmirrorRelationshipTransferModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror relationship transfer modify collection default response has a 3xx status code
func (o *SnapmirrorRelationshipTransferModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror relationship transfer modify collection default response has a 4xx status code
func (o *SnapmirrorRelationshipTransferModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror relationship transfer modify collection default response has a 5xx status code
func (o *SnapmirrorRelationshipTransferModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror relationship transfer modify collection default response a status code equal to that given
func (o *SnapmirrorRelationshipTransferModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror relationship transfer modify collection default response
func (o *SnapmirrorRelationshipTransferModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorRelationshipTransferModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirror_relationship_transfer_modify_collection default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipTransferModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirror_relationship_transfer_modify_collection default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipTransferModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipTransferModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnapmirrorRelationshipTransferModifyCollectionBody snapmirror relationship transfer modify collection body
swagger:model SnapmirrorRelationshipTransferModifyCollectionBody
*/
type SnapmirrorRelationshipTransferModifyCollectionBody struct {

	// links
	Links *models.SnapmirrorTransferInlineLinks `json:"_links,omitempty"`

	// Bytes transferred
	// Read Only: true
	BytesTransferred *int64 `json:"bytes_transferred,omitempty"`

	// Amount of data transferred in bytes as recorded in the restart checkpoint.
	// Read Only: true
	CheckpointSize *int64 `json:"checkpoint_size,omitempty"`

	// End time of the transfer.
	// Example: 2020-12-02 18:36:19-08:00
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// error info
	ErrorInfo *models.SnapmirrorTransferInlineErrorInfo `json:"error_info,omitempty"`

	// Last updated time of the bytes transferred in an active transfer.
	// Example: 2023-09-15 16:58:39-07:00
	// Read Only: true
	// Format: date-time
	LastUpdatedTime *strfmt.DateTime `json:"last_updated_time,omitempty"`

	// Specifies the compression ratio achieved for the data sent over the wire with network compression enabled. This property is only valid for active transfers.
	// Example: 61
	// Read Only: true
	NetworkCompressionRatio *string `json:"network_compression_ratio,omitempty"`

	// Specifies whether or not an on-demand restore is being carried out. This is only supported for the transfer of restore relationships for entire volumes from the object store. A value for read_write_with_user_data_pull should be provided to start an on-demand restore. A file restore from the object store does not support this option.
	// Example: read_write_with_user_data_pull
	// Enum: ["off","read_write_with_user_data_pull"]
	OnDemandAttrs *string `json:"on_demand_attrs,omitempty"`

	// relationship
	Relationship *models.SnapmirrorTransferInlineRelationship `json:"relationship,omitempty"`

	// This is supported for transfer of restore relationship only. This specifies the list of files or LUNs to be restored. Can contain up to eight files or LUNs.
	SnapmirrorTransferInlineFiles []*models.SnapmirrorTransferInlineFilesInlineArrayItem `json:"files,omitempty"`

	// Options for snapmirror transfer.
	SnapmirrorTransferInlineOptions []interface{} `json:"options,omitempty"`

	// snapmirror transfer response inline records
	SnapmirrorTransferResponseInlineRecords []*models.SnapmirrorTransfer `json:"records,omitempty"`

	// Name of snapshot being transferred.
	// Read Only: true
	Snapshot *string `json:"snapshot,omitempty"`

	// Specifies the snapshot on the source to be transferred to the destination.
	SourceSnapshot *string `json:"source_snapshot,omitempty"`

	// Status of the transfer. Set PATCH state to "aborted" to abort the transfer. Set PATCH state to "hard_aborted" to abort the transfer and discard the restart checkpoint. To find "queued" transfers refer to relationships GET API.
	// Enum: ["aborted","failed","hard_aborted","queued","success","transferring"]
	State *string `json:"state,omitempty"`

	// This is supported for transfer of restore relationship only. Set this property to "false" to turn off storage efficiency for data transferred over the wire and written to the destination.
	StorageEfficiencyEnabled *bool `json:"storage_efficiency_enabled,omitempty"`

	// Throttle, in KBs per second. This "throttle" overrides the "throttle" set on the SnapMirror relationship or SnapMirror relationship's policy. If neither of these are set, defaults to 0, which is interpreted as unlimited.
	Throttle *int64 `json:"throttle,omitempty"`

	// Elapsed transfer time.
	// Example: PT28M41S
	// Read Only: true
	TotalDuration *string `json:"total_duration,omitempty"`

	// Unique identifier of the SnapMirror transfer.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror relationship transfer modify collection body
func (o *SnapmirrorRelationshipTransferModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateErrorInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastUpdatedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOnDemandAttrs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRelationship(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirrorTransferInlineFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirrorTransferResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(o.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"end_time", "body", "date-time", o.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateErrorInfo(formats strfmt.Registry) error {
	if swag.IsZero(o.ErrorInfo) { // not required
		return nil
	}

	if o.ErrorInfo != nil {
		if err := o.ErrorInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error_info")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateLastUpdatedTime(formats strfmt.Registry) error {
	if swag.IsZero(o.LastUpdatedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"last_updated_time", "body", "date-time", o.LastUpdatedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var snapmirrorRelationshipTransferModifyCollectionBodyTypeOnDemandAttrsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["off","read_write_with_user_data_pull"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipTransferModifyCollectionBodyTypeOnDemandAttrsPropEnum = append(snapmirrorRelationshipTransferModifyCollectionBodyTypeOnDemandAttrsPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// on_demand_attrs
	// OnDemandAttrs
	// off
	// END DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBodyOnDemandAttrsOff captures enum value "off"
	SnapmirrorRelationshipTransferModifyCollectionBodyOnDemandAttrsOff string = "off"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// on_demand_attrs
	// OnDemandAttrs
	// read_write_with_user_data_pull
	// END DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBodyOnDemandAttrsReadWriteWithUserDataPull captures enum value "read_write_with_user_data_pull"
	SnapmirrorRelationshipTransferModifyCollectionBodyOnDemandAttrsReadWriteWithUserDataPull string = "read_write_with_user_data_pull"
)

// prop value enum
func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateOnDemandAttrsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipTransferModifyCollectionBodyTypeOnDemandAttrsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateOnDemandAttrs(formats strfmt.Registry) error {
	if swag.IsZero(o.OnDemandAttrs) { // not required
		return nil
	}

	// value enum
	if err := o.validateOnDemandAttrsEnum("info"+"."+"on_demand_attrs", "body", *o.OnDemandAttrs); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateRelationship(formats strfmt.Registry) error {
	if swag.IsZero(o.Relationship) { // not required
		return nil
	}

	if o.Relationship != nil {
		if err := o.Relationship.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "relationship")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateSnapmirrorTransferInlineFiles(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapmirrorTransferInlineFiles) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapmirrorTransferInlineFiles); i++ {
		if swag.IsZero(o.SnapmirrorTransferInlineFiles[i]) { // not required
			continue
		}

		if o.SnapmirrorTransferInlineFiles[i] != nil {
			if err := o.SnapmirrorTransferInlineFiles[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateSnapmirrorTransferResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapmirrorTransferResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapmirrorTransferResponseInlineRecords); i++ {
		if swag.IsZero(o.SnapmirrorTransferResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnapmirrorTransferResponseInlineRecords[i] != nil {
			if err := o.SnapmirrorTransferResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var snapmirrorRelationshipTransferModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aborted","failed","hard_aborted","queued","success","transferring"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipTransferModifyCollectionBodyTypeStatePropEnum = append(snapmirrorRelationshipTransferModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// state
	// State
	// aborted
	// END DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBodyStateAborted captures enum value "aborted"
	SnapmirrorRelationshipTransferModifyCollectionBodyStateAborted string = "aborted"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// state
	// State
	// failed
	// END DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBodyStateFailed captures enum value "failed"
	SnapmirrorRelationshipTransferModifyCollectionBodyStateFailed string = "failed"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// state
	// State
	// hard_aborted
	// END DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBodyStateHardAborted captures enum value "hard_aborted"
	SnapmirrorRelationshipTransferModifyCollectionBodyStateHardAborted string = "hard_aborted"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// state
	// State
	// queued
	// END DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBodyStateQueued captures enum value "queued"
	SnapmirrorRelationshipTransferModifyCollectionBodyStateQueued string = "queued"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// state
	// State
	// success
	// END DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBodyStateSuccess captures enum value "success"
	SnapmirrorRelationshipTransferModifyCollectionBodyStateSuccess string = "success"

	// BEGIN DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// SnapmirrorRelationshipTransferModifyCollectionBody
	// state
	// State
	// transferring
	// END DEBUGGING
	// SnapmirrorRelationshipTransferModifyCollectionBodyStateTransferring captures enum value "transferring"
	SnapmirrorRelationshipTransferModifyCollectionBodyStateTransferring string = "transferring"
)

// prop value enum
func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipTransferModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror relationship transfer modify collection body based on the context it is used
func (o *SnapmirrorRelationshipTransferModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBytesTransferred(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCheckpointSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateErrorInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastUpdatedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNetworkCompressionRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRelationship(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapmirrorTransferInlineFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapmirrorTransferResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateBytesTransferred(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"bytes_transferred", "body", o.BytesTransferred); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateCheckpointSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"checkpoint_size", "body", o.CheckpointSize); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"end_time", "body", o.EndTime); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateErrorInfo(ctx context.Context, formats strfmt.Registry) error {

	if o.ErrorInfo != nil {
		if err := o.ErrorInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error_info")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateLastUpdatedTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"last_updated_time", "body", o.LastUpdatedTime); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateNetworkCompressionRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"network_compression_ratio", "body", o.NetworkCompressionRatio); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateRelationship(ctx context.Context, formats strfmt.Registry) error {

	if o.Relationship != nil {
		if err := o.Relationship.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "relationship")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateSnapmirrorTransferInlineFiles(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnapmirrorTransferInlineFiles); i++ {

		if o.SnapmirrorTransferInlineFiles[i] != nil {
			if err := o.SnapmirrorTransferInlineFiles[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateSnapmirrorTransferResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnapmirrorTransferResponseInlineRecords); i++ {

		if o.SnapmirrorTransferResponseInlineRecords[i] != nil {
			if err := o.SnapmirrorTransferResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapshot", "body", o.Snapshot); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateTotalDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_duration", "body", o.TotalDuration); err != nil {
		return err
	}

	return nil
}

func (o *SnapmirrorRelationshipTransferModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorRelationshipTransferModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorRelationshipTransferModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipTransferModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorTransferInlineLinks snapmirror transfer inline links
swagger:model snapmirror_transfer_inline__links
*/
type SnapmirrorTransferInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snapmirror transfer inline links
func (o *SnapmirrorTransferInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorTransferInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror transfer inline links based on the context it is used
func (o *SnapmirrorTransferInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorTransferInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorTransferInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorTransferInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorTransferInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorTransferInlineErrorInfo Error information for the transfer.
swagger:model snapmirror_transfer_inline_error_info
*/
type SnapmirrorTransferInlineErrorInfo struct {

	// Error code
	// Example: 6620046
	Code *int64 `json:"code,omitempty"`

	// Error message
	// Example: Transfer aborted
	Message *string `json:"message,omitempty"`
}

// Validate validates this snapmirror transfer inline error info
func (o *SnapmirrorTransferInlineErrorInfo) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this snapmirror transfer inline error info based on the context it is used
func (o *SnapmirrorTransferInlineErrorInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorTransferInlineErrorInfo) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorTransferInlineErrorInfo) UnmarshalBinary(b []byte) error {
	var res SnapmirrorTransferInlineErrorInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorTransferInlineFilesInlineArrayItem Specifies a file or LUN consisting of a source_path and an optional destination_path. If not specified, the destination_path is the same as the source_path. File restore is not supported if the source_path or destination_path contains commas in its directory or file name.
swagger:model snapmirror_transfer_inline_files_inline_array_item
*/
type SnapmirrorTransferInlineFilesInlineArrayItem struct {

	// destination path
	// Example: /dirb/file2
	DestinationPath *string `json:"destination_path,omitempty"`

	// source path
	// Example: /dira/file1
	SourcePath *string `json:"source_path,omitempty"`
}

// Validate validates this snapmirror transfer inline files inline array item
func (o *SnapmirrorTransferInlineFilesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this snapmirror transfer inline files inline array item based on context it is used
func (o *SnapmirrorTransferInlineFilesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorTransferInlineFilesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorTransferInlineFilesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SnapmirrorTransferInlineFilesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnapmirrorTransferInlineRelationship snapmirror transfer inline relationship
swagger:model snapmirror_transfer_inline_relationship
*/
type SnapmirrorTransferInlineRelationship struct {

	// destination
	Destination *models.SnapmirrorEndpoint `json:"destination,omitempty"`

	// Is the relationship for restore?
	Restore *bool `json:"restore,omitempty"`

	// Unique identifier of the SnapMirror relationship.
	// Example: d2d7ceea-ab52-11e8-855e-00505682a4c7
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror transfer inline relationship
func (o *SnapmirrorTransferInlineRelationship) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorTransferInlineRelationship) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(o.Destination) { // not required
		return nil
	}

	if o.Destination != nil {
		if err := o.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "relationship" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (o *SnapmirrorTransferInlineRelationship) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"relationship"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror transfer inline relationship based on the context it is used
func (o *SnapmirrorTransferInlineRelationship) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnapmirrorTransferInlineRelationship) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if o.Destination != nil {
		if err := o.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "relationship" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnapmirrorTransferInlineRelationship) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnapmirrorTransferInlineRelationship) UnmarshalBinary(b []byte) error {
	var res SnapmirrorTransferInlineRelationship
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
