// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorRelationshipTransferModifyReader is a Reader for the SnapmirrorRelationshipTransferModify structure.
type SnapmirrorRelationshipTransferModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorRelationshipTransferModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapmirrorRelationshipTransferModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorRelationshipTransferModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorRelationshipTransferModifyOK creates a SnapmirrorRelationshipTransferModifyOK with default headers values
func NewSnapmirrorRelationshipTransferModifyOK() *SnapmirrorRelationshipTransferModifyOK {
	return &SnapmirrorRelationshipTransferModifyOK{}
}

/*
SnapmirrorRelationshipTransferModifyOK describes a response with status code 200, with default header values.

OK
*/
type SnapmirrorRelationshipTransferModifyOK struct {
}

// IsSuccess returns true when this snapmirror relationship transfer modify o k response has a 2xx status code
func (o *SnapmirrorRelationshipTransferModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror relationship transfer modify o k response has a 3xx status code
func (o *SnapmirrorRelationshipTransferModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror relationship transfer modify o k response has a 4xx status code
func (o *SnapmirrorRelationshipTransferModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror relationship transfer modify o k response has a 5xx status code
func (o *SnapmirrorRelationshipTransferModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror relationship transfer modify o k response a status code equal to that given
func (o *SnapmirrorRelationshipTransferModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapmirror relationship transfer modify o k response
func (o *SnapmirrorRelationshipTransferModifyOK) Code() int {
	return 200
}

func (o *SnapmirrorRelationshipTransferModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /snapmirror/relationships/{relationship.uuid}/transfers/{uuid}][%d] snapmirrorRelationshipTransferModifyOK", 200)
}

func (o *SnapmirrorRelationshipTransferModifyOK) String() string {
	return fmt.Sprintf("[PATCH /snapmirror/relationships/{relationship.uuid}/transfers/{uuid}][%d] snapmirrorRelationshipTransferModifyOK", 200)
}

func (o *SnapmirrorRelationshipTransferModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnapmirrorRelationshipTransferModifyDefault creates a SnapmirrorRelationshipTransferModifyDefault with default headers values
func NewSnapmirrorRelationshipTransferModifyDefault(code int) *SnapmirrorRelationshipTransferModifyDefault {
	return &SnapmirrorRelationshipTransferModifyDefault{
		_statusCode: code,
	}
}

/*
	SnapmirrorRelationshipTransferModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13303848    | Abort of sync SnapMirror is not allowed |
| 13303849    | SnapMirror transfer state is invalid |
*/
type SnapmirrorRelationshipTransferModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror relationship transfer modify default response has a 2xx status code
func (o *SnapmirrorRelationshipTransferModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror relationship transfer modify default response has a 3xx status code
func (o *SnapmirrorRelationshipTransferModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror relationship transfer modify default response has a 4xx status code
func (o *SnapmirrorRelationshipTransferModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror relationship transfer modify default response has a 5xx status code
func (o *SnapmirrorRelationshipTransferModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror relationship transfer modify default response a status code equal to that given
func (o *SnapmirrorRelationshipTransferModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror relationship transfer modify default response
func (o *SnapmirrorRelationshipTransferModifyDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorRelationshipTransferModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/relationships/{relationship.uuid}/transfers/{uuid}][%d] snapmirror_relationship_transfer_modify default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipTransferModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /snapmirror/relationships/{relationship.uuid}/transfers/{uuid}][%d] snapmirror_relationship_transfer_modify default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipTransferModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipTransferModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
