// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorRelationshipTransfersGetReader is a Reader for the SnapmirrorRelationshipTransfersGet structure.
type SnapmirrorRelationshipTransfersGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorRelationshipTransfersGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapmirrorRelationshipTransfersGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorRelationshipTransfersGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorRelationshipTransfersGetOK creates a SnapmirrorRelationshipTransfersGetOK with default headers values
func NewSnapmirrorRelationshipTransfersGetOK() *SnapmirrorRelationshipTransfersGetOK {
	return &SnapmirrorRelationshipTransfersGetOK{}
}

/*
SnapmirrorRelationshipTransfersGetOK describes a response with status code 200, with default header values.

OK
*/
type SnapmirrorRelationshipTransfersGetOK struct {
	Payload *models.SnapmirrorTransferResponse
}

// IsSuccess returns true when this snapmirror relationship transfers get o k response has a 2xx status code
func (o *SnapmirrorRelationshipTransfersGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror relationship transfers get o k response has a 3xx status code
func (o *SnapmirrorRelationshipTransfersGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror relationship transfers get o k response has a 4xx status code
func (o *SnapmirrorRelationshipTransfersGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror relationship transfers get o k response has a 5xx status code
func (o *SnapmirrorRelationshipTransfersGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror relationship transfers get o k response a status code equal to that given
func (o *SnapmirrorRelationshipTransfersGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapmirror relationship transfers get o k response
func (o *SnapmirrorRelationshipTransfersGetOK) Code() int {
	return 200
}

func (o *SnapmirrorRelationshipTransfersGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirrorRelationshipTransfersGetOK %s", 200, payload)
}

func (o *SnapmirrorRelationshipTransfersGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirrorRelationshipTransfersGetOK %s", 200, payload)
}

func (o *SnapmirrorRelationshipTransfersGetOK) GetPayload() *models.SnapmirrorTransferResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipTransfersGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorTransferResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorRelationshipTransfersGetDefault creates a SnapmirrorRelationshipTransfersGetDefault with default headers values
func NewSnapmirrorRelationshipTransfersGetDefault(code int) *SnapmirrorRelationshipTransfersGetDefault {
	return &SnapmirrorRelationshipTransfersGetDefault{
		_statusCode: code,
	}
}

/*
SnapmirrorRelationshipTransfersGetDefault describes a response with status code -1, with default header values.

Error
*/
type SnapmirrorRelationshipTransfersGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror relationship transfers get default response has a 2xx status code
func (o *SnapmirrorRelationshipTransfersGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror relationship transfers get default response has a 3xx status code
func (o *SnapmirrorRelationshipTransfersGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror relationship transfers get default response has a 4xx status code
func (o *SnapmirrorRelationshipTransfersGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror relationship transfers get default response has a 5xx status code
func (o *SnapmirrorRelationshipTransfersGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror relationship transfers get default response a status code equal to that given
func (o *SnapmirrorRelationshipTransfersGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror relationship transfers get default response
func (o *SnapmirrorRelationshipTransfersGetDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorRelationshipTransfersGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirror_relationship_transfers_get default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipTransfersGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships/{relationship.uuid}/transfers][%d] snapmirror_relationship_transfers_get default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipTransfersGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipTransfersGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
