// Code generated by go-swagger; DO NOT EDIT.

package snapmirror

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnapmirrorRelationshipsGetReader is a Reader for the SnapmirrorRelationshipsGet structure.
type SnapmirrorRelationshipsGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnapmirrorRelationshipsGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnapmirrorRelationshipsGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnapmirrorRelationshipsGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnapmirrorRelationshipsGetOK creates a SnapmirrorRelationshipsGetOK with default headers values
func NewSnapmirrorRelationshipsGetOK() *SnapmirrorRelationshipsGetOK {
	return &SnapmirrorRelationshipsGetOK{}
}

/*
SnapmirrorRelationshipsGetOK describes a response with status code 200, with default header values.

OK
*/
type SnapmirrorRelationshipsGetOK struct {
	Payload *models.SnapmirrorRelationshipResponse
}

// IsSuccess returns true when this snapmirror relationships get o k response has a 2xx status code
func (o *SnapmirrorRelationshipsGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snapmirror relationships get o k response has a 3xx status code
func (o *SnapmirrorRelationshipsGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snapmirror relationships get o k response has a 4xx status code
func (o *SnapmirrorRelationshipsGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snapmirror relationships get o k response has a 5xx status code
func (o *SnapmirrorRelationshipsGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snapmirror relationships get o k response a status code equal to that given
func (o *SnapmirrorRelationshipsGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snapmirror relationships get o k response
func (o *SnapmirrorRelationshipsGetOK) Code() int {
	return 200
}

func (o *SnapmirrorRelationshipsGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships][%d] snapmirrorRelationshipsGetOK %s", 200, payload)
}

func (o *SnapmirrorRelationshipsGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships][%d] snapmirrorRelationshipsGetOK %s", 200, payload)
}

func (o *SnapmirrorRelationshipsGetOK) GetPayload() *models.SnapmirrorRelationshipResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipsGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapmirrorRelationshipResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnapmirrorRelationshipsGetDefault creates a SnapmirrorRelationshipsGetDefault with default headers values
func NewSnapmirrorRelationshipsGetDefault(code int) *SnapmirrorRelationshipsGetDefault {
	return &SnapmirrorRelationshipsGetDefault{
		_statusCode: code,
	}
}

/*
	SnapmirrorRelationshipsGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13303825    | Could not retrieve information for the SnapMirror policy type |
| 13303817    | Unknown value for the Snapmirror State |
*/
type SnapmirrorRelationshipsGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snapmirror relationships get default response has a 2xx status code
func (o *SnapmirrorRelationshipsGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snapmirror relationships get default response has a 3xx status code
func (o *SnapmirrorRelationshipsGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snapmirror relationships get default response has a 4xx status code
func (o *SnapmirrorRelationshipsGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snapmirror relationships get default response has a 5xx status code
func (o *SnapmirrorRelationshipsGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snapmirror relationships get default response a status code equal to that given
func (o *SnapmirrorRelationshipsGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snapmirror relationships get default response
func (o *SnapmirrorRelationshipsGetDefault) Code() int {
	return o._statusCode
}

func (o *SnapmirrorRelationshipsGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships][%d] snapmirror_relationships_get default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipsGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /snapmirror/relationships][%d] snapmirror_relationships_get default %s", o._statusCode, payload)
}

func (o *SnapmirrorRelationshipsGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnapmirrorRelationshipsGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
